/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.util.Log;
import android.widget.RemoteViews;
import java.text.NumberFormat;
import org.mozilla.gecko.R;
import org.mozilla.gecko.gfx.BitmapUtils;

public class AlertNotification
extends Notification {
    private static final String LOGTAG = "GeckoAlertNotification";
    private final int mId;
    private final int mIcon;
    private final String mTitle;
    private final String mText;
    private final NotificationManager mNotificationManager;
    private boolean mProgressStyle;
    private double mPrevPercent = -1.0;
    private String mPrevAlertText = "";
    private static final double UPDATE_THRESHOLD = 0.01;
    private Context mContext;

    public AlertNotification(Context context, int n, int n2, String string2, String string3, long l, Uri uri) {
        super(n2, (CharSequence)(string3.length() > 0 ? string3 : string2), l);
        this.mIcon = n2;
        this.mTitle = string2;
        this.mText = string3;
        this.mId = n;
        this.mContext = context;
        this.mNotificationManager = (NotificationManager)context.getSystemService("notification");
        if (uri == null || uri.getScheme() == null) {
            return;
        }
        int n3 = R.layout.notification_icon_text;
        RemoteViews remoteViews = new RemoteViews(this.mContext.getPackageName(), n3);
        try {
            Bitmap bitmap = BitmapUtils.decodeUrl(uri);
            if (bitmap == null) {
                Log.e((String)LOGTAG, (String)"failed to decode icon");
                return;
            }
            remoteViews.setImageViewBitmap(R.id.notification_image, bitmap);
            remoteViews.setTextViewText(R.id.notification_title, (CharSequence)this.mTitle);
            if (this.mText.length() > 0) {
                remoteViews.setTextViewText(R.id.notification_text, (CharSequence)this.mText);
            }
            this.contentView = remoteViews;
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"failed to create bitmap", (Throwable)exception);
        }
    }

    public int getId() {
        return this.mId;
    }

    public synchronized boolean isProgressStyle() {
        return this.mProgressStyle;
    }

    public void show() {
        this.mNotificationManager.notify(this.mId, (Notification)this);
    }

    public void cancel() {
        this.mNotificationManager.cancel(this.mId);
    }

    public synchronized void updateProgress(String string2, long l, long l2) {
        String string3;
        if (!this.mProgressStyle) {
            int n = string2.length() > 0 ? R.layout.notification_progress_text : R.layout.notification_progress;
            RemoteViews remoteViews = new RemoteViews(this.mContext.getPackageName(), n);
            remoteViews.setImageViewResource(R.id.notification_image, this.mIcon);
            remoteViews.setTextViewText(R.id.notification_title, (CharSequence)this.mTitle);
            this.contentView = remoteViews;
            this.flags |= 0xA;
            this.mProgressStyle = true;
        }
        double d = 0.0;
        if (l2 > 0L) {
            d = (double)l / (double)l2;
        }
        if (this.mPrevAlertText.equals(string3 = string2.length() > 0 ? string2 : NumberFormat.getPercentInstance().format(d)) && Math.abs(this.mPrevPercent - d) < 0.01) {
            return;
        }
        this.contentView.setTextViewText(R.id.notification_text, (CharSequence)string3);
        this.contentView.setProgressBar(R.id.notification_progressbar, (int)l2, (int)l, false);
        this.mNotificationManager.notify(this.mId, (Notification)this);
        this.mPrevPercent = d;
        this.mPrevAlertText = string3;
    }
}

