/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.support.v4.util.LruCache;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.db.DBUtils;
import org.mozilla.gecko.db.URLMetadataTable;
import org.mozilla.gecko.util.ThreadUtils;

public class URLMetadata {
    private static final String LOGTAG = "GeckoURLMetadata";
    private static final int CACHE_SIZE = 9;
    private static final LruCache<String, Map<String, Object>> cache = new LruCache(9);

    private static final Set<String> getModel() {
        return new HashSet<String>(){
            {
                this.add("url");
                this.add("tileImage");
                this.add("tileColor");
            }
        };
    }

    public static Map<String, Object> fromJSON(JSONObject jSONObject) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Set<String> set = URLMetadata.getModel();
        for (String string2 : set) {
            if (!jSONObject.has(string2)) continue;
            hashMap.put(string2, jSONObject.optString(string2));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    private static Map<String, Object> fromCursor(Cursor cursor) {
        String[] stringArray;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Set<String> set = URLMetadata.getModel();
        for (String string2 : stringArray = cursor.getColumnNames()) {
            if (!set.contains(string2)) continue;
            try {
                hashMap.put(string2, cursor.getString(cursor.getColumnIndexOrThrow(string2)));
            }
            catch (Exception exception) {
                Log.i((String)LOGTAG, (String)("Error getting data for " + string2), (Throwable)exception);
            }
        }
        return Collections.unmodifiableMap(hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Map<String, Object>> getForUrls(ContentResolver contentResolver, List<String> list, List<String> list2) {
        Map<String, Object> map;
        String string22;
        ThreadUtils.assertNotOnUiThread();
        ThreadUtils.assertNotOnGeckoThread();
        HashMap<String, Map<String, Object>> hashMap = new HashMap<String, Map<String, Object>>();
        if (list.isEmpty() || list2.isEmpty()) {
            Log.e((String)LOGTAG, (String)"Queried metadata for nothing");
            return hashMap;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string22 : list) {
            map = (Map<String, Map<String, Object>>)cache.get((Object)string22);
            if (map != null) {
                hashMap.put(string22, map);
                continue;
            }
            arrayList.add(string22);
        }
        Telemetry.HistogramAdd("FENNEC_TILES_CACHE_HIT", hashMap.size());
        if (arrayList.size() == 0) {
            return Collections.unmodifiableMap(hashMap);
        }
        String string3 = DBUtils.computeSQLInClause(arrayList.size(), "url");
        if (!list2.contains("url")) {
            list2.add("url");
        }
        string22 = contentResolver.query(URLMetadataTable.CONTENT_URI, list2.toArray(new String[list2.size()]), string3, arrayList.toArray(new String[arrayList.size()]), null);
        try {
            if (!string22.moveToFirst()) {
                map = Collections.unmodifiableMap(hashMap);
                return map;
            }
            do {
                map = URLMetadata.fromCursor((Cursor)string22);
                String string4 = string22.getString(string22.getColumnIndexOrThrow("url"));
                hashMap.put(string4, map);
                cache.put((Object)string4, map);
            } while (string22.moveToNext());
        }
        finally {
            string22.close();
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public static void save(ContentResolver contentResolver, String string2, Map<String, Object> map) {
        ThreadUtils.assertNotOnUiThread();
        ThreadUtils.assertNotOnGeckoThread();
        try {
            ContentValues contentValues = new ContentValues();
            Set<String> set = URLMetadata.getModel();
            for (String string3 : set) {
                if (!map.containsKey(string3)) continue;
                contentValues.put(string3, (String)map.get(string3));
            }
            if (contentValues.size() == 0) {
                return;
            }
            Uri uri = URLMetadataTable.CONTENT_URI.buildUpon().appendQueryParameter("insert_if_needed", "true").build();
            contentResolver.update(uri, contentValues, "url=?", new String[]{(String)map.get("url")});
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"error saving", (Throwable)exception);
        }
    }

    public static int deleteUnused(ContentResolver contentResolver) {
        return contentResolver.delete(URLMetadataTable.CONTENT_URI, "url NOT IN (SELECT url FROM history WHERE deleted = 0 UNION  SELECT url FROM bookmarks WHERE deleted = 0  AND url IS NOT NULL)", null);
    }
}

