/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.TextView;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountClient10;
import org.mozilla.gecko.background.fxa.FxAccountClient20;
import org.mozilla.gecko.background.fxa.FxAccountClientException;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.background.fxa.PasswordStretcher;
import org.mozilla.gecko.fxa.FirefoxAccounts;
import org.mozilla.gecko.fxa.FxAccountConstants;
import org.mozilla.gecko.fxa.activities.FxAccountAbstractSetupActivity;
import org.mozilla.gecko.fxa.activities.FxAccountStatusActivity;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.login.Engaged;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.fxa.tasks.FxAccountSignInTask;
import org.mozilla.gecko.sync.setup.activities.ActivityUtils;

public class FxAccountUpdateCredentialsActivity
extends FxAccountAbstractSetupActivity {
    protected static final String LOG_TAG = FxAccountUpdateCredentialsActivity.class.getSimpleName();
    protected AndroidFxAccount fxAccount;

    public FxAccountUpdateCredentialsActivity() {
        super(2);
    }

    @Override
    public void onCreate(Bundle bundle) {
        Logger.debug(LOG_TAG, "onCreate(" + bundle + ")");
        super.onCreate(bundle);
        this.setContentView(R.layout.fxaccount_update_credentials);
        this.emailEdit = (AutoCompleteTextView)this.ensureFindViewById(null, R.id.email, "email edit");
        this.passwordEdit = (EditText)this.ensureFindViewById(null, R.id.password, "password edit");
        this.showPasswordButton = (Button)this.ensureFindViewById(null, R.id.show_password, "show password button");
        this.remoteErrorTextView = (TextView)this.ensureFindViewById(null, R.id.remote_error, "remote error text view");
        this.button = (Button)this.ensureFindViewById(null, R.id.button, "update credentials");
        this.progressBar = (ProgressBar)this.ensureFindViewById(null, R.id.progress, "progress bar");
        this.minimumPasswordLength = 1;
        this.createButton();
        this.addListeners();
        this.updateButtonState();
        this.createShowPasswordButton();
        this.emailEdit.setEnabled(false);
        TextView textView = (TextView)this.findViewById(R.id.forgot_password_link);
        ActivityUtils.linkTextView(textView, R.string.fxaccount_sign_in_forgot_password, R.string.fxaccount_link_forgot_password);
        this.updateFromIntentExtras();
    }

    @Override
    public void onResume() {
        super.onResume();
        this.fxAccount = this.getAndroidFxAccount();
        if (this.fxAccount == null) {
            Logger.warn(LOG_TAG, "Could not get Firefox Account.");
            this.setResult(0);
            this.finish();
            return;
        }
        State state = this.fxAccount.getState();
        if (state.getStateLabel() != State.StateLabel.Separated) {
            Logger.warn(LOG_TAG, "Cannot update credentials from Firefox Account in state: " + (Object)((Object)state.getStateLabel()));
            this.setResult(0);
            this.finish();
            return;
        }
        this.emailEdit.setText((CharSequence)this.fxAccount.getEmail());
    }

    public void updateCredentials(String string2, String string3) {
        String string4 = this.fxAccount.getAccountServerURI();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        FxAccountClient20 fxAccountClient20 = new FxAccountClient20(string4, executorService);
        PasswordStretcher passwordStretcher = this.makePasswordStretcher(string3);
        try {
            this.hideRemoteError();
            UpdateCredentialsDelegate updateCredentialsDelegate = new UpdateCredentialsDelegate(string2, passwordStretcher, string4);
            new FxAccountSignInTask((Context)this, this, string2, passwordStretcher, fxAccountClient20, updateCredentialsDelegate).execute(new Void[0]);
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception updating credentials for account.", exception);
            this.showRemoteError(exception, R.string.fxaccount_update_credentials_unknown_error);
        }
    }

    protected void createButton() {
        this.button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String string2 = FxAccountUpdateCredentialsActivity.this.emailEdit.getText().toString();
                String string3 = FxAccountUpdateCredentialsActivity.this.passwordEdit.getText().toString();
                FxAccountUpdateCredentialsActivity.this.updateCredentials(string2, string3);
            }
        });
    }

    protected class UpdateCredentialsDelegate
    implements FxAccountClient10.RequestDelegate<FxAccountClient20.LoginResponse> {
        public final String email;
        public final String serverURI;
        public final PasswordStretcher passwordStretcher;

        public UpdateCredentialsDelegate(String string2, PasswordStretcher passwordStretcher, String string3) {
            this.email = string2;
            this.serverURI = string3;
            this.passwordStretcher = passwordStretcher;
        }

        @Override
        public void handleError(Exception exception) {
            FxAccountUpdateCredentialsActivity.this.showRemoteError(exception, R.string.fxaccount_update_credentials_unknown_error);
        }

        @Override
        public void handleFailure(FxAccountClientException.FxAccountClientRemoteException fxAccountClientRemoteException) {
            if (fxAccountClientRemoteException.isUpgradeRequired()) {
                Logger.error(LOG_TAG, "Got upgrade required from remote server; transitioning Firefox Account to Doghouse state.");
                State state = FxAccountUpdateCredentialsActivity.this.fxAccount.getState();
                FxAccountUpdateCredentialsActivity.this.fxAccount.setState(state.makeDoghouseState());
                FxAccountUpdateCredentialsActivity.this.redirectToActivity(FxAccountStatusActivity.class);
                return;
            }
            FxAccountUpdateCredentialsActivity.this.showRemoteError(fxAccountClientRemoteException, R.string.fxaccount_update_credentials_unknown_error);
        }

        @Override
        public void handleSuccess(FxAccountClient20.LoginResponse loginResponse) {
            byte[] byArray;
            Logger.info(LOG_TAG, "Got success signing in.");
            if (FxAccountUpdateCredentialsActivity.this.fxAccount == null) {
                this.handleError(new IllegalStateException("fxAccount must not be null"));
                return;
            }
            try {
                byte[] byArray2 = this.passwordStretcher.getQuickStretchedPW(loginResponse.remoteEmail.getBytes("UTF-8"));
                byArray = FxAccountUtils.generateUnwrapBKey(byArray2);
            }
            catch (Exception exception) {
                this.handleError(exception);
                return;
            }
            FxAccountUpdateCredentialsActivity.this.fxAccount.setState(new Engaged(this.email, loginResponse.uid, loginResponse.verified, byArray, loginResponse.sessionToken, loginResponse.keyFetchToken));
            FxAccountUpdateCredentialsActivity.this.fxAccount.requestSync(FirefoxAccounts.FORCE);
            if (FxAccountConstants.LOG_PERSONAL_INFORMATION) {
                FxAccountUpdateCredentialsActivity.this.fxAccount.dump();
            }
            FxAccountUpdateCredentialsActivity.this.setResult(-1);
            FxAccountUpdateCredentialsActivity.this.finish();
        }
    }
}

