/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.sync;

import android.accounts.Account;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Bundle;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.fxa.sync.SchedulePolicy;
import org.mozilla.gecko.sync.BackoffHandler;

public class FxAccountSchedulePolicy
implements SchedulePolicy {
    private static final String LOG_TAG = "FxAccountSchedulePolicy";
    public static final long POLL_INTERVAL_PENDING_VERIFICATION = 60L;
    public static final long POLL_INTERVAL_ERROR_STATE_SEC = 86400L;
    public static final long POLL_INTERVAL_SINGLE_DEVICE_SEC = 64800L;
    public static final long POLL_INTERVAL_MULTI_DEVICE_SEC = 43200L;
    private static volatile long POLL_INTERVAL_CURRENT_SEC = 64800L;
    public static final long RATE_LIMIT_FUNDAMENTAL_SEC = 90L;
    public static final long RATE_LIMIT_BACKGROUND_SEC = 3600L;
    private final AndroidFxAccount account;
    private final Context context;

    public FxAccountSchedulePolicy(Context context, AndroidFxAccount androidFxAccount) {
        this.account = androidFxAccount;
        this.context = context;
    }

    private static long delay(long l) {
        return System.currentTimeMillis() + l;
    }

    protected void requestPeriodicSync(long l) {
        Account account = this.account.getAndroidAccount();
        this.context.getContentResolver();
        Logger.info(LOG_TAG, "Scheduling periodic sync for " + l + ".");
        ContentResolver.addPeriodicSync((Account)account, (String)"org.mozilla.fennec.db.browser", (Bundle)Bundle.EMPTY, (long)l);
        POLL_INTERVAL_CURRENT_SEC = l;
    }

    @Override
    public void onSuccessfulSync(int n) {
        long l = n > 0 ? 43200L : 64800L;
        this.requestPeriodicSync(l);
    }

    @Override
    public void onHandleFinal(State.Action action) {
        switch (action) {
            case NeedsPassword: 
            case NeedsUpgrade: {
                this.requestPeriodicSync(86400L);
                break;
            }
            case NeedsVerification: {
                this.requestPeriodicSync(60L);
                break;
            }
        }
    }

    @Override
    public void onUpgradeRequired() {
        this.requestPeriodicSync(86400L);
    }

    @Override
    public void onUnauthorized() {
        this.requestPeriodicSync(86400L);
    }

    @Override
    public void configureBackoffMillisOnBackoff(BackoffHandler backoffHandler, long l, boolean bl) {
        if (bl) {
            backoffHandler.extendEarliestNextRequest(FxAccountSchedulePolicy.delay(l));
        } else {
            backoffHandler.setEarliestNextRequest(FxAccountSchedulePolicy.delay(l));
        }
        if (l > POLL_INTERVAL_CURRENT_SEC * 1000L) {
            this.requestPeriodicSync((long)Math.ceil(1.05 * (double)l / 1000.0));
        }
    }

    @Override
    public void configureBackoffMillisBeforeSyncing(BackoffHandler backoffHandler, BackoffHandler backoffHandler2) {
        backoffHandler.setEarliestNextRequest(FxAccountSchedulePolicy.delay(90000L));
        backoffHandler2.setEarliestNextRequest(FxAccountSchedulePolicy.delay(3600000L));
    }
}

