/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.graphics.Rect;
import android.opengl.GLES20;
import android.util.Log;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.mozilla.gecko.gfx.CairoGLInfo;
import org.mozilla.gecko.gfx.CairoImage;
import org.mozilla.gecko.gfx.IntSize;
import org.mozilla.gecko.gfx.Layer;
import org.mozilla.gecko.gfx.TextureReaper;

public abstract class TileLayer
extends Layer {
    private static final String LOGTAG = "GeckoTileLayer";
    private final Rect mDirtyRect;
    private IntSize mSize;
    private int[] mTextureIDs;
    protected final CairoImage mImage;
    private PaintMode mPaintMode;

    public TileLayer(CairoImage cairoImage, PaintMode paintMode) {
        super(cairoImage.getSize());
        this.mPaintMode = paintMode;
        this.mImage = cairoImage;
        this.mSize = new IntSize(0, 0);
        this.mDirtyRect = new Rect();
    }

    protected boolean repeats() {
        return this.mPaintMode == PaintMode.REPEAT;
    }

    protected boolean stretches() {
        return this.mPaintMode == PaintMode.STRETCH;
    }

    protected int getTextureID() {
        return this.mTextureIDs[0];
    }

    protected boolean initialized() {
        return this.mImage != null && this.mTextureIDs != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.mTextureIDs != null) {
                TextureReaper.get().add(this.mTextureIDs);
            }
        }
        finally {
            super.finalize();
        }
    }

    public void destroy() {
        try {
            if (this.mImage != null) {
                this.mImage.destroy();
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"error clearing buffers: ", (Throwable)exception);
        }
    }

    public void setPaintMode(PaintMode paintMode) {
        this.mPaintMode = paintMode;
    }

    public void invalidate() {
        if (!this.inTransaction()) {
            throw new RuntimeException("invalidate() is only valid inside a transaction");
        }
        IntSize intSize = this.mImage.getSize();
        this.mDirtyRect.set(0, 0, intSize.width, intSize.height);
    }

    private void validateTexture() {
        IntSize intSize = this.mImage.getSize().nextPowerOfTwo();
        if (!intSize.equals(this.mSize)) {
            this.mSize = intSize;
            if (this.mTextureIDs != null) {
                TextureReaper.get().add(this.mTextureIDs);
                this.mTextureIDs = null;
                TextureReaper.get().reap();
            }
        }
    }

    @Override
    protected void performUpdates(Layer.RenderContext renderContext) {
        super.performUpdates(renderContext);
        this.validateTexture();
        if (!this.mImage.getSize().isPositive()) {
            return;
        }
        if (this.mTextureIDs == null) {
            this.uploadFullTexture();
        } else {
            this.uploadDirtyRect(this.mDirtyRect);
        }
        this.mDirtyRect.setEmpty();
    }

    private void uploadFullTexture() {
        IntSize intSize = this.mImage.getSize();
        this.uploadDirtyRect(new Rect(0, 0, intSize.width, intSize.height));
    }

    private void uploadDirtyRect(Rect rect) {
        if (rect.isEmpty()) {
            return;
        }
        ByteBuffer byteBuffer = this.mImage.getBuffer();
        if (byteBuffer == null) {
            return;
        }
        if (this.mTextureIDs == null) {
            this.mTextureIDs = new int[1];
            GLES20.glGenTextures((int)this.mTextureIDs.length, (int[])this.mTextureIDs, (int)0);
        }
        int n = this.mImage.getFormat();
        CairoGLInfo cairoGLInfo = new CairoGLInfo(n);
        this.bindAndSetGLParameters();
        IntSize intSize = this.mImage.getSize();
        if (!this.mSize.equals(intSize)) {
            throw new RuntimeException("Buffer/image size mismatch in TileLayer!");
        }
        GLES20.glTexImage2D((int)3553, (int)0, (int)cairoGLInfo.internalFormat, (int)this.mSize.width, (int)this.mSize.height, (int)0, (int)cairoGLInfo.format, (int)cairoGLInfo.type, (Buffer)byteBuffer);
    }

    private void bindAndSetGLParameters() {
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.mTextureIDs[0]);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        int n = this.repeats() ? 10497 : 33071;
        GLES20.glTexParameterf((int)3553, (int)10242, (float)n);
        GLES20.glTexParameterf((int)3553, (int)10243, (float)n);
    }

    public static enum PaintMode {
        NORMAL,
        REPEAT,
        STRETCH;

    }
}

