/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.Cursor;
import android.support.v4.widget.CursorAdapter;
import android.view.View;
import android.view.ViewGroup;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.home.PanelBackItemView;
import org.mozilla.gecko.home.PanelItemView;
import org.mozilla.gecko.home.PanelLayout;

class PanelViewAdapter
extends CursorAdapter {
    private static final int VIEW_TYPE_ITEM = 0;
    private static final int VIEW_TYPE_BACK = 1;
    private final HomeConfig.ViewConfig viewConfig;
    private PanelLayout.FilterManager filterManager;
    private final Context context;

    public PanelViewAdapter(Context context, HomeConfig.ViewConfig viewConfig) {
        super(context, null, 0);
        this.context = context;
        this.viewConfig = viewConfig;
    }

    public void setFilterManager(PanelLayout.FilterManager filterManager) {
        this.filterManager = filterManager;
    }

    public final int getViewTypeCount() {
        return 2;
    }

    public int getCount() {
        return super.getCount() + (this.isShowingBack() ? 1 : 0);
    }

    public int getItemViewType(int n) {
        if (this.isShowingBack() && n == 0) {
            return 1;
        }
        return 0;
    }

    public final View getView(int n, View view, ViewGroup viewGroup) {
        if (view == null) {
            view = this.newView(viewGroup.getContext(), n, viewGroup);
        }
        this.bindView(view, n);
        return view;
    }

    private View newView(Context context, int n, ViewGroup viewGroup) {
        if (this.getItemViewType(n) == 1) {
            return new PanelBackItemView(context, this.viewConfig.getBackImageUrl());
        }
        return PanelItemView.create(context, this.viewConfig.getItemType());
    }

    private void bindView(View view, int n) {
        if (this.isShowingBack()) {
            if (n == 0) {
                PanelBackItemView panelBackItemView = (PanelBackItemView)view;
                panelBackItemView.updateFromFilter(this.filterManager.getPreviousFilter());
                return;
            }
            --n;
        }
        Cursor cursor = this.getCursor(n);
        PanelItemView panelItemView = (PanelItemView)view;
        panelItemView.updateFromCursor(cursor);
    }

    private boolean isShowingBack() {
        return this.filterManager != null ? this.filterManager.canGoBack() : false;
    }

    private final Cursor getCursor(int n) {
        Cursor cursor = this.getCursor();
        if (cursor == null || !cursor.moveToPosition(n)) {
            throw new IllegalStateException("Couldn't move cursor to position " + n);
        }
        return cursor;
    }

    public final void bindView(View view, Context context, Cursor cursor) {
    }

    public final View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
        return null;
    }
}

