/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.jpake.stage;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.NonObjectJSONException;
import org.mozilla.gecko.sync.jpake.IncorrectZkpException;
import org.mozilla.gecko.sync.jpake.JPakeClient;
import org.mozilla.gecko.sync.jpake.JPakeCrypto;
import org.mozilla.gecko.sync.jpake.Zkp;
import org.mozilla.gecko.sync.jpake.stage.JPakeStage;

public class ComputeFinalStage
extends JPakeStage {
    @Override
    public void execute(JPakeClient jPakeClient) {
        ExtendedJSONObject extendedJSONObject;
        ExtendedJSONObject extendedJSONObject2;
        Logger.debug("SyncJPakeStage", "Computing final round.");
        if (!jPakeClient.jIncoming.get("type").equals(jPakeClient.theirSignerId + "2")) {
            Logger.error("SyncJPakeStage", "Invalid round 2 message: " + jPakeClient.jIncoming.toJSONString());
            jPakeClient.abort("jpake.error.wrongmessage");
            return;
        }
        try {
            extendedJSONObject2 = jPakeClient.jIncoming.getObject("payload");
            if (extendedJSONObject2 == null || extendedJSONObject2.getObject("zkp_A") == null) {
                Logger.error("SyncJPakeStage", "Invalid round 2 message: " + jPakeClient.jIncoming.toJSONString());
                jPakeClient.abort("jpake.error.wrongmessage");
                return;
            }
            extendedJSONObject = extendedJSONObject2.getObject("zkp_A");
        }
        catch (NonObjectJSONException nonObjectJSONException) {
            Logger.error("SyncJPakeStage", "JSON object Exception.", nonObjectJSONException);
            jPakeClient.abort("jpake.error.invalid");
            return;
        }
        if (!jPakeClient.theirSignerId.equals(extendedJSONObject.get("id"))) {
            Logger.error("SyncJPakeStage", "Invalid round 2 message: " + jPakeClient.jIncoming.toJSONString());
            jPakeClient.abort("jpake.error.wrongmessage");
            return;
        }
        jPakeClient.jParty.otherA = new BigInteger((String)extendedJSONObject2.get("A"), 16);
        String string2 = (String)extendedJSONObject.get("gr");
        String string3 = (String)extendedJSONObject.get("b");
        String string4 = (String)extendedJSONObject.get("id");
        jPakeClient.jParty.otherZkpA = new Zkp(new BigInteger(string2, 16), new BigInteger(string3, 16), string4);
        jPakeClient.myKeyBundle = null;
        try {
            jPakeClient.myKeyBundle = JPakeCrypto.finalRound(JPakeClient.secretAsBigInteger(jPakeClient.secret), jPakeClient.jParty);
        }
        catch (IncorrectZkpException incorrectZkpException) {
            Logger.error("SyncJPakeStage", "ZKP mismatch");
            jPakeClient.abort("jpake.error.wrongmessage");
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Logger.error("SyncJPakeStage", "NoSuchAlgorithmException", noSuchAlgorithmException);
            jPakeClient.abort("jpake.error.internal");
            return;
        }
        catch (InvalidKeyException invalidKeyException) {
            Logger.error("SyncJPakeStage", "InvalidKeyException", invalidKeyException);
            jPakeClient.abort("jpake.error.internal");
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.error("SyncJPakeStage", "UnsupportedEncodingException", unsupportedEncodingException);
            jPakeClient.abort("jpake.error.internal");
            return;
        }
        jPakeClient.runNextStage();
    }
}

