/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.client.cache;

import ch.boye.httpclientandroidlib.util.Args;

public class CacheConfig
implements Cloneable {
    public static final int DEFAULT_MAX_OBJECT_SIZE_BYTES = 8192;
    public static final int DEFAULT_MAX_CACHE_ENTRIES = 1000;
    public static final int DEFAULT_MAX_UPDATE_RETRIES = 1;
    public static final boolean DEFAULT_303_CACHING_ENABLED = false;
    public static final boolean DEFAULT_WEAK_ETAG_ON_PUTDELETE_ALLOWED = false;
    public static final boolean DEFAULT_HEURISTIC_CACHING_ENABLED = false;
    public static final float DEFAULT_HEURISTIC_COEFFICIENT = 0.1f;
    public static final long DEFAULT_HEURISTIC_LIFETIME = 0L;
    public static final int DEFAULT_ASYNCHRONOUS_WORKERS_MAX = 1;
    public static final int DEFAULT_ASYNCHRONOUS_WORKERS_CORE = 1;
    public static final int DEFAULT_ASYNCHRONOUS_WORKER_IDLE_LIFETIME_SECS = 60;
    public static final int DEFAULT_REVALIDATION_QUEUE_SIZE = 100;
    public static final CacheConfig DEFAULT = new Builder().build();
    private long maxObjectSize;
    private int maxCacheEntries;
    private int maxUpdateRetries;
    private boolean allow303Caching;
    private boolean weakETagOnPutDeleteAllowed;
    private boolean heuristicCachingEnabled;
    private float heuristicCoefficient;
    private long heuristicDefaultLifetime;
    private boolean isSharedCache;
    private int asynchronousWorkersMax;
    private int asynchronousWorkersCore;
    private int asynchronousWorkerIdleLifetimeSecs;
    private int revalidationQueueSize;
    private boolean neverCacheHTTP10ResponsesWithQuery;

    @Deprecated
    public CacheConfig() {
        this.maxObjectSize = 8192L;
        this.maxCacheEntries = 1000;
        this.maxUpdateRetries = 1;
        this.allow303Caching = false;
        this.weakETagOnPutDeleteAllowed = false;
        this.heuristicCachingEnabled = false;
        this.heuristicCoefficient = 0.1f;
        this.heuristicDefaultLifetime = 0L;
        this.isSharedCache = true;
        this.asynchronousWorkersMax = 1;
        this.asynchronousWorkersCore = 1;
        this.asynchronousWorkerIdleLifetimeSecs = 60;
        this.revalidationQueueSize = 100;
    }

    CacheConfig(long l, int n, int n2, boolean bl, boolean bl2, boolean bl3, float f, long l2, boolean bl4, int n3, int n4, int n5, int n6, boolean bl5) {
        this.maxObjectSize = l;
        this.maxCacheEntries = n;
        this.maxUpdateRetries = n2;
        this.allow303Caching = bl;
        this.weakETagOnPutDeleteAllowed = bl2;
        this.heuristicCachingEnabled = bl3;
        this.heuristicCoefficient = f;
        this.heuristicDefaultLifetime = l2;
        this.isSharedCache = bl4;
        this.asynchronousWorkersMax = n3;
        this.asynchronousWorkersCore = n4;
        this.asynchronousWorkerIdleLifetimeSecs = n5;
        this.revalidationQueueSize = n6;
    }

    @Deprecated
    public int getMaxObjectSizeBytes() {
        return this.maxObjectSize > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.maxObjectSize;
    }

    @Deprecated
    public void setMaxObjectSizeBytes(int n) {
        this.maxObjectSize = n > Integer.MAX_VALUE ? Integer.MAX_VALUE : (long)n;
    }

    public long getMaxObjectSize() {
        return this.maxObjectSize;
    }

    @Deprecated
    public void setMaxObjectSize(long l) {
        this.maxObjectSize = l;
    }

    public boolean isNeverCacheHTTP10ResponsesWithQuery() {
        return this.neverCacheHTTP10ResponsesWithQuery;
    }

    public int getMaxCacheEntries() {
        return this.maxCacheEntries;
    }

    @Deprecated
    public void setMaxCacheEntries(int n) {
        this.maxCacheEntries = n;
    }

    public int getMaxUpdateRetries() {
        return this.maxUpdateRetries;
    }

    @Deprecated
    public void setMaxUpdateRetries(int n) {
        this.maxUpdateRetries = n;
    }

    public boolean is303CachingEnabled() {
        return this.allow303Caching;
    }

    public boolean isWeakETagOnPutDeleteAllowed() {
        return this.weakETagOnPutDeleteAllowed;
    }

    public boolean isHeuristicCachingEnabled() {
        return this.heuristicCachingEnabled;
    }

    @Deprecated
    public void setHeuristicCachingEnabled(boolean bl) {
        this.heuristicCachingEnabled = bl;
    }

    public float getHeuristicCoefficient() {
        return this.heuristicCoefficient;
    }

    @Deprecated
    public void setHeuristicCoefficient(float f) {
        this.heuristicCoefficient = f;
    }

    public long getHeuristicDefaultLifetime() {
        return this.heuristicDefaultLifetime;
    }

    @Deprecated
    public void setHeuristicDefaultLifetime(long l) {
        this.heuristicDefaultLifetime = l;
    }

    public boolean isSharedCache() {
        return this.isSharedCache;
    }

    @Deprecated
    public void setSharedCache(boolean bl) {
        this.isSharedCache = bl;
    }

    public int getAsynchronousWorkersMax() {
        return this.asynchronousWorkersMax;
    }

    @Deprecated
    public void setAsynchronousWorkersMax(int n) {
        this.asynchronousWorkersMax = n;
    }

    public int getAsynchronousWorkersCore() {
        return this.asynchronousWorkersCore;
    }

    @Deprecated
    public void setAsynchronousWorkersCore(int n) {
        this.asynchronousWorkersCore = n;
    }

    public int getAsynchronousWorkerIdleLifetimeSecs() {
        return this.asynchronousWorkerIdleLifetimeSecs;
    }

    @Deprecated
    public void setAsynchronousWorkerIdleLifetimeSecs(int n) {
        this.asynchronousWorkerIdleLifetimeSecs = n;
    }

    public int getRevalidationQueueSize() {
        return this.revalidationQueueSize;
    }

    @Deprecated
    public void setRevalidationQueueSize(int n) {
        this.revalidationQueueSize = n;
    }

    protected CacheConfig clone() throws CloneNotSupportedException {
        return (CacheConfig)super.clone();
    }

    public static Builder custom() {
        return new Builder();
    }

    public static Builder copy(CacheConfig cacheConfig) {
        Args.notNull(cacheConfig, "Cache config");
        return new Builder().setMaxObjectSize(cacheConfig.getMaxObjectSize()).setMaxCacheEntries(cacheConfig.getMaxCacheEntries()).setMaxUpdateRetries(cacheConfig.getMaxUpdateRetries()).setHeuristicCachingEnabled(cacheConfig.isHeuristicCachingEnabled()).setHeuristicCoefficient(cacheConfig.getHeuristicCoefficient()).setHeuristicDefaultLifetime(cacheConfig.getHeuristicDefaultLifetime()).setSharedCache(cacheConfig.isSharedCache()).setAsynchronousWorkersMax(cacheConfig.getAsynchronousWorkersMax()).setAsynchronousWorkersCore(cacheConfig.getAsynchronousWorkersCore()).setAsynchronousWorkerIdleLifetimeSecs(cacheConfig.getAsynchronousWorkerIdleLifetimeSecs()).setRevalidationQueueSize(cacheConfig.getRevalidationQueueSize()).setNeverCacheHTTP10ResponsesWithQueryString(cacheConfig.isNeverCacheHTTP10ResponsesWithQuery());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[maxObjectSize=").append(this.maxObjectSize).append(", maxCacheEntries=").append(this.maxCacheEntries).append(", maxUpdateRetries=").append(this.maxUpdateRetries).append(", 303CachingEnabled=").append(this.allow303Caching).append(", weakETagOnPutDeleteAllowed=").append(this.weakETagOnPutDeleteAllowed).append(", heuristicCachingEnabled=").append(this.heuristicCachingEnabled).append(", heuristicCoefficient=").append(this.heuristicCoefficient).append(", heuristicDefaultLifetime=").append(this.heuristicDefaultLifetime).append(", isSharedCache=").append(this.isSharedCache).append(", asynchronousWorkersMax=").append(this.asynchronousWorkersMax).append(", asynchronousWorkersCore=").append(this.asynchronousWorkersCore).append(", asynchronousWorkerIdleLifetimeSecs=").append(this.asynchronousWorkerIdleLifetimeSecs).append(", revalidationQueueSize=").append(this.revalidationQueueSize).append(", neverCacheHTTP10ResponsesWithQuery=").append(this.neverCacheHTTP10ResponsesWithQuery).append("]");
        return stringBuilder.toString();
    }

    public static class Builder {
        private long maxObjectSize = 8192L;
        private int maxCacheEntries = 1000;
        private int maxUpdateRetries = 1;
        private boolean allow303Caching = false;
        private boolean weakETagOnPutDeleteAllowed = false;
        private boolean heuristicCachingEnabled = false;
        private float heuristicCoefficient = 0.1f;
        private long heuristicDefaultLifetime = 0L;
        private boolean isSharedCache = true;
        private int asynchronousWorkersMax = 1;
        private int asynchronousWorkersCore = 1;
        private int asynchronousWorkerIdleLifetimeSecs = 60;
        private int revalidationQueueSize = 100;
        private boolean neverCacheHTTP10ResponsesWithQuery;

        Builder() {
        }

        public Builder setMaxObjectSize(long l) {
            this.maxObjectSize = l;
            return this;
        }

        public Builder setMaxCacheEntries(int n) {
            this.maxCacheEntries = n;
            return this;
        }

        public Builder setMaxUpdateRetries(int n) {
            this.maxUpdateRetries = n;
            return this;
        }

        public Builder setAllow303Caching(boolean bl) {
            this.allow303Caching = bl;
            return this;
        }

        public Builder setWeakETagOnPutDeleteAllowed(boolean bl) {
            this.weakETagOnPutDeleteAllowed = bl;
            return this;
        }

        public Builder setHeuristicCachingEnabled(boolean bl) {
            this.heuristicCachingEnabled = bl;
            return this;
        }

        public Builder setHeuristicCoefficient(float f) {
            this.heuristicCoefficient = f;
            return this;
        }

        public Builder setHeuristicDefaultLifetime(long l) {
            this.heuristicDefaultLifetime = l;
            return this;
        }

        public Builder setSharedCache(boolean bl) {
            this.isSharedCache = bl;
            return this;
        }

        public Builder setAsynchronousWorkersMax(int n) {
            this.asynchronousWorkersMax = n;
            return this;
        }

        public Builder setAsynchronousWorkersCore(int n) {
            this.asynchronousWorkersCore = n;
            return this;
        }

        public Builder setAsynchronousWorkerIdleLifetimeSecs(int n) {
            this.asynchronousWorkerIdleLifetimeSecs = n;
            return this;
        }

        public Builder setRevalidationQueueSize(int n) {
            this.revalidationQueueSize = n;
            return this;
        }

        public Builder setNeverCacheHTTP10ResponsesWithQueryString(boolean bl) {
            this.neverCacheHTTP10ResponsesWithQuery = bl;
            return this;
        }

        public CacheConfig build() {
            return new CacheConfig(this.maxObjectSize, this.maxCacheEntries, this.maxUpdateRetries, this.allow303Caching, this.weakETagOnPutDeleteAllowed, this.heuristicCachingEnabled, this.heuristicCoefficient, this.heuristicDefaultLifetime, this.isSharedCache, this.asynchronousWorkersMax, this.asynchronousWorkersCore, this.asynchronousWorkerIdleLifetimeSecs, this.revalidationQueueSize, this.neverCacheHTTP10ResponsesWithQuery);
        }
    }
}

