/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.favicons.cache;

import android.graphics.Bitmap;
import android.util.Log;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.favicons.cache.FaviconCacheElement;
import org.mozilla.gecko.favicons.cache.FaviconsForURL;

public class FaviconCache {
    private static final String LOGTAG = "FaviconCache";
    private static final int NUM_FAVICON_SIZES = 4;
    public final int maxCachedWidth;
    public static final long FAILURE_RETRY_MILLISECONDS = 1200000L;
    private final HashMap<String, FaviconsForURL> backingMap = new HashMap();
    private final HashMap<String, FaviconsForURL> permanentBackingMap = new HashMap();
    private final LinkedList<FaviconCacheElement> ordering = new LinkedList();
    private final AtomicInteger currentSize = new AtomicInteger(0);
    private final int maxSizeBytes;
    private final Object reorderingLock = new Object();
    private final ReentrantReadWriteLock backingMapsLock = new ReentrantReadWriteLock(false);

    private void startRead() {
        this.backingMapsLock.readLock().lock();
    }

    private void finishRead() {
        this.backingMapsLock.readLock().unlock();
    }

    private void startWrite() {
        this.backingMapsLock.writeLock().lock();
    }

    private void finishWrite() {
        this.backingMapsLock.writeLock().unlock();
    }

    public FaviconCache(int n, int n2) {
        this.maxSizeBytes = n;
        this.maxCachedWidth = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFailedFavicon(String string2) {
        if (string2 == null) {
            return true;
        }
        this.startRead();
        try {
            if (!this.backingMap.containsKey(string2)) {
                boolean bl = false;
                return bl;
            }
            FaviconsForURL faviconsForURL = this.backingMap.get(string2);
            if (!faviconsForURL.hasFailed) {
                boolean bl = false;
                return bl;
            }
            long l = faviconsForURL.downloadTimestamp;
            long l2 = System.currentTimeMillis() - l;
            if (l2 < 1200000L) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"FaviconCache exception!", (Throwable)exception);
            boolean bl = true;
            return bl;
        }
        finally {
            this.finishRead();
        }
        this.startWrite();
        try {
            this.recordRemoved(this.backingMap.remove(string2));
            boolean bl = false;
            return bl;
        }
        finally {
            this.finishWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFailed(String string2) {
        this.startWrite();
        try {
            FaviconsForURL faviconsForURL = new FaviconsForURL(0, true);
            this.recordRemoved(this.backingMap.put(string2, faviconsForURL));
        }
        finally {
            this.finishWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getFaviconForDimensions(String string2, int n) {
        Bitmap bitmap;
        FaviconCacheElement faviconCacheElement;
        FaviconsForURL faviconsForURL;
        if (string2 == null) {
            Log.e((String)LOGTAG, (String)"You passed a null faviconURL to getFaviconForDimensions. Don't.");
            return null;
        }
        boolean bl = false;
        boolean bl2 = false;
        this.startRead();
        try {
            int n2;
            faviconsForURL = this.permanentBackingMap.get(string2);
            if (faviconsForURL == null) {
                faviconsForURL = this.backingMap.get(string2);
                if (faviconsForURL == null) {
                    Bitmap bitmap2 = null;
                    return bitmap2;
                }
            } else {
                bl2 = true;
            }
            int n3 = n2 = n == -1 ? -1 : faviconsForURL.getNextHighestIndex(n);
            if (n2 != -1) {
                faviconCacheElement = faviconsForURL.favicons.get(n2);
                if (faviconCacheElement.invalidated) {
                    Bitmap bitmap3 = null;
                    return bitmap3;
                }
                if (faviconCacheElement.imageSize == n) {
                    this.setMostRecentlyUsedWithinRead(faviconCacheElement);
                    Bitmap bitmap4 = faviconCacheElement.faviconPayload;
                    return bitmap4;
                }
            } else {
                n2 = faviconsForURL.favicons.size();
            }
            if ((faviconCacheElement = faviconsForURL.getNextPrimary(n2)) == null) {
                Bitmap bitmap5 = null;
                return bitmap5;
            }
            if (n == -1) {
                Bitmap bitmap6 = faviconCacheElement.faviconPayload;
                return bitmap6;
            }
            Bitmap bitmap7 = faviconCacheElement.faviconPayload;
            int n4 = faviconCacheElement.imageSize;
            if (n4 >= n) {
                bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap7, (int)n, (int)n, (boolean)true);
            } else if ((n4 *= 2) >= n) {
                bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap7, (int)n, (int)n, (boolean)true);
            } else {
                bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap7, (int)n4, (int)n4, (boolean)true);
                bl = true;
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"FaviconCache exception!", (Throwable)exception);
            Bitmap bitmap8 = null;
            return bitmap8;
        }
        finally {
            this.finishRead();
        }
        this.startWrite();
        try {
            if (bl) {
                faviconsForURL.ensureDominantColor();
            }
            faviconCacheElement = faviconsForURL.addSecondary(bitmap, n);
            if (!bl2 && this.setMostRecentlyUsedWithinWrite(faviconCacheElement)) {
                this.currentSize.addAndGet(faviconCacheElement.sizeOf());
            }
        }
        finally {
            this.finishWrite();
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDominantColor(String string2) {
        this.startRead();
        try {
            FaviconsForURL faviconsForURL = this.permanentBackingMap.get(string2);
            if (faviconsForURL == null) {
                faviconsForURL = this.backingMap.get(string2);
            }
            if (faviconsForURL == null) {
                Log.w((String)LOGTAG, (String)("Cannot compute dominant color of non-cached favicon. Cache fullness " + this.currentSize.get() + '/' + this.maxSizeBytes));
                int n = 0xFFFFFF;
                return n;
            }
            int n = faviconsForURL.ensureDominantColor();
            return n;
        }
        finally {
            this.finishRead();
        }
    }

    private void recordRemoved(FaviconsForURL faviconsForURL) {
        if (faviconsForURL == null) {
            return;
        }
        int n = 0;
        for (FaviconCacheElement faviconCacheElement : faviconsForURL.favicons) {
            n += faviconCacheElement.sizeOf();
            this.ordering.remove(faviconCacheElement);
        }
        this.currentSize.addAndGet(-n);
    }

    private Bitmap produceCacheableBitmap(Bitmap bitmap) {
        if (bitmap == Favicons.defaultFavicon || bitmap == null) {
            return null;
        }
        if (bitmap.getWidth() > this.maxCachedWidth) {
            return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)this.maxCachedWidth, (int)this.maxCachedWidth, (boolean)true);
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setMostRecentlyUsedWithinRead(FaviconCacheElement faviconCacheElement) {
        Object object = this.reorderingLock;
        synchronized (object) {
            boolean bl = this.ordering.remove(faviconCacheElement);
            this.ordering.offer(faviconCacheElement);
            return bl;
        }
    }

    private boolean setMostRecentlyUsedWithinWrite(FaviconCacheElement faviconCacheElement) {
        boolean bl = this.ordering.remove(faviconCacheElement);
        this.ordering.offer(faviconCacheElement);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putSingleFavicon(String string2, Bitmap bitmap) {
        Bitmap bitmap2 = this.produceCacheableBitmap(bitmap);
        if (bitmap2 == null) {
            return;
        }
        FaviconsForURL faviconsForURL = new FaviconsForURL(4);
        FaviconCacheElement faviconCacheElement = faviconsForURL.addPrimary(bitmap2);
        this.startWrite();
        try {
            this.setMostRecentlyUsedWithinWrite(faviconCacheElement);
            this.currentSize.addAndGet(faviconCacheElement.sizeOf());
            FaviconsForURL faviconsForURL2 = this.backingMap.put(string2, faviconsForURL);
            this.recordRemoved(faviconsForURL2);
        }
        finally {
            this.finishWrite();
        }
        this.cullIfRequired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFavicons(String string2, Iterator<Bitmap> iterator, boolean bl) {
        FaviconsForURL faviconsForURL = new FaviconsForURL(20);
        int n = 0;
        while (iterator.hasNext()) {
            Bitmap bitmap = this.produceCacheableBitmap(iterator.next());
            if (bitmap == null) continue;
            FaviconCacheElement faviconCacheElement = faviconsForURL.addPrimary(bitmap);
            n += faviconCacheElement.sizeOf();
        }
        this.startWrite();
        try {
            if (bl) {
                this.permanentBackingMap.put(string2, faviconsForURL);
                return;
            }
            for (FaviconCacheElement faviconCacheElement : faviconsForURL.favicons) {
                this.setMostRecentlyUsedWithinWrite(faviconCacheElement);
            }
            this.currentSize.addAndGet(n);
            this.recordRemoved(this.backingMap.put(string2, faviconsForURL));
        }
        finally {
            this.finishWrite();
        }
        this.cullIfRequired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cullIfRequired() {
        Log.d((String)LOGTAG, (String)("Favicon cache fullness: " + this.currentSize.get() + '/' + this.maxSizeBytes));
        if (this.currentSize.get() <= this.maxSizeBytes) {
            return;
        }
        this.startWrite();
        try {
            while (this.currentSize.get() > this.maxSizeBytes) {
                FaviconCacheElement faviconCacheElement = this.ordering.poll();
                this.currentSize.addAndGet(-faviconCacheElement.sizeOf());
                faviconCacheElement.onEvictedFromCache();
                Log.d((String)LOGTAG, (String)("After cull: " + this.currentSize.get() + '/' + this.maxSizeBytes));
            }
        }
        finally {
            this.finishWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictAll() {
        this.startWrite();
        try {
            this.currentSize.set(0);
            this.backingMap.clear();
            this.ordering.clear();
        }
        finally {
            this.finishWrite();
        }
    }
}

