/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.fxa.FirefoxAccounts;
import org.mozilla.gecko.fxa.activities.FxAccountAbstractActivity;
import org.mozilla.gecko.fxa.activities.FxAccountStatusActivity;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.login.Engaged;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.fxa.sync.FxAccountSyncStatusHelper;
import org.mozilla.gecko.fxa.tasks.FxAccountCodeResender;
import org.mozilla.gecko.sync.setup.activities.ActivityUtils;

public class FxAccountConfirmAccountActivity
extends FxAccountAbstractActivity
implements View.OnClickListener {
    private static final String LOG_TAG = FxAccountConfirmAccountActivity.class.getSimpleName();
    protected TextView verificationLinkTextView;
    protected View resendLink;
    protected AndroidFxAccount fxAccount;
    protected final InnerSyncStatusDelegate syncStatusDelegate = new InnerSyncStatusDelegate();

    public FxAccountConfirmAccountActivity() {
        super(2);
    }

    @Override
    public void onCreate(Bundle bundle) {
        Logger.debug(LOG_TAG, "onCreate(" + bundle + ")");
        super.onCreate(bundle);
        this.setContentView(R.layout.fxaccount_confirm_account);
        this.verificationLinkTextView = (TextView)this.ensureFindViewById(null, R.id.verification_link_text, "verification link text");
        this.resendLink = this.ensureFindViewById(null, R.id.resend_confirmation_email_link, "resend confirmation email link");
        this.resendLink.setOnClickListener((View.OnClickListener)this);
        View view = this.ensureFindViewById(null, R.id.button, "back to browsing button");
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ActivityUtils.openURLInFennec(view.getContext(), null);
                FxAccountConfirmAccountActivity.this.setResult(-1);
                FxAccountConfirmAccountActivity.this.finish();
            }
        });
    }

    @Override
    public void onResume() {
        super.onResume();
        this.fxAccount = this.getAndroidFxAccount();
        if (this.fxAccount == null) {
            Logger.warn(LOG_TAG, "Could not get Firefox Account.");
            this.setResult(0);
            this.finish();
            return;
        }
        FxAccountSyncStatusHelper.getInstance().startObserving(this.syncStatusDelegate);
        this.refresh();
        this.fxAccount.requestSync(FirefoxAccounts.NOW);
    }

    public void onPause() {
        super.onPause();
        FxAccountSyncStatusHelper.getInstance().stopObserving(this.syncStatusDelegate);
        if (this.fxAccount != null) {
            this.fxAccount.requestSync(FirefoxAccounts.SOON);
        }
    }

    protected void refresh() {
        State state = this.fxAccount.getState();
        State.Action action = state.getNeededAction();
        switch (action) {
            case NeedsVerification: {
                break;
            }
            default: {
                Logger.warn(LOG_TAG, "No need to verifiy Firefox Account that needs action " + action.toString() + " (in state " + (Object)((Object)state.getStateLabel()) + ").");
                this.setResult(0);
                this.redirectToActivity(FxAccountStatusActivity.class);
                return;
            }
        }
        String string2 = this.fxAccount.getEmail();
        String string3 = this.getResources().getString(R.string.fxaccount_confirm_account_verification_link, new Object[]{string2});
        this.verificationLinkTextView.setText((CharSequence)string3);
        boolean bl = ((Engaged)state).getSessionToken() != null;
        this.resendLink.setEnabled(bl);
        this.resendLink.setClickable(bl);
    }

    public void onClick(View view) {
        FxAccountCodeResender.resendCode((Context)this, this.fxAccount);
    }

    protected class InnerSyncStatusDelegate
    implements FirefoxAccounts.SyncStatusListener {
        protected final Runnable refreshRunnable = new Runnable(){

            @Override
            public void run() {
                FxAccountConfirmAccountActivity.this.refresh();
            }
        };

        protected InnerSyncStatusDelegate() {
        }

        @Override
        public Context getContext() {
            return FxAccountConfirmAccountActivity.this;
        }

        @Override
        public Account getAccount() {
            return FxAccountConfirmAccountActivity.this.fxAccount.getAndroidAccount();
        }

        @Override
        public void onSyncStarted() {
            Logger.info(LOG_TAG, "Got sync started message; ignoring.");
        }

        @Override
        public void onSyncFinished() {
            if (FxAccountConfirmAccountActivity.this.fxAccount == null) {
                return;
            }
            Logger.info(LOG_TAG, "Got sync finished message; refreshing.");
            FxAccountConfirmAccountActivity.this.runOnUiThread(this.refreshRunnable);
        }
    }
}

