/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.RegionIterator;
import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.mozilla.gecko.gfx.CairoImage;
import org.mozilla.gecko.gfx.Layer;
import org.mozilla.gecko.gfx.TileLayer;

public class SingleTileLayer
extends TileLayer {
    private static final String LOGTAG = "GeckoSingleTileLayer";
    private Rect mMask;
    private final RectF mBounds = new RectF();
    private final RectF mTextureBounds = new RectF();
    private final RectF mViewport = new RectF();
    private final Rect mIntBounds = new Rect();
    private final Rect mSubRect = new Rect();
    private final RectF mSubRectF = new RectF();
    private final Region mMaskedBounds = new Region();
    private final Rect mCropRect = new Rect();
    private final RectF mObjRectF = new RectF();
    private final float[] mCoords = new float[20];

    public SingleTileLayer(CairoImage cairoImage) {
        this(false, cairoImage);
    }

    public SingleTileLayer(boolean bl, CairoImage cairoImage) {
        this(cairoImage, bl ? TileLayer.PaintMode.REPEAT : TileLayer.PaintMode.NORMAL);
    }

    public SingleTileLayer(CairoImage cairoImage, TileLayer.PaintMode paintMode) {
        super(cairoImage, paintMode);
    }

    public void setMask(Rect rect) {
        this.mMask = rect;
    }

    @Override
    public void draw(Layer.RenderContext renderContext) {
        if (!this.initialized()) {
            return;
        }
        this.mViewport.set(renderContext.viewport);
        if (this.repeats()) {
            this.mBounds.set(this.getBounds(renderContext));
            this.mTextureBounds.set(0.0f, 0.0f, this.mBounds.width(), this.mBounds.height());
            this.mBounds.set(0.0f, 0.0f, this.mViewport.width(), this.mViewport.height());
        } else if (this.stretches()) {
            this.mBounds.set(renderContext.pageRect);
            this.mTextureBounds.set(this.mBounds);
        } else {
            this.mBounds.set(this.getBounds(renderContext));
            this.mTextureBounds.set(this.mBounds);
        }
        this.mBounds.roundOut(this.mIntBounds);
        this.mMaskedBounds.set(this.mIntBounds);
        if (this.mMask != null) {
            this.mMaskedBounds.op(this.mMask, Region.Op.DIFFERENCE);
            if (this.mMaskedBounds.isEmpty()) {
                return;
            }
        }
        RegionIterator regionIterator = new RegionIterator(this.mMaskedBounds);
        while (regionIterator.next(this.mSubRect)) {
            this.mSubRectF.set(Math.max(this.mBounds.left, (float)this.mSubRect.left), Math.max(this.mBounds.top, (float)this.mSubRect.top), Math.min(this.mBounds.right, (float)this.mSubRect.right), Math.min(this.mBounds.bottom, (float)this.mSubRect.bottom));
            this.mCropRect.set(Math.round(this.mSubRectF.left - this.mBounds.left), Math.round(this.mBounds.bottom - this.mSubRectF.top), Math.round(this.mSubRectF.right - this.mBounds.left), Math.round(this.mBounds.bottom - this.mSubRectF.bottom));
            this.mObjRectF.set(this.mSubRectF.left - this.mViewport.left, this.mViewport.bottom - this.mSubRectF.bottom, this.mSubRectF.right - this.mViewport.left, this.mViewport.bottom - this.mSubRectF.top);
            this.fillRectCoordBuffer(this.mCoords, this.mObjRectF, this.mViewport.width(), this.mViewport.height(), this.mCropRect, this.mTextureBounds.width(), this.mTextureBounds.height());
            FloatBuffer floatBuffer = renderContext.coordBuffer;
            int n = renderContext.positionHandle;
            int n2 = renderContext.textureHandle;
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)this.getTextureID());
            floatBuffer.position(0);
            floatBuffer.put(this.mCoords);
            GLES20.glBindBuffer((int)34962, (int)0);
            floatBuffer.position(0);
            GLES20.glVertexAttribPointer((int)n, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)floatBuffer);
            floatBuffer.position(3);
            GLES20.glVertexAttribPointer((int)n2, (int)2, (int)5126, (boolean)false, (int)20, (Buffer)floatBuffer);
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
        }
    }
}

