/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.menu;

import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.view.ActionProvider;
import android.view.ContextMenu;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.R;
import org.mozilla.gecko.menu.GeckoMenu;
import org.mozilla.gecko.menu.GeckoSubMenu;
import org.mozilla.gecko.menu.MenuItemActionBar;
import org.mozilla.gecko.widget.GeckoActionProvider;

public class GeckoMenuItem
implements MenuItem {
    public static final int SHOW_AS_ACTION_NEVER = 0;
    public static final int SHOW_AS_ACTION_IF_ROOM = 1;
    public static final int SHOW_AS_ACTION_ALWAYS = 2;
    private final int mId;
    private final int mOrder;
    private View mActionView;
    private int mActionEnum;
    private CharSequence mTitle;
    private CharSequence mTitleCondensed;
    private boolean mCheckable;
    private boolean mChecked;
    private boolean mVisible = true;
    private boolean mEnabled = true;
    private Drawable mIcon;
    private int mIconRes;
    private GeckoActionProvider mActionProvider;
    private GeckoSubMenu mSubMenu;
    private MenuItem.OnMenuItemClickListener mMenuItemClickListener;
    final GeckoMenu mMenu;
    OnShowAsActionChangedListener mShowAsActionChangedListener;

    public GeckoMenuItem(GeckoMenu geckoMenu, int n, int n2, int n3) {
        this.mMenu = geckoMenu;
        this.mId = n;
        this.mOrder = n2;
        this.setTitle(n3);
    }

    public GeckoMenuItem(GeckoMenu geckoMenu, int n, int n2, CharSequence charSequence) {
        this.mMenu = geckoMenu;
        this.mId = n;
        this.mOrder = n2;
        this.setTitle(charSequence);
    }

    public boolean collapseActionView() {
        return false;
    }

    public boolean expandActionView() {
        return false;
    }

    public boolean hasActionProvider() {
        if (AppConstants.Versions.preICS) {
            return false;
        }
        return this.mActionProvider != null;
    }

    public int getActionEnum() {
        return this.mActionEnum;
    }

    public GeckoActionProvider getGeckoActionProvider() {
        return this.mActionProvider;
    }

    public ActionProvider getActionProvider() {
        return null;
    }

    public View getActionView() {
        if (this.mActionProvider != null) {
            return this.mActionProvider.getView();
        }
        return this.mActionView;
    }

    public char getAlphabeticShortcut() {
        return '\u0000';
    }

    public int getGroupId() {
        return 0;
    }

    public Drawable getIcon() {
        if (this.mIcon == null) {
            if (this.mIconRes != 0) {
                return this.mMenu.getResources().getDrawable(this.mIconRes);
            }
            return null;
        }
        return this.mIcon;
    }

    public Intent getIntent() {
        return null;
    }

    public int getItemId() {
        return this.mId;
    }

    public ContextMenu.ContextMenuInfo getMenuInfo() {
        return null;
    }

    public char getNumericShortcut() {
        return '\u0000';
    }

    public int getOrder() {
        return this.mOrder;
    }

    public SubMenu getSubMenu() {
        return this.mSubMenu;
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public CharSequence getTitleCondensed() {
        return this.mTitleCondensed;
    }

    public boolean hasSubMenu() {
        if (this.mActionProvider != null) {
            return this.mActionProvider.hasSubMenu();
        }
        return this.mSubMenu != null;
    }

    public boolean isActionItem() {
        return this.mActionEnum > 0;
    }

    public boolean isActionViewExpanded() {
        return false;
    }

    public boolean isCheckable() {
        return this.mCheckable;
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    public MenuItem setActionProvider(ActionProvider actionProvider) {
        return this;
    }

    public MenuItem setActionProvider(GeckoActionProvider geckoActionProvider) {
        this.mActionProvider = geckoActionProvider;
        if (this.mActionProvider != null) {
            geckoActionProvider.setOnTargetSelectedListener(new GeckoActionProvider.OnTargetSelectedListener(){

                @Override
                public void onTargetSelected() {
                    GeckoMenuItem.this.mMenu.close();
                    GeckoMenuItem.this.mShowAsActionChangedListener.onShowAsActionChanged(GeckoMenuItem.this);
                }
            });
        }
        this.mShowAsActionChangedListener.onShowAsActionChanged(this);
        return this;
    }

    public MenuItem setActionView(int n) {
        return this;
    }

    public MenuItem setActionView(View view) {
        return this;
    }

    public MenuItem setAlphabeticShortcut(char c) {
        return this;
    }

    public MenuItem setCheckable(boolean bl) {
        this.mCheckable = bl;
        this.mMenu.onItemChanged(this);
        return this;
    }

    public MenuItem setChecked(boolean bl) {
        this.mChecked = bl;
        this.mMenu.onItemChanged(this);
        return this;
    }

    public MenuItem setEnabled(boolean bl) {
        this.mEnabled = bl;
        this.mMenu.onItemChanged(this);
        return this;
    }

    public MenuItem setIcon(Drawable drawable2) {
        this.mIcon = drawable2;
        this.mMenu.onItemChanged(this);
        return this;
    }

    public MenuItem setIcon(int n) {
        this.mIconRes = n;
        this.mMenu.onItemChanged(this);
        return this;
    }

    public MenuItem setIntent(Intent intent) {
        return this;
    }

    public MenuItem setNumericShortcut(char c) {
        return this;
    }

    public MenuItem setOnActionExpandListener(MenuItem.OnActionExpandListener onActionExpandListener) {
        return this;
    }

    public MenuItem setOnMenuItemClickListener(MenuItem.OnMenuItemClickListener onMenuItemClickListener) {
        this.mMenuItemClickListener = onMenuItemClickListener;
        return this;
    }

    public MenuItem setShortcut(char c, char c2) {
        return this;
    }

    public void setShowAsAction(int n) {
        this.setShowAsAction(n, 0);
    }

    public void setShowAsAction(int n, int n2) {
        if (this.mShowAsActionChangedListener == null) {
            return;
        }
        if (this.mActionEnum == n) {
            return;
        }
        if (n > 0) {
            if (!this.mShowAsActionChangedListener.hasActionItemBar()) {
                return;
            }
            if (!this.hasActionProvider()) {
                MenuItemActionBar menuItemActionBar = n2 != 0 ? new MenuItemActionBar(this.mMenu.getContext(), null, n2) : (n == 2 ? new MenuItemActionBar(this.mMenu.getContext()) : new MenuItemActionBar(this.mMenu.getContext(), null, R.attr.menuItemSecondaryActionBarStyle));
                menuItemActionBar.initialize(this);
                this.mActionView = menuItemActionBar;
            }
            this.mActionEnum = n;
        }
        this.mShowAsActionChangedListener.onShowAsActionChanged(this);
    }

    public MenuItem setShowAsActionFlags(int n) {
        return this;
    }

    public MenuItem setSubMenu(GeckoSubMenu geckoSubMenu) {
        this.mSubMenu = geckoSubMenu;
        return this;
    }

    public MenuItem setTitle(CharSequence charSequence) {
        this.mTitle = charSequence;
        this.mMenu.onItemChanged(this);
        return this;
    }

    public MenuItem setTitle(int n) {
        this.mTitle = this.mMenu.getResources().getString(n);
        this.mMenu.onItemChanged(this);
        return this;
    }

    public MenuItem setTitleCondensed(CharSequence charSequence) {
        this.mTitleCondensed = charSequence;
        return this;
    }

    public MenuItem setVisible(boolean bl) {
        this.mVisible = bl;
        this.mMenu.onItemChanged(this);
        return this;
    }

    public boolean invoke() {
        if (this.mMenuItemClickListener != null) {
            return this.mMenuItemClickListener.onMenuItemClick((MenuItem)this);
        }
        return false;
    }

    public void setOnShowAsActionChangedListener(OnShowAsActionChangedListener onShowAsActionChangedListener) {
        this.mShowAsActionChangedListener = onShowAsActionChangedListener;
    }

    public static interface OnShowAsActionChangedListener {
        public boolean hasActionItemBar();

        public void onShowAsActionChanged(GeckoMenuItem var1);
    }

    public static interface Layout {
        public void initialize(GeckoMenuItem var1);

        public void setShowIcon(boolean var1);
    }
}

