/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.domain;

import java.util.Collection;
import java.util.HashMap;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.NonArrayJSONException;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.repositories.android.RepoUtils;
import org.mozilla.gecko.sync.repositories.domain.Record;

public class HistoryRecord
extends Record {
    private static final String LOG_TAG = "HistoryRecord";
    public static final String COLLECTION_NAME = "history";
    public static final long HISTORY_TTL = 5184000L;
    public String title;
    public String histURI;
    public JSONArray visits;
    public long fennecDateVisited;
    public long fennecVisitCount;

    public HistoryRecord(String string2, String string3, long l, boolean bl) {
        super(string2, string3, l, bl);
        this.ttl = 5184000L;
    }

    public HistoryRecord(String string2, String string3, long l) {
        this(string2, string3, l, false);
    }

    public HistoryRecord(String string2, String string3) {
        this(string2, string3, 0L, false);
    }

    public HistoryRecord(String string2) {
        this(string2, COLLECTION_NAME, 0L, false);
    }

    public HistoryRecord() {
        this(Utils.generateGuid(), COLLECTION_NAME, 0L, false);
    }

    private JSONArray copyVisits() {
        if (this.visits == null) {
            return null;
        }
        JSONArray jSONArray = new JSONArray();
        jSONArray.addAll((Collection)this.visits);
        return jSONArray;
    }

    @Override
    public Record copyWithIDs(String string2, long l) {
        HistoryRecord historyRecord = new HistoryRecord(string2, this.collection, this.lastModified, this.deleted);
        historyRecord.androidID = l;
        historyRecord.sortIndex = this.sortIndex;
        historyRecord.ttl = this.ttl;
        historyRecord.title = this.title;
        historyRecord.histURI = this.histURI;
        historyRecord.fennecDateVisited = this.fennecDateVisited;
        historyRecord.fennecVisitCount = this.fennecVisitCount;
        historyRecord.visits = this.copyVisits();
        return historyRecord;
    }

    @Override
    protected void populatePayload(ExtendedJSONObject extendedJSONObject) {
        this.putPayload(extendedJSONObject, "id", this.guid);
        this.putPayload(extendedJSONObject, "title", this.title);
        this.putPayload(extendedJSONObject, "histUri", this.histURI);
        extendedJSONObject.put("visits", this.visits);
    }

    @Override
    protected void initFromPayload(ExtendedJSONObject extendedJSONObject) {
        this.histURI = (String)extendedJSONObject.get("histUri");
        this.title = (String)extendedJSONObject.get("title");
        try {
            this.visits = extendedJSONObject.getArray("visits");
        }
        catch (NonArrayJSONException nonArrayJSONException) {
            Logger.error(LOG_TAG, "Got non-array visits in history record " + this.guid, nonArrayJSONException);
            this.visits = new JSONArray();
        }
    }

    @Override
    public boolean congruentWith(Object object) {
        if (object == null || !(object instanceof HistoryRecord)) {
            return false;
        }
        HistoryRecord historyRecord = (HistoryRecord)object;
        if (!super.congruentWith(historyRecord)) {
            return false;
        }
        return RepoUtils.stringsEqual(this.histURI, historyRecord.histURI);
    }

    @Override
    public boolean equalPayloads(Object object) {
        if (object == null || !(object instanceof HistoryRecord)) {
            Logger.debug(LOG_TAG, "Not a HistoryRecord: " + object.getClass());
            return false;
        }
        HistoryRecord historyRecord = (HistoryRecord)object;
        if (!super.equalPayloads(historyRecord)) {
            Logger.debug(LOG_TAG, "super.equalPayloads returned false.");
            return false;
        }
        return RepoUtils.stringsEqual(this.title, historyRecord.title) && RepoUtils.stringsEqual(this.histURI, historyRecord.histURI) && this.checkVisitsEquals(historyRecord);
    }

    @Override
    public boolean equalAndroidIDs(Record record) {
        return super.equalAndroidIDs(record) && this.equalFennecVisits(record);
    }

    private boolean equalFennecVisits(Record record) {
        if (!(record instanceof HistoryRecord)) {
            return false;
        }
        HistoryRecord historyRecord = (HistoryRecord)record;
        return this.fennecDateVisited == historyRecord.fennecDateVisited && this.fennecVisitCount == historyRecord.fennecVisitCount;
    }

    private boolean checkVisitsEquals(HistoryRecord historyRecord) {
        JSONObject jSONObject;
        int n;
        int n2;
        Logger.debug(LOG_TAG, "Checking visits.");
        if (Logger.LOG_PERSONAL_INFORMATION) {
            Logger.pii(LOG_TAG, ">> Mine:   " + (this.visits == null ? "null" : this.visits.toJSONString()));
            Logger.pii(LOG_TAG, ">> Theirs: " + (historyRecord.visits == null ? "null" : historyRecord.visits.toJSONString()));
        }
        if (this.visits == historyRecord.visits) {
            return true;
        }
        int n3 = this.visits == null ? 0 : this.visits.size();
        int n4 = n2 = historyRecord.visits == null ? 0 : historyRecord.visits.size();
        if (n3 != n2) {
            return false;
        }
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>();
        for (n = 0; n < n2; ++n) {
            jSONObject = (JSONObject)historyRecord.visits.get(n);
            hashMap.put((Long)jSONObject.get((Object)"date"), (Long)jSONObject.get((Object)"type"));
        }
        for (n = 0; n < n3; ++n) {
            jSONObject = (JSONObject)this.visits.get(n);
            if (!hashMap.containsKey(jSONObject.get((Object)"date"))) {
                return false;
            }
            Long l = (Long)jSONObject.get((Object)"date");
            Long l2 = (Long)hashMap.get(l);
            if (l2 == null) {
                return false;
            }
            if (l2.equals((Long)jSONObject.get((Object)"type"))) continue;
            return false;
        }
        return true;
    }
}

