/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.json.JSONObject;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.BrowserApp;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoApplication;
import org.mozilla.gecko.LightweightTheme;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.menu.GeckoMenu;
import org.mozilla.gecko.menu.MenuPanel;
import org.mozilla.gecko.menu.MenuPopup;
import org.mozilla.gecko.toolbar.AutocompleteHandler;
import org.mozilla.gecko.toolbar.BackButton;
import org.mozilla.gecko.toolbar.ForwardButton;
import org.mozilla.gecko.toolbar.TabCounter;
import org.mozilla.gecko.toolbar.ToolbarDisplayLayout;
import org.mozilla.gecko.toolbar.ToolbarEditLayout;
import org.mozilla.gecko.toolbar.ToolbarPrefs;
import org.mozilla.gecko.toolbar.ToolbarProgressView;
import org.mozilla.gecko.util.Clipboard;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.HardwareUtils;
import org.mozilla.gecko.util.MenuUtils;
import org.mozilla.gecko.widget.ThemedImageButton;
import org.mozilla.gecko.widget.ThemedImageView;
import org.mozilla.gecko.widget.ThemedLinearLayout;
import org.mozilla.gecko.widget.ThemedRelativeLayout;

public class BrowserToolbar
extends ThemedRelativeLayout
implements Tabs.OnTabsChangedListener,
GeckoMenu.ActionItemBarPresenter,
GeckoEventListener {
    private static final String LOGTAG = "GeckoToolbar";
    private ToolbarDisplayLayout urlDisplayLayout;
    private ToolbarEditLayout urlEditLayout;
    private View urlBarEntry;
    private RelativeLayout.LayoutParams urlBarEntryDefaultLayoutParams;
    private RelativeLayout.LayoutParams urlBarEntryShrunkenLayoutParams;
    private ImageView urlBarTranslatingEdge;
    private boolean isSwitchingTabs;
    private ThemedImageButton tabsButton;
    private ImageButton backButton;
    private ImageButton forwardButton;
    private ToolbarProgressView progressBar;
    private TabCounter tabsCounter;
    private ThemedImageButton menuButton;
    private ThemedImageView menuIcon;
    private LinearLayout actionItemBar;
    private MenuPopup menuPopup;
    private List<View> focusOrder;
    private final ThemedImageView editCancel;
    private List<View> tabletDisplayModeViews;
    private boolean hidForwardButtonOnStartEditing;
    private boolean shouldShrinkURLBar;
    private OnActivateListener activateListener;
    private View.OnFocusChangeListener focusChangeListener;
    private OnStartEditingListener startEditingListener;
    private OnStopEditingListener stopEditingListener;
    private final PropertyAnimator.PropertyAnimationListener showEditingPhoneAnimationListener;
    private final PropertyAnimator.PropertyAnimationListener stopEditingPhoneAnimationListener;
    private final BrowserApp activity;
    private boolean hasSoftMenuButton;
    private UIMode uiMode;
    private boolean isAnimatingEntry;
    private int urlBarViewOffset;
    private int defaultForwardMargin;
    private Path roundCornerShape;
    private Paint roundCornerPaint;
    private final Paint shadowPaint;
    private final int shadowSize;
    private static final Interpolator buttonsInterpolator = new AccelerateInterpolator();
    private static final int FORWARD_ANIMATION_DURATION = 450;
    private final LightweightTheme theme;
    private final ToolbarPrefs prefs;

    public BrowserToolbar(Context context) {
        this(context, null);
    }

    public BrowserToolbar(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setWillNotDraw(false);
        this.theme = ((GeckoApplication)context.getApplicationContext()).getLightweightTheme();
        this.activity = (BrowserApp)context;
        LayoutInflater.from((Context)context).inflate(R.layout.browser_toolbar, (ViewGroup)this);
        Tabs.registerOnTabsChangedListener(this);
        this.isSwitchingTabs = true;
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "Reader:Click", "Reader:LongClick");
        Resources resources = this.getResources();
        this.urlBarViewOffset = resources.getDimensionPixelSize(R.dimen.url_bar_offset_left);
        this.defaultForwardMargin = resources.getDimensionPixelSize(R.dimen.forward_default_offset);
        this.urlDisplayLayout = (ToolbarDisplayLayout)this.findViewById(R.id.display_layout);
        this.urlBarEntry = this.findViewById(R.id.url_bar_entry);
        this.urlEditLayout = (ToolbarEditLayout)this.findViewById(R.id.edit_layout);
        this.urlBarEntryDefaultLayoutParams = (RelativeLayout.LayoutParams)this.urlBarEntry.getLayoutParams();
        this.urlBarEntryShrunkenLayoutParams = new RelativeLayout.LayoutParams((ViewGroup.MarginLayoutParams)this.urlBarEntryDefaultLayoutParams);
        if (HardwareUtils.isTablet()) {
            this.urlBarEntryShrunkenLayoutParams.addRule(7, R.id.edit_layout);
            this.urlBarEntryShrunkenLayoutParams.addRule(5, R.id.edit_layout);
            this.urlBarEntryShrunkenLayoutParams.leftMargin = 0;
        }
        this.urlBarTranslatingEdge = (ImageView)this.findViewById(R.id.url_bar_translating_edge);
        if (this.urlBarTranslatingEdge != null) {
            this.urlBarTranslatingEdge.getDrawable().setLevel(6000);
        }
        this.tabsButton = (ThemedImageButton)this.findViewById(R.id.tabs);
        this.tabsCounter = (TabCounter)this.findViewById(R.id.tabs_counter);
        if (AppConstants.Versions.feature11Plus) {
            this.tabsCounter.setLayerType(1, null);
        }
        this.backButton = (ImageButton)this.findViewById(R.id.back);
        this.setButtonEnabled(this.backButton, false);
        this.forwardButton = (ImageButton)this.findViewById(R.id.forward);
        this.setButtonEnabled(this.forwardButton, false);
        this.menuButton = (ThemedImageButton)this.findViewById(R.id.menu);
        this.menuIcon = (ThemedImageView)this.findViewById(R.id.menu_icon);
        this.actionItemBar = (LinearLayout)this.findViewById(R.id.menu_items);
        this.hasSoftMenuButton = !HardwareUtils.hasMenuButton();
        this.editCancel = (ThemedImageView)this.findViewById(R.id.edit_cancel);
        this.focusOrder = new ArrayList<View>();
        if (HardwareUtils.isTablet()) {
            this.focusOrder.addAll(Arrays.asList(this.tabsButton, this.backButton, this.forwardButton, this));
            this.focusOrder.addAll(this.urlDisplayLayout.getFocusOrder());
            this.focusOrder.addAll(Arrays.asList(this.actionItemBar, this.menuButton));
        } else {
            this.focusOrder.add((View)this);
            this.focusOrder.addAll(this.urlDisplayLayout.getFocusOrder());
            this.focusOrder.addAll(Arrays.asList(this.tabsButton, this.menuButton));
        }
        if (!HardwareUtils.isTablet()) {
            this.roundCornerShape = new Path();
            this.roundCornerShape.moveTo(0.0f, 0.0f);
            this.roundCornerShape.lineTo(30.0f, 0.0f);
            this.roundCornerShape.cubicTo(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 30.0f);
            this.roundCornerShape.lineTo(0.0f, 0.0f);
            this.roundCornerPaint = new Paint();
            this.roundCornerPaint.setAntiAlias(true);
            this.roundCornerPaint.setColor(resources.getColor(R.color.background_tabs));
            this.roundCornerPaint.setStrokeWidth(0.0f);
        }
        this.shadowSize = resources.getDimensionPixelSize(R.dimen.browser_toolbar_shadow_size);
        this.shadowPaint = new Paint();
        this.shadowPaint.setColor(resources.getColor(R.color.url_bar_shadow));
        this.shadowPaint.setStrokeWidth(0.0f);
        this.setUIMode(UIMode.DISPLAY);
        this.showEditingPhoneAnimationListener = new PropertyAnimator.PropertyAnimationListener(){

            @Override
            public void onPropertyAnimationStart() {
            }

            @Override
            public void onPropertyAnimationEnd() {
                BrowserToolbar.this.isAnimatingEntry = false;
            }
        };
        this.stopEditingPhoneAnimationListener = new PropertyAnimator.PropertyAnimationListener(){

            @Override
            public void onPropertyAnimationStart() {
            }

            @Override
            public void onPropertyAnimationEnd() {
                BrowserToolbar.this.urlBarTranslatingEdge.setVisibility(4);
                if (BrowserToolbar.this.shouldShrinkURLBar) {
                    BrowserToolbar.this.urlBarEntry.setLayoutParams((ViewGroup.LayoutParams)BrowserToolbar.this.urlBarEntryDefaultLayoutParams);
                }
                PropertyAnimator propertyAnimator = new PropertyAnimator(300L);
                BrowserToolbar.this.urlDisplayLayout.prepareStopEditingAnimation(propertyAnimator);
                propertyAnimator.start();
                BrowserToolbar.this.isAnimatingEntry = false;
                BrowserToolbar.this.updateTabCountAndAnimate(Tabs.getInstance().getDisplayCount());
            }
        };
        this.prefs = new ToolbarPrefs();
        this.urlDisplayLayout.setToolbarPrefs(this.prefs);
        this.urlEditLayout.setToolbarPrefs(this.prefs);
    }

    public ArrayList<View> populateTabletViews() {
        if (!HardwareUtils.isTablet()) {
            return null;
        }
        View[] viewArray = new View[]{this.actionItemBar, this.backButton, this.menuButton, this.menuIcon, this.tabsButton, this.tabsCounter};
        ArrayList<View> arrayList = new ArrayList<View>(viewArray.length);
        for (View view : viewArray) {
            if (view.getVisibility() != 0) continue;
            arrayList.add(view);
        }
        return arrayList;
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.prefs.open();
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (BrowserToolbar.this.activateListener != null) {
                    BrowserToolbar.this.activateListener.onActivate();
                }
            }
        });
        this.setOnCreateContextMenuListener(new View.OnCreateContextMenuListener(){

            public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
                Tab tab;
                if (BrowserToolbar.this.isEditing()) {
                    return;
                }
                MenuInflater menuInflater = BrowserToolbar.this.activity.getMenuInflater();
                menuInflater.inflate(R.menu.titlebar_contextmenu, (Menu)contextMenu);
                String string2 = Clipboard.getText();
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    contextMenu.findItem(R.id.pasteandgo).setVisible(false);
                    contextMenu.findItem(R.id.paste).setVisible(false);
                }
                if ((tab = Tabs.getInstance().getSelectedTab()) != null) {
                    String string3 = tab.getURL();
                    if (string3 == null) {
                        contextMenu.findItem(R.id.copyurl).setVisible(false);
                        contextMenu.findItem(R.id.add_to_launcher).setVisible(false);
                    }
                    MenuUtils.safeSetVisible((Menu)contextMenu, (int)R.id.subscribe, (boolean)tab.hasFeeds());
                    MenuUtils.safeSetVisible((Menu)contextMenu, (int)R.id.add_search_engine, (boolean)tab.hasOpenSearch());
                } else {
                    contextMenu.findItem(R.id.copyurl).setVisible(false);
                    contextMenu.findItem(R.id.add_to_launcher).setVisible(false);
                    MenuUtils.safeSetVisible((Menu)contextMenu, (int)R.id.subscribe, (boolean)false);
                    MenuUtils.safeSetVisible((Menu)contextMenu, (int)R.id.add_search_engine, (boolean)false);
                }
            }
        });
        this.urlDisplayLayout.setOnStopListener(new ToolbarDisplayLayout.OnStopListener(){

            @Override
            public Tab onStop() {
                Tab tab = Tabs.getInstance().getSelectedTab();
                if (tab != null) {
                    tab.doStop();
                    return tab;
                }
                return null;
            }
        });
        this.urlDisplayLayout.setOnTitleChangeListener(new ToolbarDisplayLayout.OnTitleChangeListener(){

            @Override
            public void onTitleChange(CharSequence charSequence) {
                String string2 = charSequence != null ? charSequence.toString() : BrowserToolbar.this.activity.getString(R.string.url_bar_default_text);
                BrowserToolbar.this.setContentDescription(string2);
            }
        });
        this.urlEditLayout.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean bl) {
                BrowserToolbar.this.setSelected(bl);
                if (BrowserToolbar.this.focusChangeListener != null) {
                    BrowserToolbar.this.focusChangeListener.onFocusChange(view, bl);
                }
            }
        });
        this.tabsButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                BrowserToolbar.this.toggleTabs();
            }
        });
        this.tabsButton.setImageLevel(0);
        this.backButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Tabs.getInstance().getSelectedTab().doBack();
            }
        });
        this.backButton.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                return Tabs.getInstance().getSelectedTab().showBackHistory();
            }
        });
        this.forwardButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Tabs.getInstance().getSelectedTab().doForward();
            }
        });
        this.forwardButton.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                return Tabs.getInstance().getSelectedTab().showForwardHistory();
            }
        });
        this.editCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (!BrowserToolbar.this.isAnimatingEntry) {
                    Telemetry.sendUIEvent(TelemetryContract.Event.CANCEL, TelemetryContract.Method.ACTIONBAR, BrowserToolbar.this.getResources().getResourceEntryName(BrowserToolbar.this.editCancel.getId()));
                    BrowserToolbar.this.cancelEdit();
                }
            }
        });
        if (this.hasSoftMenuButton) {
            this.menuButton.setVisibility(0);
            this.menuIcon.setVisibility(0);
            this.menuButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    BrowserToolbar.this.activity.openOptionsMenu();
                }
            });
        }
    }

    @Override
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.prefs.close();
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (!HardwareUtils.isTablet() && this.uiMode == UIMode.DISPLAY) {
            canvas.drawPath(this.roundCornerShape, this.roundCornerPaint);
        }
        int n = this.getHeight();
        canvas.drawRect(0.0f, (float)(n - this.shadowSize), (float)this.getWidth(), (float)n, this.shadowPaint);
    }

    public void setProgressBar(ToolbarProgressView toolbarProgressView) {
        this.progressBar = toolbarProgressView;
    }

    public void refresh() {
        this.urlDisplayLayout.dismissSiteIdentityPopup();
    }

    public boolean onBackPressed() {
        if (this.isEditing() && !this.isAnimatingEntry) {
            Telemetry.sendUIEvent(TelemetryContract.Event.CANCEL, TelemetryContract.Method.BACK);
            this.cancelEdit();
            return true;
        }
        return this.urlDisplayLayout.dismissSiteIdentityPopup();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (motionEvent != null && motionEvent.getY() > (float)this.getHeight() + ViewHelper.getTranslationY((View)this)) {
            return false;
        }
        return super.onTouchEvent(motionEvent);
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        if (n2 != n4) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    BrowserToolbar.this.activity.refreshToolbarHeight();
                }
            });
        }
    }

    @Override
    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
        Log.d((String)LOGTAG, (String)("onTabChanged: " + (Object)((Object)tabEvents)));
        Tabs tabs = Tabs.getInstance();
        switch (tabEvents) {
            case ADDED: 
            case CLOSED: {
                this.updateTabCount(tabs.getDisplayCount());
                break;
            }
            case RESTORED: 
            case SELECTED: {
                this.urlDisplayLayout.dismissSiteIdentityPopup();
                this.updateTabCount(tabs.getDisplayCount());
                this.isSwitchingTabs = true;
            }
        }
        if (tabs.isSelectedTab(tab)) {
            EnumSet<ToolbarDisplayLayout.UpdateFlags> enumSet = EnumSet.noneOf(ToolbarDisplayLayout.UpdateFlags.class);
            switch (tabEvents) {
                case START: {
                    this.updateProgressVisibility(tab, 10);
                }
                case ADDED: 
                case LOCATION_CHANGE: 
                case LOAD_ERROR: 
                case LOADED: 
                case STOP: {
                    enumSet.add(ToolbarDisplayLayout.UpdateFlags.PROGRESS);
                    if (this.progressBar.getVisibility() != 0) break;
                    this.progressBar.animateProgress(tab.getLoadProgress());
                    break;
                }
                case SELECTED: {
                    enumSet.add(ToolbarDisplayLayout.UpdateFlags.PROGRESS);
                    this.updateProgressVisibility();
                }
            }
            switch (tabEvents) {
                case STOP: {
                    enumSet.add(ToolbarDisplayLayout.UpdateFlags.TITLE);
                }
                case ADDED: 
                case CLOSED: 
                case START: {
                    this.updateBackButton(tab);
                    this.updateForwardButton(tab);
                    break;
                }
                case SELECTED: {
                    enumSet.add(ToolbarDisplayLayout.UpdateFlags.PRIVATE_MODE);
                    this.setPrivateMode(tab.isPrivate());
                }
                case LOAD_ERROR: {
                    enumSet.add(ToolbarDisplayLayout.UpdateFlags.TITLE);
                }
                case LOCATION_CHANGE: {
                    enumSet.add(ToolbarDisplayLayout.UpdateFlags.FAVICON);
                    enumSet.add(ToolbarDisplayLayout.UpdateFlags.SITE_IDENTITY);
                    this.updateBackButton(tab);
                    this.updateForwardButton(tab);
                    break;
                }
                case TITLE: {
                    enumSet.add(ToolbarDisplayLayout.UpdateFlags.TITLE);
                    break;
                }
                case FAVICON: {
                    enumSet.add(ToolbarDisplayLayout.UpdateFlags.FAVICON);
                    break;
                }
                case SECURITY_CHANGE: {
                    enumSet.add(ToolbarDisplayLayout.UpdateFlags.SITE_IDENTITY);
                }
            }
            if (!enumSet.isEmpty()) {
                this.updateDisplayLayout(tab, enumSet);
            }
        }
        switch (tabEvents) {
            case SELECTED: 
            case LOCATION_CHANGE: 
            case LOAD_ERROR: {
                this.isSwitchingTabs = false;
            }
        }
    }

    private void updateProgressVisibility() {
        Tab tab = Tabs.getInstance().getSelectedTab();
        this.updateProgressVisibility(tab, tab.getLoadProgress());
    }

    private void updateProgressVisibility(Tab tab, int n) {
        if (!this.isEditing() && tab.getState() == 1) {
            this.progressBar.setProgress(n);
            this.progressBar.setVisibility(0);
        } else {
            this.progressBar.setVisibility(8);
        }
    }

    private boolean isVisible() {
        return ViewHelper.getTranslationY((View)this) == 0.0f;
    }

    public void setNextFocusDownId(int n) {
        super.setNextFocusDownId(n);
        this.tabsButton.setNextFocusDownId(n);
        this.backButton.setNextFocusDownId(n);
        this.forwardButton.setNextFocusDownId(n);
        this.urlDisplayLayout.setNextFocusDownId(n);
        this.menuButton.setNextFocusDownId(n);
    }

    private int getUrlBarEntryTranslation() {
        return this.editCancel.getLeft() - this.urlBarEntry.getRight();
    }

    private int getUrlBarCurveTranslation() {
        return this.getWidth() - this.tabsButton.getLeft();
    }

    private boolean canDoBack(Tab tab) {
        return tab.canDoBack() && !this.isEditing();
    }

    private boolean canDoForward(Tab tab) {
        return tab.canDoForward() && !this.isEditing();
    }

    private void addTab() {
        this.activity.addTab();
    }

    private void toggleTabs() {
        if (this.activity.areTabsShown()) {
            if (this.activity.hasTabsSideBar()) {
                this.activity.hideTabs();
            }
        } else {
            InputMethodManager inputMethodManager = (InputMethodManager)this.activity.getSystemService("input_method");
            inputMethodManager.hideSoftInputFromWindow(this.tabsButton.getWindowToken(), 0);
            Tab tab = Tabs.getInstance().getSelectedTab();
            if (tab != null) {
                if (!tab.isPrivate()) {
                    this.activity.showNormalTabs();
                } else {
                    this.activity.showPrivateTabs();
                }
            }
        }
    }

    private void updateTabCountAndAnimate(int n) {
        if (!this.isVisible()) {
            this.updateTabCount(n);
            return;
        }
        if (!this.isEditing() || HardwareUtils.isTablet()) {
            this.tabsCounter.setCount(n);
            this.tabsButton.setContentDescription(n > 1 ? this.activity.getString(R.string.num_tabs, new Object[]{n}) : this.activity.getString(R.string.one_tab));
        }
    }

    private void updateTabCount(int n) {
        if (this.isEditing() && !HardwareUtils.isTablet()) {
            return;
        }
        if (this.isVisible() && ViewHelper.getAlpha((View)this.tabsCounter) != 0.0f && !this.isEditing()) {
            this.tabsCounter.setCountWithAnimation(n);
        } else {
            this.tabsCounter.setCount(n);
        }
        this.tabsButton.setContentDescription(n > 1 ? this.activity.getString(R.string.num_tabs, new Object[]{n}) : this.activity.getString(R.string.one_tab));
    }

    private void updateDisplayLayout(Tab tab, EnumSet<ToolbarDisplayLayout.UpdateFlags> enumSet) {
        if (this.isSwitchingTabs) {
            enumSet.add(ToolbarDisplayLayout.UpdateFlags.DISABLE_ANIMATIONS);
        }
        this.urlDisplayLayout.updateFromTab(tab, enumSet);
        if (enumSet.contains((Object)ToolbarDisplayLayout.UpdateFlags.TITLE) && !this.isEditing()) {
            this.urlEditLayout.setText(tab.getURL());
        }
        if (enumSet.contains((Object)ToolbarDisplayLayout.UpdateFlags.PROGRESS)) {
            this.updateFocusOrder();
        }
    }

    private void updateFocusOrder() {
        View view = null;
        boolean bl = false;
        for (View view2 : this.focusOrder) {
            if (view2.getVisibility() != 0 || !view2.isEnabled()) {
                if (!view2.hasFocus()) continue;
                bl = true;
                continue;
            }
            if (view2 == this.actionItemBar) {
                int n = this.actionItemBar.getChildCount();
                for (int i = 0; i < n; ++i) {
                    View view3 = this.actionItemBar.getChildAt(i);
                    if (view != null) {
                        view3.setNextFocusLeftId(view.getId());
                        view.setNextFocusRightId(view3.getId());
                    }
                    view = view3;
                }
                continue;
            }
            if (view != null) {
                view2.setNextFocusLeftId(view.getId());
                view.setNextFocusRightId(view2.getId());
            }
            view = view2;
        }
        if (bl) {
            this.requestFocus();
        }
    }

    public void onEditSuggestion(String string2) {
        if (!this.isEditing()) {
            return;
        }
        this.urlEditLayout.onEditSuggestion(string2);
    }

    public void setTitle(CharSequence charSequence) {
        this.urlDisplayLayout.setTitle(charSequence);
    }

    public void prepareTabsAnimation(PropertyAnimator propertyAnimator, boolean bl) {
        if (!bl) {
            PropertyAnimator propertyAnimator2 = new PropertyAnimator(propertyAnimator.getDuration(), buttonsInterpolator);
            propertyAnimator2.attach((View)this.tabsCounter, PropertyAnimator.Property.ALPHA, 1.0f);
            if (this.hasSoftMenuButton && !HardwareUtils.isTablet()) {
                propertyAnimator2.attach((View)this.menuIcon, PropertyAnimator.Property.ALPHA, 1.0f);
            }
            propertyAnimator2.start();
            return;
        }
        ViewHelper.setAlpha((View)this.tabsCounter, 0.0f);
        if (this.hasSoftMenuButton && !HardwareUtils.isTablet()) {
            ViewHelper.setAlpha((View)this.menuIcon, 0.0f);
        }
    }

    public void finishTabsAnimation(boolean bl) {
        if (bl) {
            return;
        }
        PropertyAnimator propertyAnimator = new PropertyAnimator(150L);
        propertyAnimator.attach((View)this.tabsCounter, PropertyAnimator.Property.ALPHA, 1.0f);
        if (this.hasSoftMenuButton && !HardwareUtils.isTablet()) {
            propertyAnimator.attach((View)this.menuIcon, PropertyAnimator.Property.ALPHA, 1.0f);
        }
        propertyAnimator.start();
    }

    public void setOnActivateListener(OnActivateListener onActivateListener) {
        this.activateListener = onActivateListener;
    }

    public void setOnCommitListener(OnCommitListener onCommitListener) {
        this.urlEditLayout.setOnCommitListener(onCommitListener);
    }

    public void setOnDismissListener(OnDismissListener onDismissListener) {
        this.urlEditLayout.setOnDismissListener(onDismissListener);
    }

    public void setOnFilterListener(OnFilterListener onFilterListener) {
        this.urlEditLayout.setOnFilterListener(onFilterListener);
    }

    public void setOnFocusChangeListener(View.OnFocusChangeListener onFocusChangeListener) {
        this.focusChangeListener = onFocusChangeListener;
    }

    public void setOnStartEditingListener(OnStartEditingListener onStartEditingListener) {
        this.startEditingListener = onStartEditingListener;
    }

    public void setOnStopEditingListener(OnStopEditingListener onStopEditingListener) {
        this.stopEditingListener = onStopEditingListener;
    }

    private void showUrlEditLayout() {
        this.setUrlEditLayoutVisibility(true, null);
    }

    private void showUrlEditLayout(PropertyAnimator propertyAnimator) {
        this.setUrlEditLayoutVisibility(true, propertyAnimator);
    }

    private void hideUrlEditLayout() {
        this.setUrlEditLayoutVisibility(false, null);
    }

    private void hideUrlEditLayout(PropertyAnimator propertyAnimator) {
        this.setUrlEditLayoutVisibility(false, propertyAnimator);
    }

    private void setUrlEditLayoutVisibility(final boolean bl, PropertyAnimator propertyAnimator) {
        if (bl) {
            this.urlEditLayout.prepareShowAnimation(propertyAnimator);
        }
        if (propertyAnimator == null) {
            ThemedLinearLayout themedLinearLayout = bl ? this.urlEditLayout : this.urlDisplayLayout;
            ThemedLinearLayout themedLinearLayout2 = bl ? this.urlDisplayLayout : this.urlEditLayout;
            themedLinearLayout2.setVisibility(8);
            themedLinearLayout.setVisibility(0);
            int n = bl ? 0 : 4;
            this.setCancelVisibility(n);
            return;
        }
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            @Override
            public void onPropertyAnimationStart() {
                if (!bl) {
                    BrowserToolbar.this.urlEditLayout.setVisibility(8);
                    BrowserToolbar.this.urlDisplayLayout.setVisibility(0);
                    BrowserToolbar.this.setCancelVisibility(4);
                }
            }

            @Override
            public void onPropertyAnimationEnd() {
                if (bl) {
                    BrowserToolbar.this.urlDisplayLayout.setVisibility(8);
                    BrowserToolbar.this.urlEditLayout.setVisibility(0);
                    BrowserToolbar.this.setCancelVisibility(0);
                }
            }
        });
    }

    private void setCancelVisibility(int n) {
        this.editCancel.setVisibility(n);
    }

    private void updateChildrenEnabledStateForEditing() {
        boolean bl;
        boolean bl2 = bl = !this.isEditing();
        if (!bl) {
            this.tabsCounter.onEnterEditingMode();
        }
        this.tabsButton.setEnabled(bl);
        this.menuButton.setEnabled(bl);
        int n = this.actionItemBar.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.actionItemBar.getChildAt(i).setEnabled(bl);
        }
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab != null) {
            this.setButtonEnabled(this.backButton, this.canDoBack(tab));
            this.setButtonEnabled(this.forwardButton, this.canDoForward(tab));
            if (!this.isEditing()) {
                this.animateForwardButton(this.canDoForward(tab) ? ForwardButtonAnimation.SHOW : ForwardButtonAnimation.HIDE);
            }
        }
    }

    private void setUIMode(UIMode uIMode) {
        this.uiMode = uIMode;
        this.urlEditLayout.setEnabled(uIMode == UIMode.EDIT);
    }

    public boolean isEditing() {
        return this.uiMode == UIMode.EDIT;
    }

    public boolean isAnimating() {
        return this.isAnimatingEntry;
    }

    public void startEditing(String string2, PropertyAnimator propertyAnimator) {
        if (this.isEditing()) {
            return;
        }
        this.urlEditLayout.setText(string2 != null ? string2 : "");
        this.setUIMode(UIMode.EDIT);
        this.updateProgressVisibility();
        if (this.startEditingListener != null) {
            this.startEditingListener.onStartEditing();
        }
        if (HardwareUtils.isTablet()) {
            this.showEditingOnTablet();
        } else {
            this.urlBarTranslatingEdge.setVisibility(0);
            int n = this.getUrlBarCurveTranslation();
            int n2 = this.getUrlBarEntryTranslation();
            boolean bl = this.shouldShrinkURLBar = n2 < 0;
            if (this.shouldShrinkURLBar) {
                this.urlBarEntry.setLayoutParams((ViewGroup.LayoutParams)this.urlBarEntryShrunkenLayoutParams);
            }
            if (AppConstants.Versions.preHC) {
                this.showEditingOnPreHoneycomb(n2, n);
            } else {
                this.showEditingWithPhoneAnimation(propertyAnimator, n2, n);
            }
        }
    }

    private void showEditingOnPreHoneycomb(int n, int n2) {
        this.showUrlEditLayout();
        this.tabsButton.setEnabled(false);
        ViewHelper.setTranslationX((View)this.urlBarTranslatingEdge, n);
        ViewHelper.setTranslationX((View)this.tabsButton, n2);
        ViewHelper.setTranslationX((View)this.tabsCounter, n2);
        ViewHelper.setTranslationX((View)this.actionItemBar, n2);
        if (this.hasSoftMenuButton) {
            this.menuButton.setEnabled(false);
            ViewHelper.setTranslationX((View)this.menuButton, n2);
            ViewHelper.setTranslationX((View)this.menuIcon, n2);
        }
    }

    private void showEditingOnTablet() {
        if (this.tabletDisplayModeViews == null) {
            this.tabletDisplayModeViews = this.populateTabletViews();
        }
        this.urlBarEntry.setLayoutParams((ViewGroup.LayoutParams)this.urlBarEntryShrunkenLayoutParams);
        this.updateChildrenEnabledStateForEditing();
        for (View view : this.tabletDisplayModeViews) {
            view.setVisibility(4);
        }
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab != null && tab.canDoForward()) {
            this.hidForwardButtonOnStartEditing = true;
            this.forwardButton.setVisibility(4);
        } else {
            this.hidForwardButtonOnStartEditing = false;
        }
        this.showUrlEditLayout();
    }

    private void showEditingWithPhoneAnimation(PropertyAnimator propertyAnimator, int n, int n2) {
        if (this.isAnimatingEntry) {
            return;
        }
        this.urlDisplayLayout.prepareStartEditingAnimation();
        propertyAnimator.attach((View)this.urlBarTranslatingEdge, PropertyAnimator.Property.TRANSLATION_X, n);
        propertyAnimator.attach((View)this.tabsButton, PropertyAnimator.Property.TRANSLATION_X, n2);
        propertyAnimator.attach((View)this.tabsCounter, PropertyAnimator.Property.TRANSLATION_X, n2);
        propertyAnimator.attach((View)this.actionItemBar, PropertyAnimator.Property.TRANSLATION_X, n2);
        if (this.hasSoftMenuButton) {
            propertyAnimator.attach((View)this.menuButton, PropertyAnimator.Property.TRANSLATION_X, n2);
            propertyAnimator.attach((View)this.menuIcon, PropertyAnimator.Property.TRANSLATION_X, n2);
        }
        this.showUrlEditLayout(propertyAnimator);
        propertyAnimator.addPropertyAnimationListener(this.showEditingPhoneAnimationListener);
        this.isAnimatingEntry = true;
    }

    public String cancelEdit() {
        Telemetry.stopUISession(TelemetryContract.Session.AWESOMESCREEN);
        return this.stopEditing();
    }

    public String commitEdit() {
        String string2 = this.stopEditing();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.setTitle(string2);
        }
        return string2;
    }

    private String stopEditing() {
        String string2 = this.urlEditLayout.getText();
        if (!this.isEditing()) {
            return string2;
        }
        this.setUIMode(UIMode.DISPLAY);
        this.updateChildrenEnabledStateForEditing();
        if (this.stopEditingListener != null) {
            this.stopEditingListener.onStopEditing();
        }
        this.updateProgressVisibility();
        this.urlEditLayout.clearFocus();
        if (AppConstants.Versions.preHC) {
            this.stopEditingOnPreHoneycomb();
        } else if (HardwareUtils.isTablet()) {
            this.stopEditingOnTablet();
        } else {
            this.stopEditingWithPhoneAnimation();
        }
        return string2;
    }

    private void stopEditingOnPreHoneycomb() {
        this.hideUrlEditLayout();
        this.updateTabCountAndAnimate(Tabs.getInstance().getDisplayCount());
        if (this.shouldShrinkURLBar) {
            this.urlBarEntry.setLayoutParams((ViewGroup.LayoutParams)this.urlBarEntryDefaultLayoutParams);
        }
        this.tabsButton.setEnabled(true);
        this.urlBarTranslatingEdge.setVisibility(4);
        ViewHelper.setTranslationX((View)this.urlBarTranslatingEdge, 0.0f);
        ViewHelper.setTranslationX((View)this.tabsButton, 0.0f);
        ViewHelper.setTranslationX((View)this.tabsCounter, 0.0f);
        ViewHelper.setTranslationX((View)this.actionItemBar, 0.0f);
        if (this.hasSoftMenuButton) {
            this.menuButton.setEnabled(true);
            ViewHelper.setTranslationX((View)this.menuButton, 0.0f);
            ViewHelper.setTranslationX((View)this.menuIcon, 0.0f);
        }
    }

    private void stopEditingOnTablet() {
        if (this.tabletDisplayModeViews == null) {
            throw new IllegalStateException("We initialize tabletDisplayModeViews in the transition to show editing mode and don't expect stop editing to be called first.");
        }
        this.urlBarEntry.setLayoutParams((ViewGroup.LayoutParams)this.urlBarEntryDefaultLayoutParams);
        this.updateChildrenEnabledStateForEditing();
        for (View view : this.tabletDisplayModeViews) {
            view.setVisibility(0);
        }
        if (this.hidForwardButtonOnStartEditing) {
            this.forwardButton.setVisibility(0);
        }
        this.hideUrlEditLayout();
    }

    private void stopEditingWithPhoneAnimation() {
        PropertyAnimator propertyAnimator = new PropertyAnimator(250L);
        propertyAnimator.setUseHardwareLayer(false);
        propertyAnimator.attach((View)this.urlBarTranslatingEdge, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
        propertyAnimator.attach((View)this.tabsButton, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
        propertyAnimator.attach((View)this.tabsCounter, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
        propertyAnimator.attach((View)this.actionItemBar, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
        if (this.hasSoftMenuButton) {
            propertyAnimator.attach((View)this.menuButton, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
            propertyAnimator.attach((View)this.menuIcon, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
        }
        this.hideUrlEditLayout(propertyAnimator);
        propertyAnimator.addPropertyAnimationListener(this.stopEditingPhoneAnimationListener);
        this.isAnimatingEntry = true;
        propertyAnimator.start();
    }

    private void setButtonEnabled(ImageButton imageButton, boolean bl) {
        Drawable drawable2 = imageButton.getDrawable();
        if (drawable2 != null) {
            drawable2.setAlpha(bl ? 255 : 61);
        }
        imageButton.setEnabled(bl);
    }

    public void updateBackButton(Tab tab) {
        this.setButtonEnabled(this.backButton, this.canDoBack(tab));
    }

    private void animateForwardButton(ForwardButtonAnimation forwardButtonAnimation) {
        if (this.forwardButton.getVisibility() != 0) {
            return;
        }
        final boolean bl = forwardButtonAnimation == ForwardButtonAnimation.SHOW;
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)this.forwardButton.getLayoutParams();
        if (marginLayoutParams.leftMargin > this.defaultForwardMargin && bl || marginLayoutParams.leftMargin == this.defaultForwardMargin && !bl) {
            return;
        }
        PropertyAnimator propertyAnimator = new PropertyAnimator(this.isSwitchingTabs ? 10L : 450L);
        final int n = this.forwardButton.getWidth() / 2;
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            @Override
            public void onPropertyAnimationStart() {
                if (!bl) {
                    ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbar.this.urlDisplayLayout.getLayoutParams();
                    marginLayoutParams.leftMargin = 0;
                    marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbar.this.urlEditLayout.getLayoutParams();
                    marginLayoutParams.leftMargin = 0;
                    BrowserToolbar.this.requestLayout();
                }
            }

            @Override
            public void onPropertyAnimationEnd() {
                ViewGroup.MarginLayoutParams marginLayoutParams;
                if (bl) {
                    marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbar.this.urlDisplayLayout.getLayoutParams();
                    marginLayoutParams.leftMargin = BrowserToolbar.this.urlBarViewOffset;
                    marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbar.this.urlEditLayout.getLayoutParams();
                    marginLayoutParams.leftMargin = BrowserToolbar.this.urlBarViewOffset;
                }
                BrowserToolbar.this.urlDisplayLayout.finishForwardAnimation();
                marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbar.this.forwardButton.getLayoutParams();
                marginLayoutParams.leftMargin = BrowserToolbar.this.defaultForwardMargin + (bl ? n : 0);
                ViewHelper.setTranslationX((View)BrowserToolbar.this.forwardButton, 0.0f);
                BrowserToolbar.this.requestLayout();
            }
        });
        this.prepareForwardAnimation(propertyAnimator, forwardButtonAnimation, n);
        propertyAnimator.start();
    }

    public void updateForwardButton(Tab tab) {
        boolean bl = this.canDoForward(tab);
        if (this.forwardButton.isEnabled() == bl) {
            return;
        }
        this.setButtonEnabled(this.forwardButton, bl);
        this.animateForwardButton(bl ? ForwardButtonAnimation.SHOW : ForwardButtonAnimation.HIDE);
    }

    private void prepareForwardAnimation(PropertyAnimator propertyAnimator, ForwardButtonAnimation forwardButtonAnimation, int n) {
        if (forwardButtonAnimation == ForwardButtonAnimation.HIDE) {
            propertyAnimator.attach((View)this.forwardButton, PropertyAnimator.Property.TRANSLATION_X, -n);
            propertyAnimator.attach((View)this.forwardButton, PropertyAnimator.Property.ALPHA, 0.0f);
        } else {
            propertyAnimator.attach((View)this.forwardButton, PropertyAnimator.Property.TRANSLATION_X, n);
            propertyAnimator.attach((View)this.forwardButton, PropertyAnimator.Property.ALPHA, 1.0f);
        }
        this.urlDisplayLayout.prepareForwardAnimation(propertyAnimator, forwardButtonAnimation, n);
    }

    @Override
    public boolean addActionItem(View view) {
        this.actionItemBar.addView(view);
        return true;
    }

    @Override
    public void removeActionItem(View view) {
        this.actionItemBar.removeView(view);
    }

    @Override
    public void setPrivateMode(boolean bl) {
        super.setPrivateMode(bl);
        this.tabsButton.setPrivateMode(bl);
        this.menuButton.setPrivateMode(bl);
        this.menuIcon.setPrivateMode(bl);
        this.editCancel.setPrivateMode(bl);
        this.urlEditLayout.setPrivateMode(bl);
        if (this.backButton instanceof BackButton) {
            ((BackButton)this.backButton).setPrivateMode(bl);
        }
        if (this.forwardButton instanceof ForwardButton) {
            ((ForwardButton)this.forwardButton).setPrivateMode(bl);
        }
    }

    public void show() {
        this.setVisibility(0);
    }

    public void hide() {
        this.setVisibility(8);
    }

    public View getDoorHangerAnchor() {
        return this.urlDisplayLayout.getDoorHangerAnchor();
    }

    public void onDestroy() {
        Tabs.unregisterOnTabsChangedListener(this);
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "Reader:Click", "Reader:LongClick");
    }

    public boolean openOptionsMenu() {
        if (!this.hasSoftMenuButton) {
            return false;
        }
        if (this.menuPopup == null) {
            MenuPanel menuPanel = this.activity.getMenuPanel();
            this.menuPopup = new MenuPopup((Context)this.activity);
            this.menuPopup.setPanelView((View)menuPanel);
            this.menuPopup.setOnDismissListener(new PopupWindow.OnDismissListener(){

                public void onDismiss() {
                    BrowserToolbar.this.activity.onOptionsMenuClosed(null);
                }
            });
        }
        GeckoAppShell.getGeckoInterface().invalidateOptionsMenu();
        if (!this.menuPopup.isShowing()) {
            this.menuPopup.showAsDropDown((View)this.menuButton);
        }
        return true;
    }

    public boolean closeOptionsMenu() {
        if (!this.hasSoftMenuButton) {
            return false;
        }
        if (this.menuPopup != null && this.menuPopup.isShowing()) {
            this.menuPopup.dismiss();
        }
        return true;
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        Tab tab;
        Log.d((String)LOGTAG, (String)("handleMessage: " + string2));
        if (string2.equals("Reader:Click")) {
            Tab tab2 = Tabs.getInstance().getSelectedTab();
            if (tab2 != null) {
                tab2.toggleReaderMode();
            }
        } else if (string2.equals("Reader:LongClick") && (tab = Tabs.getInstance().getSelectedTab()) != null) {
            tab.addToReadingList();
        }
    }

    @Override
    public void onLightweightThemeChanged() {
        Drawable drawable2 = this.theme.getDrawable((View)this);
        if (drawable2 == null) {
            return;
        }
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(PRIVATE_STATE_SET, (Drawable)this.getColorDrawable(R.color.background_private));
        stateListDrawable.addState(EMPTY_STATE_SET, drawable2);
        this.setBackgroundDrawable((Drawable)stateListDrawable);
        this.editCancel.onLightweightThemeChanged();
    }

    @Override
    public void onLightweightThemeReset() {
        this.setBackgroundResource(R.drawable.url_bar_bg);
        this.editCancel.onLightweightThemeReset();
    }

    static enum ForwardButtonAnimation {
        SHOW,
        HIDE;

    }

    private static enum UIMode {
        EDIT,
        DISPLAY;

    }

    public static interface OnStopEditingListener {
        public void onStopEditing();
    }

    public static interface OnStartEditingListener {
        public void onStartEditing();
    }

    public static interface OnFilterListener {
        public void onFilter(String var1, AutocompleteHandler var2);
    }

    public static interface OnDismissListener {
        public void onDismiss();
    }

    public static interface OnCommitListener {
        public void onCommit();
    }

    public static interface OnActivateListener {
        public void onActivate();
    }
}

