/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.search;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import java.util.List;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.LocaleAware;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.search.R;
import org.mozilla.search.providers.SearchEngine;
import org.mozilla.search.providers.SearchEngineManager;

public class SearchPreferenceActivity
extends PreferenceActivity
implements SharedPreferences.OnSharedPreferenceChangeListener {
    private static final String LOG_TAG = "SearchPreferenceActivity";
    public static final String PREF_CLEAR_HISTORY_KEY = "search.not_a_preference.clear_history";
    public static final String PREF_SEARCH_ENGINE_KEY = "search.engines.default";
    private SearchEngineManager searchEngineManager;

    protected void onCreate(Bundle bundle) {
        LocaleAware.initializeLocale((Context)this.getApplicationContext());
        super.onCreate(bundle);
        this.getPreferenceManager().setSharedPreferencesName("GeckoApp");
        this.searchEngineManager = new SearchEngineManager((Context)this);
        if (Build.VERSION.SDK_INT >= 11 && this.getActionBar() != null) {
            this.getActionBar().setDisplayHomeAsUpEnabled(true);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.searchEngineManager.destroy();
    }

    protected void onResume() {
        super.onResume();
        GeckoSharedPrefs.forApp((Context)this).registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
    }

    protected void onPause() {
        super.onPause();
        GeckoSharedPrefs.forApp((Context)this).unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
    }

    protected void onPostCreate(Bundle bundle) {
        super.onPostCreate(bundle);
        this.setupPrefsScreen();
    }

    private void setupPrefsScreen() {
        this.addPreferencesFromResource(R.xml.search_preferences);
        Preference preference = this.findPreference(PREF_CLEAR_HISTORY_KEY);
        preference.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener(){

            public boolean onPreferenceClick(Preference preference) {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)SearchPreferenceActivity.this);
                builder.setNegativeButton(0x1040000, null);
                builder.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                        Telemetry.sendUIEvent((TelemetryContract.Event)TelemetryContract.Event.SANITIZE, (TelemetryContract.Method)TelemetryContract.Method.MENU, (String)"search-history");
                        SearchPreferenceActivity.this.clearHistory();
                    }
                });
                builder.setMessage(R.string.pref_clearHistory_dialogMessage);
                builder.show();
                return false;
            }
        });
        this.setUpSearchEnginePref();
    }

    private void setUpSearchEnginePref() {
        AsyncTask<Void, Void, List<SearchEngine>> asyncTask = new AsyncTask<Void, Void, List<SearchEngine>>(){

            protected List<SearchEngine> doInBackground(Void ... voidArray) {
                return SearchPreferenceActivity.this.searchEngineManager.getAllEngines();
            }

            protected void onPostExecute(List<SearchEngine> list) {
                CharSequence[] charSequenceArray = new CharSequence[list.size()];
                CharSequence[] charSequenceArray2 = new CharSequence[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    SearchEngine searchEngine = list.get(i);
                    charSequenceArray[i] = searchEngine.getName();
                    charSequenceArray2[i] = searchEngine.getIdentifier();
                }
                ListPreference listPreference = (ListPreference)SearchPreferenceActivity.this.findPreference(SearchPreferenceActivity.PREF_SEARCH_ENGINE_KEY);
                listPreference.setEntries(charSequenceArray);
                listPreference.setEntryValues(charSequenceArray2);
                if (listPreference.getValue() == null) {
                    listPreference.setValue(SearchPreferenceActivity.this.getResources().getString(R.string.default_engine_identifier));
                }
                listPreference.setSummary(listPreference.getEntry());
            }
        };
        asyncTask.execute((Object[])new Void[0]);
    }

    private void clearHistory() {
        AsyncTask<Void, Void, Boolean> asyncTask = new AsyncTask<Void, Void, Boolean>(){

            protected Boolean doInBackground(Void ... voidArray) {
                int n = SearchPreferenceActivity.this.getContentResolver().delete(BrowserContract.SearchHistory.CONTENT_URI, null, null);
                return n >= 0;
            }

            protected void onPostExecute(Boolean bl) {
                if (bl.booleanValue()) {
                    SearchPreferenceActivity.this.getContentResolver().notifyChange(BrowserContract.SearchHistory.CONTENT_URI, null);
                    Toast.makeText((Context)SearchPreferenceActivity.this, (CharSequence)SearchPreferenceActivity.this.getResources().getString(R.string.pref_clearHistory_confirmation), (int)0).show();
                } else {
                    Log.e((String)SearchPreferenceActivity.LOG_TAG, (String)"Error clearing search history.");
                }
            }
        };
        asyncTask.execute((Object[])new Void[0]);
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String string2) {
        if (TextUtils.equals((CharSequence)PREF_SEARCH_ENGINE_KEY, (CharSequence)string2)) {
            ListPreference listPreference = (ListPreference)this.findPreference(PREF_SEARCH_ENGINE_KEY);
            listPreference.setSummary(listPreference.getEntry());
            Telemetry.sendUIEvent((TelemetryContract.Event)TelemetryContract.Event.SEARCH_SET_DEFAULT, (TelemetryContract.Method)TelemetryContract.Method.DIALOG, (String)listPreference.getValue().toLowerCase());
        }
    }
}

