/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import org.mozilla.gecko.util.StringUtils;

public class AboutPages {
    public static final String ADDONS = "about:addons";
    public static final String APPS = "about:apps";
    public static final String CONFIG = "about:config";
    public static final String DOWNLOADS = "about:downloads";
    public static final String FIREFOX = "about:firefox";
    public static final String HEALTHREPORT = "about:healthreport";
    public static final String HOME = "about:home";
    public static final String PRIVATEBROWSING = "about:privatebrowsing";
    public static final String READER = "about:reader";
    public static final String UPDATER = "about:";
    public static final String URL_FILTER = "about:%";
    public static final String PANEL_PARAM = "panel";
    private static final String[] DEFAULT_ICON_PAGES = new String[]{"about:addons", "about:config", "about:downloads", "about:firefox", "about:healthreport", "about:"};

    public static final boolean isAboutPage(String string2) {
        return string2 != null && string2.startsWith(UPDATER);
    }

    public static final boolean isTitlelessAboutPage(String string2) {
        return AboutPages.isAboutHome(string2) || PRIVATEBROWSING.equals(string2);
    }

    public static final boolean isAboutHome(String string2) {
        if (string2 == null || !string2.startsWith(HOME)) {
            return false;
        }
        return HOME.equals(string2.split("\\?")[0]);
    }

    public static final String getPanelIdFromAboutHomeUrl(String string2) {
        return StringUtils.getQueryParameter((String)string2, (String)PANEL_PARAM);
    }

    public static final boolean isAboutReader(String string2) {
        if (string2 == null) {
            return false;
        }
        return string2.startsWith(READER);
    }

    public static String[] getDefaultIconPages() {
        return DEFAULT_ICON_PAGES;
    }

    public static boolean isBuiltinIconPage(String string2) {
        if (string2 == null || !string2.startsWith(UPDATER)) {
            return false;
        }
        if (AboutPages.isAboutHome(string2)) {
            return true;
        }
        for (int i = 0; i < DEFAULT_ICON_PAGES.length; ++i) {
            if (!DEFAULT_ICON_PAGES[i].equals(string2)) continue;
            return true;
        }
        return false;
    }
}

