/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.location.Location;
import android.location.LocationListener;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.StrictMode;
import android.os.SystemClock;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Base64;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.OrientationEventListener;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.Window;
import android.widget.AbsoluteLayout;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.SimpleAdapter;
import android.widget.TextView;
import android.widget.Toast;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.ActivityHandlerHelper;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.AppNotificationClient;
import org.mozilla.gecko.BrowserLocaleManager;
import org.mozilla.gecko.ContactService;
import org.mozilla.gecko.ContextGetter;
import org.mozilla.gecko.DoorHangerPopup;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.FormAssistPopup;
import org.mozilla.gecko.GeckoAccessibility;
import org.mozilla.gecko.GeckoActivity;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoApplication;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoJavaSampler;
import org.mozilla.gecko.GeckoNetworkManager;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoProfileDirectories;
import org.mozilla.gecko.GeckoScreenOrientation;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.IntentHelper;
import org.mozilla.gecko.LocaleManager;
import org.mozilla.gecko.MemoryMonitor;
import org.mozilla.gecko.MotionEventInterceptor;
import org.mozilla.gecko.NotificationClient;
import org.mozilla.gecko.NotificationHelper;
import org.mozilla.gecko.PrefsHelper;
import org.mozilla.gecko.R;
import org.mozilla.gecko.SessionParser;
import org.mozilla.gecko.SmsManager;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.TextSelection;
import org.mozilla.gecko.TextSelectionHandle;
import org.mozilla.gecko.TouchEventInterceptor;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.gfx.FullScreenState;
import org.mozilla.gecko.gfx.Layer;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.gfx.PluginLayer;
import org.mozilla.gecko.health.HealthRecorder;
import org.mozilla.gecko.health.SessionInformation;
import org.mozilla.gecko.health.StubbedHealthRecorder;
import org.mozilla.gecko.menu.GeckoMenu;
import org.mozilla.gecko.menu.GeckoMenuInflater;
import org.mozilla.gecko.menu.MenuPanel;
import org.mozilla.gecko.mozglue.GeckoLoader;
import org.mozilla.gecko.preferences.GeckoPreferences;
import org.mozilla.gecko.prompts.PromptService;
import org.mozilla.gecko.updater.UpdateService;
import org.mozilla.gecko.updater.UpdateServiceHelper;
import org.mozilla.gecko.util.ActivityResultHandler;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.FileUtils;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.HardwareUtils;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSObject;
import org.mozilla.gecko.util.PrefUtils;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.webapp.EventListener;
import org.mozilla.gecko.webapp.UninstallListener;
import org.mozilla.gecko.widget.ButtonToast;

public abstract class GeckoApp
extends GeckoActivity
implements ContextGetter,
GeckoAppShell.GeckoInterface,
GeckoEventListener,
GeckoMenu.Callback,
GeckoMenu.MenuPresenter,
LocationListener,
NativeEventListener,
SensorEventListener,
Tabs.OnTabsChangedListener {
    private static final String LOGTAG = "GeckoApp";
    private static final int ONE_DAY_MS = 86400000;
    public static final String ACTION_ALERT_CALLBACK = "org.mozilla.gecko.ACTION_ALERT_CALLBACK";
    public static final String ACTION_HOMESCREEN_SHORTCUT = "org.mozilla.gecko.BOOKMARK";
    public static final String ACTION_DEBUG = "org.mozilla.gecko.DEBUG";
    public static final String ACTION_LAUNCH_SETTINGS = "org.mozilla.gecko.SETTINGS";
    public static final String ACTION_LOAD = "org.mozilla.gecko.LOAD";
    public static final String ACTION_INIT_PW = "org.mozilla.gecko.INIT_PW";
    public static final String ACTION_WEBAPP_PREFIX = "org.mozilla.gecko.WEBAPP";
    public static final String EXTRA_STATE_BUNDLE = "stateBundle";
    public static final String PREFS_ALLOW_STATE_BUNDLE = "allowStateBundle";
    public static final String PREFS_OOM_EXCEPTION = "OOMException";
    public static final String PREFS_VERSION_CODE = "versionCode";
    public static final String PREFS_WAS_STOPPED = "wasStopped";
    public static final String PREFS_CRASHED = "crashed";
    public static final String PREFS_CLEANUP_TEMP_FILES = "cleanupTempFiles";
    public static final String SAVED_STATE_IN_BACKGROUND = "inBackground";
    public static final String SAVED_STATE_PRIVATE_SESSION = "privateSession";
    private static final int CLEANUP_DEFERRAL_SECONDS = 15;
    protected RelativeLayout mMainLayout;
    protected RelativeLayout mGeckoLayout;
    private View mCameraView;
    private OrientationEventListener mCameraOrientationEventListener;
    public List<GeckoAppShell.AppStateListener> mAppStateListeners = new LinkedList<GeckoAppShell.AppStateListener>();
    protected MenuPanel mMenuPanel;
    protected Menu mMenu;
    protected GeckoProfile mProfile;
    protected boolean mIsRestoringActivity;
    private ContactService mContactService;
    private PromptService mPromptService;
    private TextSelection mTextSelection;
    protected DoorHangerPopup mDoorHangerPopup;
    protected FormAssistPopup mFormAssistPopup;
    protected ButtonToast mToast;
    protected LayerView mLayerView;
    private AbsoluteLayout mPluginContainer;
    private FullScreenHolder mFullScreenPluginContainer;
    private View mFullScreenPluginView;
    private HashMap<String, PowerManager.WakeLock> mWakeLocks = new HashMap();
    protected boolean mShouldRestore;
    protected boolean mInitialized;
    private Telemetry.Timer mJavaUiStartupTimer;
    private Telemetry.Timer mGeckoReadyStartupTimer;
    private String mPrivateBrowsingSession;
    private volatile HealthRecorder mHealthRecorder;
    private volatile Locale mLastLocale;
    private EventListener mWebappEventListener;
    private static final String RESTARTER_ACTION = "org.mozilla.gecko.restart";
    private static final String RESTARTER_CLASS = "org.mozilla.gecko.Restarter";
    private static final String SESSION_END_LOCALE_CHANGED = "L";

    public abstract int getLayout();

    @Override
    public abstract boolean hasTabsSideBar();

    protected abstract String getDefaultProfileName() throws GeckoProfileDirectories.NoMozillaDirectoryException;

    void toggleChrome(boolean bl) {
    }

    void focusChrome() {
    }

    @Override
    public Context getContext() {
        return this;
    }

    @Override
    public SharedPreferences getSharedPreferences() {
        return GeckoSharedPrefs.forApp((Context)this);
    }

    @Override
    public Activity getActivity() {
        return this;
    }

    @Override
    public LocationListener getLocationListener() {
        return this;
    }

    @Override
    public SensorEventListener getSensorEventListener() {
        return this;
    }

    @Override
    public View getCameraView() {
        return this.mCameraView;
    }

    @Override
    public void addAppStateListener(GeckoAppShell.AppStateListener appStateListener) {
        this.mAppStateListeners.add(appStateListener);
    }

    @Override
    public void removeAppStateListener(GeckoAppShell.AppStateListener appStateListener) {
        this.mAppStateListeners.remove(appStateListener);
    }

    @Override
    public FormAssistPopup getFormAssistPopup() {
        return this.mFormAssistPopup;
    }

    @Override
    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
        switch (tabEvents) {
            case UNSELECTED: {
                this.hidePlugins(tab);
                break;
            }
            case LOCATION_CHANGE: {
                if (!Tabs.getInstance().isSelectedTab(tab)) break;
            }
            case SELECTED: {
                this.invalidateOptionsMenu();
                if (this.mFormAssistPopup == null) break;
                this.mFormAssistPopup.hide();
                break;
            }
            case LOADED: {
                LayerView layerView = this.mLayerView;
                if (layerView == null || !Tabs.getInstance().isSelectedTab(tab)) break;
                layerView.setBackgroundColor(tab.getBackgroundColor());
                break;
            }
            case DESKTOP_MODE_CHANGE: {
                if (!Tabs.getInstance().isSelectedTab(tab)) break;
                this.invalidateOptionsMenu();
            }
        }
    }

    public void refreshChrome() {
    }

    @Override
    public void invalidateOptionsMenu() {
        if (this.mMenu == null) {
            return;
        }
        this.onPrepareOptionsMenu(this.mMenu);
        if (AppConstants.Versions.feature11Plus) {
            super.invalidateOptionsMenu();
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.mMenu = menu2;
        MenuInflater menuInflater = this.getMenuInflater();
        menuInflater.inflate(R.menu.gecko_app_menu, this.mMenu);
        return true;
    }

    public MenuInflater getMenuInflater() {
        if (AppConstants.Versions.feature11Plus) {
            return new GeckoMenuInflater((Context)this);
        }
        return super.getMenuInflater();
    }

    public MenuPanel getMenuPanel() {
        if (this.mMenuPanel == null) {
            this.onCreatePanelMenu(0, null);
            this.invalidateOptionsMenu();
        }
        return this.mMenuPanel;
    }

    @Override
    public boolean onMenuItemClick(MenuItem menuItem) {
        return this.onOptionsItemSelected(menuItem);
    }

    @Override
    public boolean onMenuItemLongClick(MenuItem menuItem) {
        return false;
    }

    @Override
    public void openMenu() {
        this.openOptionsMenu();
    }

    @Override
    public void showMenu(final View view) {
        this.closeMenu();
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GeckoApp.this.mMenuPanel.removeAllViews();
                GeckoApp.this.mMenuPanel.addView(view);
                GeckoApp.this.openOptionsMenu();
            }
        });
    }

    @Override
    public void closeMenu() {
        this.closeOptionsMenu();
    }

    public View onCreatePanelView(int n) {
        if (AppConstants.Versions.feature11Plus && n == 0) {
            if (this.mMenuPanel == null) {
                this.mMenuPanel = new MenuPanel((Context)this, null);
            } else {
                this.onPreparePanel(n, (View)this.mMenuPanel, this.mMenu);
            }
            return this.mMenuPanel;
        }
        return super.onCreatePanelView(n);
    }

    public boolean onCreatePanelMenu(int n, Menu menu2) {
        if (AppConstants.Versions.feature11Plus && n == 0) {
            if (this.mMenuPanel == null) {
                this.mMenuPanel = (MenuPanel)this.onCreatePanelView(n);
            }
            GeckoMenu geckoMenu = new GeckoMenu((Context)this, null);
            geckoMenu.setCallback(this);
            geckoMenu.setMenuPresenter(this);
            menu2 = geckoMenu;
            this.mMenuPanel.addView((View)geckoMenu);
            return this.onCreateOptionsMenu(menu2);
        }
        return super.onCreatePanelMenu(n, menu2);
    }

    public boolean onPreparePanel(int n, View view, Menu menu2) {
        if (AppConstants.Versions.feature11Plus && n == 0) {
            return this.onPrepareOptionsMenu(menu2);
        }
        return super.onPreparePanel(n, view, menu2);
    }

    public boolean onMenuOpened(int n, Menu menu2) {
        if (this.mLayerView != null && this.mLayerView.isFullScreen()) {
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("FullScreen:Exit", null));
        }
        if (AppConstants.Versions.feature11Plus && n == 0) {
            if (this.mMenu == null) {
                MenuPanel menuPanel = this.getMenuPanel();
                this.onPreparePanel(n, (View)menuPanel, this.mMenu);
            }
            if (this.mMenuPanel != null) {
                this.mMenuPanel.scrollTo(0, 0);
            }
            return true;
        }
        return super.onMenuOpened(n, menu2);
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == R.id.quit) {
            if (GeckoThread.checkAndSetLaunchState(GeckoThread.LaunchState.GeckoRunning, GeckoThread.LaunchState.GeckoExiting)) {
                SharedPreferences sharedPreferences = GeckoSharedPrefs.forProfile((Context)this);
                Set set = PrefUtils.getStringSet((SharedPreferences)sharedPreferences, (String)"android.not_a_preference.history.clear_on_exit", new HashSet());
                JSONObject jSONObject = new JSONObject();
                for (String string2 : set) {
                    try {
                        jSONObject.put(string2, true);
                    }
                    catch (JSONException jSONException) {
                        Log.e((String)LOGTAG, (String)("Error adding clear object " + string2), (Throwable)jSONException);
                    }
                }
                JSONObject jSONObject2 = new JSONObject();
                try {
                    jSONObject2.put("sanitize", (Object)jSONObject);
                }
                catch (JSONException jSONException) {
                    Log.e((String)LOGTAG, (String)"Error adding sanitize object", (Throwable)jSONException);
                }
                if (jSONObject.has("private.data.history")) {
                    String string2;
                    string2 = this.getSessionRestorePreference();
                    try {
                        jSONObject2.put("dontSaveSession", "quit".equals(string2));
                    }
                    catch (JSONException jSONException) {
                        Log.e((String)LOGTAG, (String)"Error adding session restore data", (Throwable)jSONException);
                    }
                }
                GeckoAppShell.notifyGeckoOfEvent(GeckoEvent.createBroadcastEvent("Browser:Quit", jSONObject2.toString()));
            } else {
                GeckoAppShell.systemExit();
            }
            return true;
        }
        return super.onOptionsItemSelected(menuItem);
    }

    public void onOptionsMenuClosed(Menu menu2) {
        if (AppConstants.Versions.feature11Plus) {
            this.mMenuPanel.removeAllViews();
            this.mMenuPanel.addView((View)((GeckoMenu)this.mMenu));
        }
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (n == 82) {
            this.openOptionsMenu();
            return true;
        }
        return super.onKeyDown(n, keyEvent);
    }

    protected void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean(SAVED_STATE_IN_BACKGROUND, this.isApplicationInBackground());
        bundle.putString(SAVED_STATE_PRIVATE_SESSION, this.mPrivateBrowsingSession);
    }

    void handleClearHistory() {
        BrowserDB.clearHistory(this.getContentResolver());
    }

    public void addTab() {
    }

    public void addPrivateTab() {
    }

    public void showNormalTabs() {
    }

    public void showPrivateTabs() {
    }

    public void hideTabs() {
    }

    public boolean autoHideTabs() {
        return false;
    }

    @Override
    public boolean areTabsShown() {
        return false;
    }

    public void handleMessage(String string2, NativeJSObject nativeJSObject, EventCallback eventCallback) {
        if ("Accessibility:Ready".equals(string2)) {
            GeckoAccessibility.updateAccessibilitySettings((Context)this);
        } else if ("Bookmark:Insert".equals(string2)) {
            final String string3 = nativeJSObject.getString("url");
            final String string4 = nativeJSObject.getString("title");
            GeckoApp geckoApp = this;
            ThreadUtils.postToBackgroundThread((Runnable)new Runnable((Context)geckoApp){
                final /* synthetic */ Context val$context;
                {
                    this.val$context = context;
                }

                @Override
                public void run() {
                    BrowserDB.addBookmark(GeckoApp.this.getContentResolver(), string4, string3);
                    ThreadUtils.postToUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Toast.makeText((Context)val$context, (int)R.string.bookmark_added, (int)0).show();
                        }
                    });
                }
            });
        } else if ("Contact:Add".equals(string2)) {
            String string5 = nativeJSObject.optString("email", null);
            String string6 = nativeJSObject.optString("phone", null);
            if (string5 != null) {
                Uri uri = Uri.parse((String)string5);
                Intent intent = new Intent("com.android.contacts.action.SHOW_OR_CREATE_CONTACT", uri);
                this.startActivity(intent);
            } else if (string6 != null) {
                Uri uri = Uri.parse((String)string6);
                Intent intent = new Intent("com.android.contacts.action.SHOW_OR_CREATE_CONTACT", uri);
                this.startActivity(intent);
            } else {
                Log.e((String)LOGTAG, (String)"Received Contact:Add message with no email nor phone number");
            }
        } else if ("DOMFullScreen:Start".equals(string2)) {
            LayerView layerView = this.mLayerView;
            if (layerView != null) {
                layerView.setFullScreenState(nativeJSObject.getBoolean("rootElement") ? FullScreenState.ROOT_ELEMENT : FullScreenState.NON_ROOT_ELEMENT);
            }
        } else if ("DOMFullScreen:Stop".equals(string2)) {
            LayerView layerView = this.mLayerView;
            if (layerView != null) {
                layerView.setFullScreenState(FullScreenState.NONE);
            }
        } else if ("Image:SetAs".equals(string2)) {
            String string7 = nativeJSObject.getString("url");
            this.setImageAs(string7);
        } else if ("Locale:Set".equals(string2)) {
            this.setLocale(nativeJSObject.getString("locale"));
        } else if ("Permissions:Data".equals(string2)) {
            String string8 = nativeJSObject.getString("host");
            NativeJSObject[] nativeJSObjectArray = nativeJSObject.getObjectArray("permissions");
            this.showSiteSettingsDialog(string8, nativeJSObjectArray);
        } else if ("PrivateBrowsing:Data".equals(string2)) {
            this.mPrivateBrowsingSession = nativeJSObject.optString("session", null);
        } else if ("Sanitize:ClearHistory".equals(string2)) {
            this.handleClearHistory();
            eventCallback.sendSuccess((Object)true);
        } else if ("Session:StatePurged".equals(string2)) {
            this.onStatePurged();
        } else if ("Share:Text".equals(string2)) {
            String string9 = nativeJSObject.getString("text");
            GeckoAppShell.openUriExternal(string9, "text/plain", "", "", "android.intent.action.SEND", "");
            Telemetry.sendUIEvent(TelemetryContract.Event.SHARE, TelemetryContract.Method.LIST);
        } else if ("SystemUI:Visibility".equals(string2)) {
            this.setSystemUiVisible(nativeJSObject.getBoolean("visible"));
        } else if ("Toast:Show".equals(string2)) {
            String string10 = nativeJSObject.getString("message");
            String string11 = nativeJSObject.getString("duration");
            NativeJSObject nativeJSObject2 = nativeJSObject.optObject("button", null);
            if (nativeJSObject2 != null) {
                String string12 = nativeJSObject2.optString("label", "");
                String string13 = nativeJSObject2.optString("icon", "");
                String string14 = nativeJSObject2.optString("id", "");
                this.showButtonToast(string10, string11, string12, string13, string14);
            } else {
                this.showNormalToast(string10, string11);
            }
        } else if ("ToggleChrome:Focus".equals(string2)) {
            this.focusChrome();
        } else if ("ToggleChrome:Hide".equals(string2)) {
            this.toggleChrome(false);
        } else if ("ToggleChrome:Show".equals(string2)) {
            this.toggleChrome(true);
        } else if ("Update:Check".equals(string2)) {
            this.startService(new Intent("org.mozilla.fennec.CHECK_FOR_UPDATE", null, (Context)this, UpdateService.class));
        } else if ("Update:Download".equals(string2)) {
            this.startService(new Intent("org.mozilla.fennec.DOWNLOAD_UPDATE", null, (Context)this, UpdateService.class));
        } else if ("Update:Install".equals(string2)) {
            this.startService(new Intent("org.mozilla.fennec.APPLY_UPDATE", null, (Context)this, UpdateService.class));
        }
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        try {
            if (string2.equals("Gecko:DelayedStartup")) {
                ThreadUtils.postToBackgroundThread((Runnable)new UninstallListener.DelayedStartupTask(this));
            } else if (string2.equals("Gecko:Ready")) {
                this.mGeckoReadyStartupTimer.stop();
                this.geckoConnected();
                HealthRecorder healthRecorder = this.mHealthRecorder;
                if (healthRecorder != null) {
                    healthRecorder.recordGeckoStartupTime(this.mGeckoReadyStartupTimer.getElapsed());
                }
            } else if ("NativeApp:IsDebuggable".equals(string2)) {
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("isDebuggable", this.getIsDebuggable());
                EventDispatcher.sendResponse(jSONObject, jSONObject2);
            } else if (string2.equals("Accessibility:Event")) {
                GeckoAccessibility.sendAccessibilityEvent(jSONObject);
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)("Exception handling message \"" + string2 + "\":"), (Throwable)exception);
        }
    }

    void onStatePurged() {
    }

    private void showSiteSettingsDialog(String string2, NativeJSObject[] nativeJSObjectArray) {
        final AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        View view = this.getLayoutInflater().inflate(R.layout.site_setting_title, null);
        ((TextView)view.findViewById(R.id.title)).setText(R.string.site_settings_title);
        ((TextView)view.findViewById(R.id.host)).setText((CharSequence)string2);
        builder.setCustomTitle(view);
        if (nativeJSObjectArray.length == 0) {
            builder.setMessage(R.string.site_settings_no_settings);
        } else {
            ArrayList arrayList = new ArrayList();
            for (NativeJSObject nativeJSObject : nativeJSObjectArray) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("setting", nativeJSObject.getString("setting"));
                hashMap.put("value", nativeJSObject.getString("value"));
                arrayList.add(hashMap);
            }
            builder.setSingleChoiceItems((ListAdapter)new SimpleAdapter((Context)this, arrayList, R.layout.site_setting_item, new String[]{"setting", "value"}, new int[]{R.id.setting, R.id.value}), -1, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n) {
                }
            });
            builder.setPositiveButton(R.string.site_settings_clear, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n) {
                    ListView listView = ((AlertDialog)dialogInterface).getListView();
                    SparseBooleanArray sparseBooleanArray = listView.getCheckedItemPositions();
                    JSONArray jSONArray = new JSONArray();
                    for (int i = 0; i < sparseBooleanArray.size(); ++i) {
                        if (!sparseBooleanArray.get(i)) continue;
                        jSONArray.put(i);
                    }
                    GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Permissions:Clear", jSONArray.toString()));
                }
            });
        }
        builder.setNegativeButton(R.string.site_settings_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                dialogInterface.cancel();
            }
        });
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AlertDialog alertDialog = builder.create();
                alertDialog.show();
                ListView listView = alertDialog.getListView();
                if (listView != null) {
                    listView.setChoiceMode(2);
                    int n = listView.getAdapter().getCount();
                    for (int i = 0; i < n; ++i) {
                        listView.setItemChecked(i, true);
                    }
                }
            }
        });
    }

    public void showToast(final int n, final int n2) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)GeckoApp.this, (int)n, (int)n2).show();
            }
        });
    }

    public void showNormalToast(final String string2, final String string3) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Toast toast = string3.equals("long") ? Toast.makeText((Context)GeckoApp.this, (CharSequence)string2, (int)1) : Toast.makeText((Context)GeckoApp.this, (CharSequence)string2, (int)0);
                toast.show();
            }
        });
    }

    public ButtonToast getButtonToast() {
        if (this.mToast != null) {
            return this.mToast;
        }
        ViewStub viewStub = (ViewStub)this.findViewById(R.id.toast_stub);
        this.mToast = new ButtonToast(viewStub.inflate());
        return this.mToast;
    }

    void showButtonToast(final String string2, final String string3, final String string4, String string5, final String string6) {
        BitmapUtils.getDrawable((Context)this, string5, new BitmapUtils.BitmapLoader(){

            @Override
            public void onBitmapFound(Drawable drawable2) {
                int n = string3.equals("long") ? ButtonToast.LENGTH_LONG : ButtonToast.LENGTH_SHORT;
                GeckoApp.this.getButtonToast().show(false, (CharSequence)string2, n, (CharSequence)string4, drawable2, new ButtonToast.ToastListener(){

                    @Override
                    public void onButtonClicked() {
                        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Toast:Click", string6));
                    }

                    @Override
                    public void onToastHidden(ButtonToast.ReasonHidden reasonHidden) {
                        if (reasonHidden == ButtonToast.ReasonHidden.TIMEOUT) {
                            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Toast:Hidden", string6));
                        }
                    }
                });
            }
        });
    }

    private void addFullScreenPluginView(View view) {
        if (this.mFullScreenPluginView != null) {
            Log.w((String)LOGTAG, (String)"Already have a fullscreen plugin view");
            return;
        }
        this.setFullScreen(true);
        view.setWillNotDraw(false);
        if (view instanceof SurfaceView) {
            ((SurfaceView)view).setZOrderOnTop(true);
        }
        this.mFullScreenPluginContainer = new FullScreenHolder((Context)this);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1, 17);
        this.mFullScreenPluginContainer.addView(view, (ViewGroup.LayoutParams)layoutParams);
        FrameLayout frameLayout = (FrameLayout)this.getWindow().getDecorView();
        frameLayout.addView((View)this.mFullScreenPluginContainer, (ViewGroup.LayoutParams)layoutParams);
        this.mFullScreenPluginView = view;
    }

    @Override
    public void addPluginView(final View view, final RectF rectF, final boolean bl) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Tabs tabs = Tabs.getInstance();
                Tab tab = tabs.getSelectedTab();
                if (bl) {
                    GeckoApp.this.addFullScreenPluginView(view);
                    return;
                }
                PluginLayer pluginLayer = (PluginLayer)tab.getPluginLayer(view);
                if (pluginLayer == null) {
                    pluginLayer = new PluginLayer(view, rectF, GeckoApp.this.mLayerView.getRenderer().getMaxTextureSize());
                    tab.addPluginLayer(view, pluginLayer);
                } else {
                    pluginLayer.reset(rectF);
                    pluginLayer.setVisible(true);
                }
                GeckoApp.this.mLayerView.addLayer(pluginLayer);
            }
        });
    }

    private void removeFullScreenPluginView(View view) {
        if (this.mFullScreenPluginView == null) {
            Log.w((String)LOGTAG, (String)"Don't have a fullscreen plugin view");
            return;
        }
        if (this.mFullScreenPluginView != view) {
            Log.w((String)LOGTAG, (String)"Passed view is not the current full screen view");
            return;
        }
        this.mFullScreenPluginContainer.removeView(this.mFullScreenPluginView);
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GeckoApp.this.mLayerView.showSurface();
            }
        });
        FrameLayout frameLayout = (FrameLayout)this.getWindow().getDecorView();
        frameLayout.removeView((View)this.mFullScreenPluginContainer);
        this.mFullScreenPluginView = null;
        GeckoScreenOrientation.getInstance().unlock();
        this.setFullScreen(false);
    }

    @Override
    public void removePluginView(final View view, final boolean bl) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Tabs tabs = Tabs.getInstance();
                Tab tab = tabs.getSelectedTab();
                if (bl) {
                    GeckoApp.this.removeFullScreenPluginView(view);
                    return;
                }
                PluginLayer pluginLayer = (PluginLayer)tab.removePluginLayer(view);
                if (pluginLayer != null) {
                    pluginLayer.destroy();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setImageAs(String string2) {
        boolean bl = string2.startsWith("data:");
        Bitmap bitmap = null;
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            Object object;
            URL uRL;
            Object object2;
            int n;
            if (bl) {
                n = string2.indexOf(",");
                object2 = Base64.decode((String)string2.substring(n + 1), (int)0);
                bitmap = BitmapUtils.decodeByteArray(object2);
            } else {
                object2 = new byte[4192];
                byteArrayOutputStream = new ByteArrayOutputStream();
                uRL = new URL(string2);
                inputStream = uRL.openStream();
                while ((n = inputStream.read((byte[])object2)) != -1) {
                    byteArrayOutputStream.write((byte[])object2, 0, n);
                }
                object = byteArrayOutputStream.toByteArray();
                bitmap = BitmapUtils.decodeByteArray(object);
            }
            if (bitmap != null) {
                String string3 = MediaStore.Images.Media.insertImage((ContentResolver)this.getContentResolver(), (Bitmap)bitmap, null, null);
                if (string3 == null) {
                    Toast.makeText((Context)this, (int)R.string.set_image_path_fail, (int)0).show();
                    return;
                }
                object2 = new Intent("android.intent.action.ATTACH_DATA");
                object2.addCategory("android.intent.category.DEFAULT");
                object2.setData(Uri.parse((String)string3));
                uRL = Intent.createChooser((Intent)object2, (CharSequence)this.getString(R.string.set_image_chooser_title));
                object = new ActivityResultHandler((Intent)object2){
                    final /* synthetic */ Intent val$intent;
                    {
                        this.val$intent = intent;
                    }

                    public void onActivityResult(int n, Intent intent) {
                        GeckoApp.this.getContentResolver().delete(this.val$intent.getData(), null, null);
                    }
                };
                ActivityHandlerHelper.startIntentForActivity((Activity)this, (Intent)uRL, (ActivityResultHandler)object);
            } else {
                Toast.makeText((Context)this, (int)R.string.set_image_fail, (int)0).show();
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Log.e((String)LOGTAG, (String)"Out of Memory when converting to byte array", (Throwable)outOfMemoryError);
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)"I/O Exception while setting wallpaper", (Throwable)iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Log.w((String)LOGTAG, (String)"I/O Exception while closing stream", (Throwable)iOException);
                }
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {
                    Log.w((String)LOGTAG, (String)"I/O Exception while closing stream", (Throwable)iOException);
                }
            }
        }
    }

    private int getBitmapSampleSize(BitmapFactory.Options options, int n, int n2) {
        int n3 = options.outWidth;
        int n4 = options.outHeight;
        int n5 = 1;
        if (n4 > n2 || n3 > n) {
            n5 = n3 > n4 ? Math.round((float)n4 / (float)n2) : Math.round((float)n3 / (float)n);
        }
        return n5;
    }

    private void hidePluginLayer(Layer layer) {
        LayerView layerView = this.mLayerView;
        layerView.removeLayer(layer);
        layerView.requestRender();
    }

    private void showPluginLayer(Layer layer) {
        LayerView layerView = this.mLayerView;
        layerView.addLayer(layer);
        layerView.requestRender();
    }

    public void requestRender() {
        this.mLayerView.requestRender();
    }

    public void hidePlugins(Tab tab) {
        for (Layer layer : tab.getPluginLayers()) {
            if (layer instanceof PluginLayer) {
                ((PluginLayer)layer).setVisible(false);
            }
            this.hidePluginLayer(layer);
        }
        this.requestRender();
    }

    public void showPlugins() {
        Tabs tabs = Tabs.getInstance();
        Tab tab = tabs.getSelectedTab();
        this.showPlugins(tab);
    }

    public void showPlugins(Tab tab) {
        for (Layer layer : tab.getPluginLayers()) {
            this.showPluginLayer(layer);
            if (!(layer instanceof PluginLayer)) continue;
            ((PluginLayer)layer).setVisible(true);
        }
        this.requestRender();
    }

    @Override
    public void setFullScreen(final boolean bl) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Window window = GeckoApp.this.getWindow();
                window.setFlags(bl ? 1024 : 0, 1024);
                if (AppConstants.Versions.feature11Plus) {
                    window.getDecorView().setSystemUiVisibility(bl ? 1 : 0);
                }
            }
        });
    }

    protected void earlyStartJavaSampler(Intent intent) {
        String string2 = intent.getStringExtra("env0");
        int n = 1;
        while (string2 != null) {
            if (string2.startsWith("MOZ_PROFILER_STARTUP=")) {
                if (string2.endsWith("=")) break;
                GeckoJavaSampler.start(10, 1000);
                Log.d((String)LOGTAG, (String)"Profiling Java on startup");
                break;
            }
            string2 = intent.getStringExtra("env" + n);
            ++n;
        }
    }

    @Override
    public void onCreate(Bundle object) {
        String string2;
        String string3;
        GeckoAppShell.registerGlobalExceptionHandler();
        if ("default".equals("nightly-oak")) {
            this.enableStrictMode();
        }
        this.mJavaUiStartupTimer = new Telemetry.UptimeTimer("FENNEC_STARTUP_TIME_JAVAUI");
        this.mGeckoReadyStartupTimer = new Telemetry.UptimeTimer("FENNEC_STARTUP_TIME_GECKOREADY");
        Intent intent = this.getIntent();
        String string4 = intent.getAction();
        String string5 = intent.getStringExtra("args");
        this.earlyStartJavaSampler(intent);
        GeckoLoader.setLastIntent((Intent)intent);
        if (this.mProfile == null) {
            string3 = null;
            string2 = null;
            if (string5 != null) {
                Pattern pattern;
                Matcher matcher;
                if (string5.contains("-P") && (matcher = (pattern = Pattern.compile("(?:-P\\s*)(\\w*)(\\s*)")).matcher(string5)).find()) {
                    string3 = matcher.group(1);
                }
                if (string5.contains("-profile")) {
                    pattern = Pattern.compile("(?:-profile\\s*)(\\S*)(\\s*)");
                    matcher = pattern.matcher(string5);
                    if (matcher.find()) {
                        string2 = matcher.group(1);
                    }
                    if (string3 == null) {
                        string3 = "default";
                    }
                    GeckoProfile.sIsUsingCustomProfile = true;
                }
                if (string3 != null || string2 != null) {
                    this.mProfile = GeckoProfile.get((Context)this, string3, string2);
                }
            }
        }
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GeckoApp.this.getProfile();
            }
        });
        try {
            Class.forName("android.os.AsyncTask");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        MemoryMonitor.getInstance().init(this.getApplicationContext());
        GeckoAppShell.setContextGetter(this);
        GeckoAppShell.setGeckoInterface(this);
        Tabs.getInstance().attachToContext((Context)this);
        try {
            Favicons.initializeWithContext((Context)this);
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Exception starting favicon cache. Corrupt resources?", (Throwable)exception);
        }
        if (BrowserLocaleManager.getInstance().systemLocaleDidChange()) {
            Log.i((String)LOGTAG, (String)"System locale changed. Restarting.");
            this.doRestart();
            GeckoAppShell.systemExit();
            return;
        }
        if (GeckoThread.isCreated()) {
            this.mIsRestoringActivity = true;
            Telemetry.HistogramAdd("FENNEC_RESTORING_ACTIVITY", 1);
        } else {
            string3 = this.getURIFromIntent(intent);
            GeckoThread.setArgs(string5);
            GeckoThread.setAction(string4);
            GeckoThread.setUri(TextUtils.isEmpty((CharSequence)string3) ? null : string3);
        }
        if (!ACTION_DEBUG.equals(string4) && GeckoThread.checkAndSetLaunchState(GeckoThread.LaunchState.Launching, GeckoThread.LaunchState.Launched)) {
            GeckoThread.createAndStart();
        } else if (ACTION_DEBUG.equals(string4) && GeckoThread.checkAndSetLaunchState(GeckoThread.LaunchState.Launching, GeckoThread.LaunchState.WaitForDebugger)) {
            ThreadUtils.getUiHandler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    GeckoThread.setLaunchState(GeckoThread.LaunchState.Launched);
                    GeckoThread.createAndStart();
                }
            }, 5000L);
        }
        string3 = this.getIntent().getBundleExtra(EXTRA_STATE_BUNDLE);
        if (string3 != null) {
            string2 = this.getSharedPreferences();
            if (string2.getBoolean(PREFS_ALLOW_STATE_BUNDLE, false)) {
                string2.edit().remove(PREFS_ALLOW_STATE_BUNDLE).apply();
                object = string3;
            }
        } else if (object != null) {
            this.setIntent(new Intent("android.intent.action.MAIN"));
        }
        super.onCreate((Bundle)object);
        GeckoScreenOrientation.getInstance().update(this.getResources().getConfiguration().orientation);
        this.setContentView(this.getLayout());
        this.mGeckoLayout = (RelativeLayout)this.findViewById(R.id.gecko_layout);
        this.mMainLayout = (RelativeLayout)this.findViewById(R.id.main_layout);
        this.mShouldRestore = this.getSessionRestoreState((Bundle)object);
        if (this.mShouldRestore && object != null) {
            boolean bl = object.getBoolean(SAVED_STATE_IN_BACKGROUND, false);
            if (!bl && !this.mIsRestoringActivity) {
                Telemetry.HistogramAdd("FENNEC_WAS_KILLED", 1);
            }
            this.mPrivateBrowsingSession = object.getString(SAVED_STATE_PRIVATE_SESSION);
        }
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SharedPreferences sharedPreferences = GeckoApp.this.getSharedPreferences();
                LocaleManager localeManager = BrowserLocaleManager.getInstance();
                localeManager.initialize(GeckoApp.this.getApplicationContext());
                SessionInformation sessionInformation = SessionInformation.fromSharedPrefs(sharedPreferences);
                if (sessionInformation.wasKilled()) {
                    Telemetry.HistogramAdd("FENNEC_WAS_KILLED", 1);
                }
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.putBoolean(GeckoApp.PREFS_OOM_EXCEPTION, false);
                editor.putBoolean(GeckoApp.PREFS_WAS_STOPPED, false);
                editor.apply();
                String string2 = GeckoApp.this.getProfile().getDir().getAbsolutePath();
                EventDispatcher eventDispatcher = EventDispatcher.getInstance();
                String string3 = Locale.getDefault().toString();
                String string4 = localeManager.getAndApplyPersistedLocale((Context)GeckoApp.this);
                Log.d((String)GeckoApp.LOGTAG, (String)("OS locale is " + string3 + ", app locale is " + string4));
                if (string4 == null) {
                    string4 = string3;
                }
                GeckoApp.this.mHealthRecorder = GeckoApp.this.createHealthRecorder((Context)GeckoApp.this, string2, eventDispatcher, string3, string4, sessionInformation);
                final String string5 = string4;
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        GeckoApp.this.onLocaleReady(string5);
                    }
                });
            }
        });
        GeckoAppShell.setNotificationClient(this.makeNotificationClient());
        IntentHelper.init((Activity)this);
    }

    @Override
    public void onLocaleReady(String string2) {
        TextView textView;
        if (!ThreadUtils.isOnUiThread()) {
            throw new RuntimeException("onLocaleReady must always be called from the UI thread.");
        }
        Locale locale = BrowserLocaleManager.parseLocaleCode(string2);
        if (locale.equals(this.mLastLocale)) {
            Log.d((String)LOGTAG, (String)"New locale same as old; onLocaleReady has nothing to do.");
        }
        if ((textView = (TextView)this.findViewById(R.id.url_bar_title)) != null) {
            String string3 = this.getResources().getString(R.string.url_bar_default_text);
            textView.setHint((CharSequence)string3);
        } else {
            Log.d((String)LOGTAG, (String)"No URL bar in GeckoApp. Not loading localized hint string.");
        }
        this.mLastLocale = locale;
        super.onConfigurationChanged(this.getResources().getConfiguration());
    }

    protected void initializeChrome() {
        this.mDoorHangerPopup = new DoorHangerPopup((Context)this);
        this.mPluginContainer = (AbsoluteLayout)this.findViewById(R.id.plugin_container);
        this.mFormAssistPopup = (FormAssistPopup)this.findViewById(R.id.form_assist_popup);
        if (this.mCameraView == null && AppConstants.Versions.preICS) {
            this.mCameraView = new SurfaceView((Context)this);
            ((SurfaceView)this.mCameraView).getHolder().setType(3);
        }
        if (this.mLayerView == null) {
            LayerView layerView = (LayerView)this.findViewById(R.id.layer_view);
            layerView.initializeView(EventDispatcher.getInstance());
            this.mLayerView = layerView;
            GeckoAppShell.setLayerView(layerView);
            GeckoAppShell.sendEventToGecko(GeckoEvent.createObjectEvent(1, layerView.getLayerClientObject()));
            GeckoAppShell.notifyIMEContext(0, "", "", "");
        }
    }

    protected void loadStartupTab(String string2) {
        if (string2 == null) {
            if (!this.mShouldRestore) {
                Tabs.getInstance().loadUrl("about:home", 1);
            }
        } else {
            int n = 131;
            Tabs.getInstance().loadUrl(string2, n);
        }
    }

    private void initialize() {
        String string2;
        this.mInitialized = true;
        Intent intent = this.getIntent();
        String string3 = intent.getAction();
        String string4 = null;
        String string5 = this.getURIFromIntent(intent);
        if (!TextUtils.isEmpty((CharSequence)string5)) {
            string4 = string5;
        }
        boolean bl = string4 != null && !AboutPages.isAboutHome(string4);
        StartupAction startupAction = bl ? StartupAction.URL : StartupAction.NORMAL;
        this.checkMigrateProfile();
        Tabs.registerOnTabsChangedListener(this);
        this.initializeChrome();
        BrowserDB.initialize(this.getProfile().getName());
        if (!this.mIsRestoringActivity) {
            string2 = null;
            if (this.mShouldRestore) {
                try {
                    string2 = this.restoreSessionTabs(bl);
                }
                catch (SessionRestoreException sessionRestoreException) {
                    Log.e((String)LOGTAG, (String)"An error occurred during restore", (Throwable)sessionRestoreException);
                    this.mShouldRestore = false;
                }
            }
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Session:Restore", string2));
        }
        if (bl) {
            this.loadStartupTab(string4);
        } else if (!this.mIsRestoringActivity) {
            this.loadStartupTab(null);
        }
        Tabs.getInstance().notifyListeners(null, Tabs.TabEvents.RESTORED);
        if (!this.mShouldRestore) {
            this.getProfile().moveSessionFile();
        }
        Telemetry.HistogramAdd("FENNEC_STARTUP_GECKOAPP_ACTION", startupAction.ordinal());
        if (ACTION_LAUNCH_SETTINGS.equals(string3)) {
            string2 = new Intent((Context)this, GeckoPreferences.class);
            string2.putExtras(intent);
            this.startActivity((Intent)string2);
        }
        this.mAppStateListeners = new LinkedList<GeckoAppShell.AppStateListener>();
        EventDispatcher.getInstance().registerGeckoThreadListener(this, new String[]{"Gecko:Ready", "Gecko:DelayedStartup", "Accessibility:Event", "NativeApp:IsDebuggable"});
        EventDispatcher.getInstance().registerGeckoThreadListener(this, new String[]{"Accessibility:Ready", "Bookmark:Insert", "Contact:Add", "DOMFullScreen:Start", "DOMFullScreen:Stop", "Image:SetAs", "Locale:Set", "Permissions:Data", "PrivateBrowsing:Data", "Sanitize:ClearHistory", "Session:StatePurged", "Share:Text", "SystemUI:Visibility", "Toast:Show", "ToggleChrome:Focus", "ToggleChrome:Hide", "ToggleChrome:Show", "Update:Check", "Update:Download", "Update:Install"});
        if (this.mWebappEventListener == null) {
            this.mWebappEventListener = new EventListener();
            this.mWebappEventListener.registerEvents();
        }
        if (SmsManager.isEnabled()) {
            SmsManager.getInstance().start();
        }
        this.mContactService = new ContactService(EventDispatcher.getInstance(), this);
        this.mPromptService = new PromptService((Context)this);
        this.mTextSelection = new TextSelection((TextSelectionHandle)this.findViewById(R.id.start_handle), (TextSelectionHandle)this.findViewById(R.id.middle_handle), (TextSelectionHandle)this.findViewById(R.id.end_handle), EventDispatcher.getInstance(), this);
        PrefsHelper.getPref("app.update.autodownload", new PrefsHelper.PrefHandlerBase(){

            @Override
            public void prefValue(String string2, String string3) {
                UpdateServiceHelper.registerForUpdates((Context)GeckoApp.this, string3);
            }
        });
        this.mJavaUiStartupTimer.stop();
        final long l = this.mJavaUiStartupTimer.getElapsed();
        ThreadUtils.getBackgroundHandler().postDelayed(new Runnable(){

            @Override
            public void run() {
                HealthRecorder healthRecorder = GeckoApp.this.mHealthRecorder;
                if (healthRecorder != null) {
                    healthRecorder.recordJavaStartupTime(l);
                }
                GeckoPreferences.broadcastHealthReportUploadPref((Context)GeckoApp.this);
                if (!GeckoThread.checkLaunchState(GeckoThread.LaunchState.Launched)) {
                    return;
                }
            }
        }, 50L);
        if (this.mIsRestoringActivity) {
            GeckoThread.setLaunchState(GeckoThread.LaunchState.GeckoRunning);
            Tab tab = Tabs.getInstance().getSelectedTab();
            if (tab != null) {
                Tabs.getInstance().notifyListeners(tab, Tabs.TabEvents.SELECTED);
            }
            this.geckoConnected();
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Viewport:Flush", null));
        }
        if (ACTION_ALERT_CALLBACK.equals(string3)) {
            this.processAlertCallback(intent);
        } else if ("org.mozilla.fennec.helperBroadcastAction".equals(string3)) {
            NotificationHelper.getInstance(this.getApplicationContext()).handleNotificationIntent(intent);
        }
    }

    private String restoreSessionTabs(final boolean bl) throws SessionRestoreException {
        try {
            JSONArray jSONArray;
            String string2 = this.getProfile().readSessionFile(false);
            if (string2 == null) {
                throw new SessionRestoreException("Could not read from session file");
            }
            if (this.mShouldRestore) {
                jSONArray = new JSONArray();
                SessionParser sessionParser = new SessionParser(){

                    @Override
                    public void onTabRead(SessionParser.SessionTab sessionTab) {
                        JSONObject jSONObject = sessionTab.getTabObject();
                        int n = 1;
                        n |= bl || !sessionTab.isSelected() ? 16 : 0;
                        n |= jSONObject.optBoolean("desktopMode") ? 32 : 0;
                        Tab tab = Tabs.getInstance().loadUrl(sessionTab.getUrl(), n |= jSONObject.optBoolean("isPrivate") ? 4 : 0);
                        tab.updateTitle(sessionTab.getTitle());
                        try {
                            jSONObject.put("tabId", tab.getId());
                        }
                        catch (JSONException jSONException) {
                            Log.e((String)GeckoApp.LOGTAG, (String)"JSON error", (Throwable)jSONException);
                        }
                        jSONArray.put((Object)jSONObject);
                    }
                };
                if (this.mPrivateBrowsingSession == null) {
                    sessionParser.parse(string2);
                } else {
                    sessionParser.parse(string2, this.mPrivateBrowsingSession);
                }
                if (jSONArray.length() > 0) {
                    string2 = new JSONObject().put("windows", (Object)new JSONArray().put((Object)new JSONObject().put("tabs", (Object)jSONArray))).toString();
                } else {
                    throw new SessionRestoreException("No tabs could be read from session file");
                }
            }
            jSONArray = new JSONObject();
            jSONArray.put("sessionString", (Object)string2);
            return jSONArray.toString();
        }
        catch (JSONException jSONException) {
            throw new SessionRestoreException((Exception)((Object)jSONException));
        }
    }

    @Override
    public synchronized GeckoProfile getProfile() {
        if (this.mProfile == null) {
            this.mProfile = GeckoProfile.get((Context)this);
        }
        return this.mProfile;
    }

    protected boolean getSessionRestoreState(Bundle bundle) {
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        boolean bl = false;
        int n = this.getVersionCode();
        if (sharedPreferences.getInt(PREFS_VERSION_CODE, 0) != n) {
            sharedPreferences.edit().putInt(PREFS_VERSION_CODE, n).apply();
            bl = true;
        } else if (bundle != null || this.getSessionRestorePreference().equals("always") || this.getRestartFromIntent()) {
            bl = true;
        } else if (sharedPreferences.getBoolean(PREFS_CRASHED, false)) {
            sharedPreferences.edit().putBoolean(PREFS_CRASHED, false).apply();
            bl = true;
        }
        return bl;
    }

    private String getSessionRestorePreference() {
        return this.getSharedPreferences().getString("android.not_a_preference.restoreSession3", "quit");
    }

    private boolean getRestartFromIntent() {
        return this.getIntent().getBooleanExtra("didRestart", false);
    }

    private void enableStrictMode() {
        Log.d((String)LOGTAG, (String)"Enabling Android StrictMode");
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder().detectAll().penaltyLog().build());
        StrictMode.setVmPolicy((StrictMode.VmPolicy)new StrictMode.VmPolicy.Builder().detectAll().penaltyLog().build());
    }

    @Override
    public void enableCameraView() {
        this.mCameraOrientationEventListener = new OrientationEventListener((Context)this){

            public void onOrientationChanged(int n) {
                if (GeckoApp.this.mAppStateListeners != null) {
                    for (GeckoAppShell.AppStateListener appStateListener : GeckoApp.this.mAppStateListeners) {
                        appStateListener.onOrientationChanged();
                    }
                }
            }
        };
        this.mCameraOrientationEventListener.enable();
        if (this.mCameraView != null && this.mCameraView instanceof SurfaceView) {
            if (AppConstants.Versions.feature11Plus) {
                this.mCameraView.setAlpha(0.0f);
            }
            ViewGroup viewGroup = (ViewGroup)this.findViewById(R.id.camera_layout);
            viewGroup.addView(this.mCameraView, (ViewGroup.LayoutParams)new AbsoluteLayout.LayoutParams(8, 16, 0, 0));
        }
    }

    @Override
    public void disableCameraView() {
        if (this.mCameraOrientationEventListener != null) {
            this.mCameraOrientationEventListener.disable();
            this.mCameraOrientationEventListener = null;
        }
        if (this.mCameraView != null) {
            ViewGroup viewGroup = (ViewGroup)this.findViewById(R.id.camera_layout);
            viewGroup.removeView(this.mCameraView);
        }
    }

    @Override
    public String getDefaultUAString() {
        return HardwareUtils.isTablet() ? "Mozilla/5.0 (Android; Tablet; rv:35.0a1) Gecko/35.0a1 Firefox/35.0a1" : "Mozilla/5.0 (Android; Mobile; rv:35.0a1) Gecko/35.0a1 Firefox/35.0a1";
    }

    private void processAlertCallback(Intent intent) {
        String string2 = "";
        String string3 = "";
        Uri uri = intent.getData();
        if (uri != null) {
            string2 = uri.getQueryParameter("name");
            if (string2 == null) {
                string2 = "";
            }
            if ((string3 = uri.getQueryParameter("cookie")) == null) {
                string3 = "";
            }
        }
        this.handleNotification(ACTION_ALERT_CALLBACK, string2, string3);
    }

    protected void onNewIntent(Intent intent) {
        if (GeckoThread.checkLaunchState(GeckoThread.LaunchState.GeckoExiting)) {
            GeckoAppShell.systemExit();
            return;
        }
        if (!this.mInitialized) {
            this.setIntent(intent);
            return;
        }
        String string2 = intent.getAction();
        if (ACTION_LOAD.equals(string2)) {
            String string3 = intent.getDataString();
            Tabs.getInstance().loadUrl(string3);
        } else if ("android.intent.action.VIEW".equals(string2)) {
            String string4 = intent.getDataString();
            Tabs.getInstance().loadUrl(string4, 131);
        } else if (string2 != null && string2.startsWith(ACTION_WEBAPP_PREFIX)) {
            String string5 = this.getURIFromIntent(intent);
            GeckoAppShell.sendEventToGecko(GeckoEvent.createWebappLoadEvent(string5));
        } else if (ACTION_HOMESCREEN_SHORTCUT.equals(string2)) {
            String string6 = this.getURIFromIntent(intent);
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBookmarkLoadEvent(string6));
        } else if ("android.intent.action.SEARCH".equals(string2)) {
            String string7 = this.getURIFromIntent(intent);
            GeckoAppShell.sendEventToGecko(GeckoEvent.createURILoadEvent(string7));
        } else if (ACTION_ALERT_CALLBACK.equals(string2)) {
            this.processAlertCallback(intent);
        } else if ("org.mozilla.fennec.helperBroadcastAction".equals(string2)) {
            NotificationHelper.getInstance(this.getApplicationContext()).handleNotificationIntent(intent);
        } else if (ACTION_LAUNCH_SETTINGS.equals(string2)) {
            Intent intent2 = new Intent((Context)this, GeckoPreferences.class);
            intent2.putExtras(intent);
            this.startActivity(intent2);
        }
    }

    protected String getURIFromIntent(Intent intent) {
        String string2 = intent.getAction();
        if (ACTION_ALERT_CALLBACK.equals(string2) || "org.mozilla.fennec.helperBroadcastAction".equals(string2)) {
            return null;
        }
        String string3 = intent.getDataString();
        if (string3 != null) {
            return string3;
        }
        if ((string2 != null && string2.startsWith(ACTION_WEBAPP_PREFIX) || ACTION_HOMESCREEN_SHORTCUT.equals(string2)) && (string3 = intent.getStringExtra("args")) != null && string3.startsWith("--url=")) {
            string3.replace("--url=", "");
        }
        return string3;
    }

    protected int getOrientation() {
        return GeckoScreenOrientation.getInstance().getAndroidOrientation();
    }

    @Override
    public void onResume() {
        super.onResume();
        int n = this.getResources().getConfiguration().orientation;
        if (GeckoScreenOrientation.getInstance().update(n)) {
            this.refreshChrome();
        }
        if (!AppConstants.Versions.feature14Plus) {
            GeckoAccessibility.updateAccessibilitySettings((Context)this);
        }
        if (this.mAppStateListeners != null) {
            for (GeckoAppShell.AppStateListener appStateListener : this.mAppStateListeners) {
                appStateListener.onResume();
            }
        }
        final long l = System.currentTimeMillis();
        final long l2 = SystemClock.elapsedRealtime();
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SessionInformation sessionInformation = new SessionInformation(l, l2);
                SharedPreferences sharedPreferences = GeckoApp.this.getSharedPreferences();
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.putBoolean(GeckoApp.PREFS_WAS_STOPPED, false);
                sessionInformation.recordBegin(editor);
                editor.apply();
                HealthRecorder healthRecorder = GeckoApp.this.mHealthRecorder;
                if (healthRecorder != null) {
                    healthRecorder.setCurrentSession(sessionInformation);
                } else {
                    Log.w((String)GeckoApp.LOGTAG, (String)"Can't record session: rec is null.");
                }
            }
        });
    }

    public void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        if (!this.mInitialized && bl) {
            this.initialize();
            this.getWindow().setBackgroundDrawable(null);
        }
    }

    @Override
    public void onPause() {
        final HealthRecorder healthRecorder = this.mHealthRecorder;
        GeckoApp geckoApp = this;
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable((Context)geckoApp){
            final /* synthetic */ Context val$context;
            {
                this.val$context = context;
            }

            @Override
            public void run() {
                SharedPreferences sharedPreferences = GeckoApp.this.getSharedPreferences();
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.putBoolean(GeckoApp.PREFS_WAS_STOPPED, true);
                if (healthRecorder != null) {
                    healthRecorder.recordSessionEnd("P", editor);
                }
                if (sharedPreferences.getBoolean(GeckoApp.PREFS_CLEANUP_TEMP_FILES, true)) {
                    File file = GeckoLoader.getGREDir((Context)GeckoApp.this);
                    FileUtils.delTree((File)file, (FilenameFilter)new FileUtils.NameAndAgeFilter(null, 8.64E7), (boolean)false);
                    editor.putBoolean(GeckoApp.PREFS_CLEANUP_TEMP_FILES, false);
                }
                editor.apply();
                GeckoPreferences.broadcastHealthReportPrune(this.val$context);
            }
        });
        if (this.mAppStateListeners != null) {
            for (GeckoAppShell.AppStateListener appStateListener : this.mAppStateListeners) {
                appStateListener.onPause();
            }
        }
        super.onPause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRestart() {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            SharedPreferences.Editor editor = this.getSharedPreferences().edit();
            editor.putBoolean(PREFS_WAS_STOPPED, false);
            editor.apply();
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
        super.onRestart();
    }

    @Override
    public void onDestroy() {
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, new String[]{"Gecko:Ready", "Gecko:DelayedStartup", "Accessibility:Event", "NativeApp:IsDebuggable"});
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, new String[]{"Accessibility:Ready", "Bookmark:Insert", "Contact:Add", "DOMFullScreen:Start", "DOMFullScreen:Stop", "Image:SetAs", "Locale:Set", "Permissions:Data", "PrivateBrowsing:Data", "Sanitize:ClearHistory", "Session:StatePurged", "Share:Text", "SystemUI:Visibility", "Toast:Show", "ToggleChrome:Focus", "ToggleChrome:Hide", "ToggleChrome:Show", "Update:Check", "Update:Download", "Update:Install"});
        if (this.mWebappEventListener != null) {
            this.mWebappEventListener.unregisterEvents();
            this.mWebappEventListener = null;
        }
        GeckoApp.deleteTempFiles();
        if (this.mLayerView != null) {
            this.mLayerView.destroy();
        }
        if (this.mDoorHangerPopup != null) {
            this.mDoorHangerPopup.destroy();
        }
        if (this.mFormAssistPopup != null) {
            this.mFormAssistPopup.destroy();
        }
        if (this.mContactService != null) {
            this.mContactService.destroy();
        }
        if (this.mPromptService != null) {
            this.mPromptService.destroy();
        }
        if (this.mTextSelection != null) {
            this.mTextSelection.destroy();
        }
        NotificationHelper.destroy();
        IntentHelper.destroy();
        GeckoNetworkManager.destroy();
        if (SmsManager.isEnabled()) {
            SmsManager.getInstance().stop();
            if (this.isFinishing()) {
                SmsManager.getInstance().shutdown();
            }
        }
        final HealthRecorder healthRecorder = this.mHealthRecorder;
        this.mHealthRecorder = null;
        if (healthRecorder != null && healthRecorder.isEnabled()) {
            ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    healthRecorder.close();
                }
            });
        }
        Favicons.close();
        super.onDestroy();
        Tabs.unregisterOnTabsChangedListener(this);
    }

    public static File getTempDirectory() {
        File file = GeckoApplication.get().getExternalFilesDir("temp");
        return file;
    }

    public static void deleteTempFiles() {
        File file = GeckoApp.getTempDirectory();
        if (file == null) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            file2.delete();
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
        Log.d((String)LOGTAG, (String)("onConfigurationChanged: " + configuration.locale));
        LocaleManager localeManager = BrowserLocaleManager.getInstance();
        Locale locale = localeManager.onSystemConfigurationChanged((Context)this, this.getResources(), configuration, this.mLastLocale);
        if (locale != null) {
            this.onLocaleChanged(BrowserLocaleManager.getLanguageTag(locale));
        }
        if (GeckoScreenOrientation.getInstance().update(configuration.orientation)) {
            if (this.mFormAssistPopup != null) {
                this.mFormAssistPopup.hide();
            }
            this.refreshChrome();
        }
        super.onConfigurationChanged(configuration);
    }

    public String getContentProcessName() {
        return "lib/libplugin-container.so";
    }

    public void addEnvToIntent(Intent intent) {
        Map<String, String> map = System.getenv();
        Set<Map.Entry<String, String>> set = map.entrySet();
        Iterator<Map.Entry<String, String>> iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            intent.putExtra("env" + n, entry.getKey() + "=" + entry.getValue());
            ++n;
        }
    }

    @Override
    public void doRestart() {
        this.doRestart(RESTARTER_ACTION, null, null);
    }

    public void doRestart(String string2) {
        this.doRestart(RESTARTER_ACTION, string2, null);
    }

    public void doRestart(Intent intent) {
        this.doRestart(RESTARTER_ACTION, null, intent);
    }

    public void doRestart(String string2, String string3, Intent intent) {
        Log.d((String)LOGTAG, (String)("doRestart(\"" + string2 + "\")"));
        try {
            Intent intent2 = new Intent(string2);
            intent2.setClassName("org.mozilla.fennec", RESTARTER_CLASS);
            if (string3 != null) {
                intent2.putExtra("args", string3);
            }
            if (intent != null) {
                intent2.putExtra("android.intent.extra.INTENT", (Parcelable)intent);
            }
            intent2.putExtra("didRestart", true);
            Log.d((String)LOGTAG, (String)("Restart intent: " + intent2.toString()));
            GeckoAppShell.killAnyZombies();
            this.startActivity(intent2);
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Error effecting restart.", (Throwable)exception);
        }
        this.finish();
        GeckoAppShell.waitForAnotherGeckoProc();
    }

    public void handleNotification(String string2, String string3, String string4) {
        if (GeckoThread.checkLaunchState(GeckoThread.LaunchState.GeckoRunning)) {
            GeckoAppShell.handleNotification(string2, string3, string4);
        }
    }

    private void checkMigrateProfile() {
        File file = this.getProfile().getDir();
        if (file != null) {
            ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    Handler handler = new Handler();
                    handler.postDelayed((Runnable)new DeferredCleanupTask(), 15000L);
                }
            });
        }
    }

    @Override
    public PromptService getPromptService() {
        return this.mPromptService;
    }

    public void onBackPressed() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() > 0) {
            super.onBackPressed();
            return;
        }
        if (this.autoHideTabs()) {
            return;
        }
        if (this.mDoorHangerPopup != null && this.mDoorHangerPopup.isShowing()) {
            this.mDoorHangerPopup.dismiss();
            return;
        }
        if (this.mFullScreenPluginView != null) {
            GeckoAppShell.onFullScreenPluginHidden(this.mFullScreenPluginView);
            this.removeFullScreenPluginView(this.mFullScreenPluginView);
            return;
        }
        if (this.mLayerView != null && this.mLayerView.isFullScreen()) {
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("FullScreen:Exit", null));
            return;
        }
        Tabs tabs = Tabs.getInstance();
        Tab tab = tabs.getSelectedTab();
        if (tab == null) {
            this.moveTaskToBack(true);
            return;
        }
        if (tab.doBack()) {
            return;
        }
        if (tab.isExternal()) {
            this.moveTaskToBack(true);
            tabs.closeTab(tab);
            return;
        }
        int n = tab.getParentId();
        Tab tab2 = tabs.getTab(n);
        if (tab2 != null) {
            tabs.closeTab(tab, tab2);
            return;
        }
        this.moveTaskToBack(true);
    }

    protected void onActivityResult(int n, int n2, Intent intent) {
        if (!ActivityHandlerHelper.handleActivityResult(n, n2, intent)) {
            super.onActivityResult(n, n2, intent);
        }
    }

    @Override
    public AbsoluteLayout getPluginContainer() {
        return this.mPluginContainer;
    }

    public void onAccuracyChanged(Sensor sensor, int n) {
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        GeckoAppShell.sendEventToGecko(GeckoEvent.createSensorEvent(sensorEvent));
    }

    public void onLocationChanged(Location location) {
        GeckoAppShell.sendEventToGecko(GeckoEvent.createLocationEvent(location));
    }

    public void onProviderDisabled(String string2) {
    }

    public void onProviderEnabled(String string2) {
    }

    public void onStatusChanged(String string2, int n, Bundle bundle) {
    }

    @Override
    public void notifyWakeLockChanged(String string2, String string3) {
        PowerManager.WakeLock wakeLock = this.mWakeLocks.get(string2);
        if (string3.equals("locked-foreground") && wakeLock == null) {
            PowerManager powerManager = (PowerManager)this.getSystemService("power");
            wakeLock = powerManager.newWakeLock(10, string2);
            wakeLock.acquire();
            this.mWakeLocks.put(string2, wakeLock);
        } else if (!string3.equals("locked-foreground") && wakeLock != null) {
            wakeLock.release();
            this.mWakeLocks.remove(string2);
        }
    }

    @Override
    public void notifyCheckUpdateResult(String string2) {
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Update:CheckResult", string2));
    }

    protected void geckoConnected() {
        this.mLayerView.geckoConnected();
        this.mLayerView.setOverScrollMode(2);
    }

    public void setAccessibilityEnabled(boolean bl) {
    }

    protected NotificationClient makeNotificationClient() {
        return new AppNotificationClient(this.getApplicationContext());
    }

    private int getVersionCode() {
        int n = 0;
        try {
            n = this.getPackageManager().getPackageInfo((String)this.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.wtf((String)LOGTAG, (String)(this.getPackageName() + " not found"), (Throwable)nameNotFoundException);
        }
        return n;
    }

    protected boolean getIsDebuggable() {
        return false;
    }

    protected void onLocaleChanged(final String string2) {
        HealthRecorder healthRecorder = this.mHealthRecorder;
        if (healthRecorder != null) {
            healthRecorder.onAppLocaleChanged(string2);
            healthRecorder.onEnvironmentChanged(true, SESSION_END_LOCALE_CHANGED);
        }
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GeckoApp.this.onLocaleReady(string2);
            }
        });
    }

    protected void setLocale(String string2) {
        if (string2 == null) {
            return;
        }
        String string3 = BrowserLocaleManager.getInstance().setSelectedLocale((Context)this, string2);
        if (string3 == null) {
            return;
        }
        this.onLocaleChanged(string3);
    }

    private void setSystemUiVisible(final boolean bl) {
        if (AppConstants.Versions.preICS) {
            return;
        }
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (bl) {
                    GeckoApp.this.mMainLayout.setSystemUiVisibility(0);
                } else {
                    GeckoApp.this.mMainLayout.setSystemUiVisibility(1);
                }
            }
        });
    }

    protected HealthRecorder createHealthRecorder(Context context, String string2, EventDispatcher eventDispatcher, String string3, String string4, SessionInformation sessionInformation) {
        return new StubbedHealthRecorder();
    }

    private class FullScreenHolder
    extends FrameLayout {
        public FullScreenHolder(Context context) {
            super(context);
        }

        public void addView(View view, int n) {
            super.addView(view, n);
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    GeckoApp.this.mLayerView.hideSurface();
                }
            });
        }

        public boolean onKeyDown(int n, KeyEvent keyEvent) {
            if (keyEvent.isSystem()) {
                return super.onKeyDown(n, keyEvent);
            }
            GeckoApp.this.mFullScreenPluginView.onKeyDown(n, keyEvent);
            return true;
        }

        public boolean onKeyUp(int n, KeyEvent keyEvent) {
            if (keyEvent.isSystem()) {
                return super.onKeyUp(n, keyEvent);
            }
            GeckoApp.this.mFullScreenPluginView.onKeyUp(n, keyEvent);
            return true;
        }

        public boolean onTouchEvent(MotionEvent motionEvent) {
            return true;
        }

        public boolean onTrackballEvent(MotionEvent motionEvent) {
            GeckoApp.this.mFullScreenPluginView.onTrackballEvent(motionEvent);
            return true;
        }
    }

    public static class MainLayout
    extends RelativeLayout {
        private TouchEventInterceptor mTouchEventInterceptor;
        private MotionEventInterceptor mMotionEventInterceptor;

        public MainLayout(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public void setTouchEventInterceptor(TouchEventInterceptor touchEventInterceptor) {
            this.mTouchEventInterceptor = touchEventInterceptor;
        }

        public void setMotionEventInterceptor(MotionEventInterceptor motionEventInterceptor) {
            this.mMotionEventInterceptor = motionEventInterceptor;
        }

        public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
            if (this.mTouchEventInterceptor != null && this.mTouchEventInterceptor.onInterceptTouchEvent((View)this, motionEvent)) {
                return true;
            }
            return super.onInterceptTouchEvent(motionEvent);
        }

        public boolean onTouchEvent(MotionEvent motionEvent) {
            if (this.mTouchEventInterceptor != null && this.mTouchEventInterceptor.onTouch((View)this, motionEvent)) {
                return true;
            }
            return super.onTouchEvent(motionEvent);
        }

        public boolean onGenericMotionEvent(MotionEvent motionEvent) {
            if (this.mMotionEventInterceptor != null && this.mMotionEventInterceptor.onInterceptMotionEvent((View)this, motionEvent)) {
                return true;
            }
            return super.onGenericMotionEvent(motionEvent);
        }

        public void setDrawingCacheEnabled(boolean bl) {
            super.setChildrenDrawnWithCacheEnabled(bl);
        }
    }

    private class DeferredCleanupTask
    implements Runnable {
        private static final String CLEANUP_VERSION = "cleanup-version";
        private static final int CURRENT_CLEANUP_VERSION = 1;

        private DeferredCleanupTask() {
        }

        @Override
        public void run() {
            File file;
            long l = GeckoApp.this.getSharedPreferences().getInt(CLEANUP_VERSION, 0);
            if (l < 1L && (file = new File("res/fonts")).exists() && file.isDirectory()) {
                for (File file2 : file.listFiles()) {
                    if (!file2.isFile() || !file2.getName().endsWith(".ttf")) continue;
                    file2.delete();
                }
                if (!file.delete()) {
                    Log.w((String)GeckoApp.LOGTAG, (String)"unable to delete res/fonts directory (not empty?)");
                }
            }
            if (l != 1L) {
                file = GeckoApp.this.getSharedPreferences().edit();
                file.putInt(CLEANUP_VERSION, 1);
                file.apply();
            }
        }
    }

    class SessionRestoreException
    extends Exception {
        public SessionRestoreException(Exception exception) {
            super(exception);
        }

        public SessionRestoreException(String string2) {
            super(string2);
        }
    }

    private static enum StartupAction {
        NORMAL,
        URL,
        PREFETCH;

    }
}

