/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoThread;

public class GeckoConnectivityReceiver
extends BroadcastReceiver {
    private static final String LINK_DATA_UP = "up";
    private static final String LINK_DATA_DOWN = "down";
    private static final String LINK_DATA_CHANGED = "changed";
    private static final String LINK_DATA_UNKNOWN = "unknown";
    private static final String LOGTAG = "GeckoConnectivityReceiver";
    private static GeckoConnectivityReceiver sInstance = new GeckoConnectivityReceiver();
    private final IntentFilter mFilter = new IntentFilter();
    private Context mApplicationContext;
    private boolean mIsEnabled;

    public static GeckoConnectivityReceiver getInstance() {
        return sInstance;
    }

    private GeckoConnectivityReceiver() {
        this.mFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
    }

    public synchronized void start(Context context) {
        if (this.mIsEnabled) {
            Log.w((String)LOGTAG, (String)"Already started!");
            return;
        }
        this.mApplicationContext = context.getApplicationContext();
        if (this.mApplicationContext.registerReceiver((BroadcastReceiver)this, this.mFilter) == null) {
            Log.e((String)LOGTAG, (String)"Registering receiver failed");
        } else {
            this.mIsEnabled = true;
        }
    }

    public synchronized void stop() {
        if (!this.mIsEnabled) {
            Log.w((String)LOGTAG, (String)"Already stopped!");
            return;
        }
        this.mApplicationContext.unregisterReceiver((BroadcastReceiver)this);
        this.mApplicationContext = null;
        this.mIsEnabled = false;
    }

    public void onReceive(Context context, Intent intent) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        String string2 = networkInfo == null ? LINK_DATA_UNKNOWN : (!networkInfo.isConnected() ? LINK_DATA_DOWN : LINK_DATA_UP);
        if (GeckoThread.checkLaunchState(GeckoThread.LaunchState.GeckoRunning)) {
            GeckoAppShell.sendEventToGecko(GeckoEvent.createNetworkLinkChangeEvent(string2));
            GeckoAppShell.sendEventToGecko(GeckoEvent.createNetworkLinkChangeEvent(LINK_DATA_CHANGED));
        }
    }
}

