/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.content.ContentProviderOperation;
import android.content.ContentResolver;
import android.content.Context;
import android.content.OperationApplicationException;
import android.database.Cursor;
import android.os.RemoteException;
import android.provider.Browser;
import android.util.Log;
import java.util.ArrayList;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.db.LocalBrowserDB;

class AndroidImport
implements Runnable {
    private static final String LOGTAG = "AndroidImport";
    private Context mContext;
    private Runnable mOnDoneRunnable;
    private ArrayList<ContentProviderOperation> mOperations;
    private ContentResolver mCr;
    private LocalBrowserDB mDB;
    private boolean mImportBookmarks;
    private boolean mImportHistory;

    public AndroidImport(Context context, Runnable runnable, boolean bl, boolean bl2) {
        this.mContext = context;
        this.mOnDoneRunnable = runnable;
        this.mOperations = new ArrayList();
        this.mCr = this.mContext.getContentResolver();
        this.mDB = new LocalBrowserDB(GeckoProfile.get(context).getName());
        this.mImportBookmarks = bl;
        this.mImportHistory = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeBookmarks() {
        try (Cursor cursor = null;){
            cursor = this.mCr.query(Browser.BOOKMARKS_URI, null, "bookmark = 1", null, null);
            if (cursor != null) {
                int n = cursor.getColumnIndexOrThrow("favicon");
                int n2 = cursor.getColumnIndexOrThrow("title");
                int n3 = cursor.getColumnIndexOrThrow("url");
                int n4 = cursor.getColumnIndex("created");
                cursor.moveToFirst();
                while (!cursor.isAfterLast()) {
                    String string2 = cursor.getString(n3);
                    String string3 = cursor.getString(n2);
                    long l = n4 >= 0 ? cursor.getLong(n4) : System.currentTimeMillis();
                    long l2 = System.currentTimeMillis();
                    byte[] byArray = cursor.getBlob(n);
                    this.mDB.updateBookmarkInBatch(this.mCr, this.mOperations, string2, string3, null, -1L, l, l2, Long.MIN_VALUE, null, 1);
                    if (byArray != null) {
                        this.mDB.updateFaviconInBatch(this.mCr, this.mOperations, string2, null, null, byArray);
                    }
                    cursor.moveToNext();
                }
            }
        }
        this.flushBatchOperations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeHistory() {
        try (Cursor cursor = null;){
            cursor = this.mCr.query(Browser.BOOKMARKS_URI, null, "bookmark = 0 AND visits > 0", null, null);
            if (cursor != null) {
                int n = cursor.getColumnIndexOrThrow("date");
                int n2 = cursor.getColumnIndexOrThrow("favicon");
                int n3 = cursor.getColumnIndexOrThrow("title");
                int n4 = cursor.getColumnIndexOrThrow("url");
                int n5 = cursor.getColumnIndexOrThrow("visits");
                cursor.moveToFirst();
                while (!cursor.isAfterLast()) {
                    String string2 = cursor.getString(n4);
                    String string3 = cursor.getString(n3);
                    long l = cursor.getLong(n);
                    int n6 = cursor.getInt(n5);
                    byte[] byArray = cursor.getBlob(n2);
                    this.mDB.updateHistoryInBatch(this.mCr, this.mOperations, string2, string3, l, n6);
                    if (byArray != null) {
                        this.mDB.updateFaviconInBatch(this.mCr, this.mOperations, string2, null, null, byArray);
                    }
                    cursor.moveToNext();
                }
            }
        }
        this.flushBatchOperations();
    }

    protected void flushBatchOperations() {
        Log.d((String)LOGTAG, (String)("Flushing " + this.mOperations.size() + " DB operations"));
        try {
            this.mCr.applyBatch("org.mozilla.fennec.db.browser", this.mOperations);
        }
        catch (RemoteException remoteException) {
            Log.e((String)LOGTAG, (String)"Remote exception while updating db: ", (Throwable)remoteException);
        }
        catch (OperationApplicationException operationApplicationException) {
            Log.d((String)LOGTAG, (String)"Error while applying database updates: ", (Throwable)operationApplicationException);
        }
        this.mOperations.clear();
    }

    @Override
    public void run() {
        if (this.mImportBookmarks) {
            this.mergeBookmarks();
        }
        if (this.mImportHistory) {
            this.mergeHistory();
        }
        this.mOnDoneRunnable.run();
    }
}

