/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabs;

import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.widget.TabThumbnailWrapper;

public class TabsLayoutItemView {
    int id;
    TextView title;
    ImageView thumbnail;
    ImageButton close;
    ViewGroup info;
    TabThumbnailWrapper thumbnailWrapper;

    public TabsLayoutItemView(View view) {
        this.info = (ViewGroup)view;
        this.title = (TextView)view.findViewById(R.id.title);
        this.thumbnail = (ImageView)view.findViewById(R.id.thumbnail);
        this.close = (ImageButton)view.findViewById(R.id.close);
        this.thumbnailWrapper = (TabThumbnailWrapper)view.findViewById(R.id.wrapper);
    }

    protected void assignValues(Tab tab) {
        if (tab == null) {
            return;
        }
        this.id = tab.getId();
        BitmapDrawable bitmapDrawable = tab.getThumbnail();
        if (bitmapDrawable != null) {
            this.thumbnail.setImageDrawable((Drawable)bitmapDrawable);
        } else {
            this.thumbnail.setImageResource(R.drawable.tab_thumbnail_default);
        }
        if (this.thumbnailWrapper != null) {
            this.thumbnailWrapper.setRecording(tab.isRecording());
        }
        this.title.setText((CharSequence)tab.getDisplayTitle());
        this.close.setTag((Object)this);
    }
}

