/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.client.cache;

import ch.boye.httpclientandroidlib.client.cache.HttpCacheInvalidator;
import ch.boye.httpclientandroidlib.client.cache.HttpCacheStorage;
import ch.boye.httpclientandroidlib.client.cache.ResourceFactory;
import ch.boye.httpclientandroidlib.impl.client.HttpClientBuilder;
import ch.boye.httpclientandroidlib.impl.client.cache.AsynchronousValidator;
import ch.boye.httpclientandroidlib.impl.client.cache.BasicHttpCache;
import ch.boye.httpclientandroidlib.impl.client.cache.BasicHttpCacheStorage;
import ch.boye.httpclientandroidlib.impl.client.cache.CacheConfig;
import ch.boye.httpclientandroidlib.impl.client.cache.CacheInvalidator;
import ch.boye.httpclientandroidlib.impl.client.cache.CacheKeyGenerator;
import ch.boye.httpclientandroidlib.impl.client.cache.CachingExec;
import ch.boye.httpclientandroidlib.impl.client.cache.FileResourceFactory;
import ch.boye.httpclientandroidlib.impl.client.cache.HeapResourceFactory;
import ch.boye.httpclientandroidlib.impl.client.cache.ImmediateSchedulingStrategy;
import ch.boye.httpclientandroidlib.impl.client.cache.ManagedHttpCacheStorage;
import ch.boye.httpclientandroidlib.impl.client.cache.SchedulingStrategy;
import ch.boye.httpclientandroidlib.impl.execchain.ClientExecChain;
import java.io.Closeable;
import java.io.File;

public class CachingHttpClientBuilder
extends HttpClientBuilder {
    private ResourceFactory resourceFactory;
    private HttpCacheStorage storage;
    private File cacheDir;
    private CacheConfig cacheConfig;
    private SchedulingStrategy schedulingStrategy;
    private HttpCacheInvalidator httpCacheInvalidator;

    public static CachingHttpClientBuilder create() {
        return new CachingHttpClientBuilder();
    }

    protected CachingHttpClientBuilder() {
    }

    public final CachingHttpClientBuilder setResourceFactory(ResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
        return this;
    }

    public final CachingHttpClientBuilder setHttpCacheStorage(HttpCacheStorage httpCacheStorage) {
        this.storage = httpCacheStorage;
        return this;
    }

    public final CachingHttpClientBuilder setCacheDir(File file) {
        this.cacheDir = file;
        return this;
    }

    public final CachingHttpClientBuilder setCacheConfig(CacheConfig cacheConfig) {
        this.cacheConfig = cacheConfig;
        return this;
    }

    public final CachingHttpClientBuilder setSchedulingStrategy(SchedulingStrategy schedulingStrategy) {
        this.schedulingStrategy = schedulingStrategy;
        return this;
    }

    public final CachingHttpClientBuilder setHttpCacheInvalidator(HttpCacheInvalidator httpCacheInvalidator) {
        this.httpCacheInvalidator = httpCacheInvalidator;
        return this;
    }

    @Override
    protected ClientExecChain decorateMainExec(ClientExecChain clientExecChain) {
        Closeable closeable;
        Object object;
        CacheConfig cacheConfig = this.cacheConfig != null ? this.cacheConfig : CacheConfig.DEFAULT;
        ResourceFactory resourceFactory = this.resourceFactory;
        if (resourceFactory == null) {
            resourceFactory = this.cacheDir == null ? new HeapResourceFactory() : new FileResourceFactory(this.cacheDir);
        }
        if ((object = this.storage) == null) {
            if (this.cacheDir == null) {
                object = new BasicHttpCacheStorage(cacheConfig);
            } else {
                closeable = new ManagedHttpCacheStorage(cacheConfig);
                this.addCloseable(closeable);
                object = closeable;
            }
        }
        closeable = this.createAsynchronousRevalidator(cacheConfig);
        CacheKeyGenerator cacheKeyGenerator = new CacheKeyGenerator();
        HttpCacheInvalidator httpCacheInvalidator = this.httpCacheInvalidator;
        if (httpCacheInvalidator == null) {
            httpCacheInvalidator = new CacheInvalidator(cacheKeyGenerator, (HttpCacheStorage)object);
        }
        return new CachingExec(clientExecChain, new BasicHttpCache(resourceFactory, (HttpCacheStorage)object, cacheConfig, cacheKeyGenerator, httpCacheInvalidator), cacheConfig, (AsynchronousValidator)closeable);
    }

    private AsynchronousValidator createAsynchronousRevalidator(CacheConfig cacheConfig) {
        if (cacheConfig.getAsynchronousWorkersMax() > 0) {
            SchedulingStrategy schedulingStrategy = this.createSchedulingStrategy(cacheConfig);
            AsynchronousValidator asynchronousValidator = new AsynchronousValidator(schedulingStrategy);
            this.addCloseable(asynchronousValidator);
            return asynchronousValidator;
        }
        return null;
    }

    private SchedulingStrategy createSchedulingStrategy(CacheConfig cacheConfig) {
        return this.schedulingStrategy != null ? this.schedulingStrategy : new ImmediateSchedulingStrategy(cacheConfig);
    }
}

