/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import org.mozilla.gecko.AppConstants;

public abstract class AbstractTransactionalProvider
extends ContentProvider {
    private static final String LOGTAG = "GeckoTransProvider";
    private static boolean logDebug = Log.isLoggable((String)"GeckoTransProvider", (int)3);
    private static boolean logVerbose = Log.isLoggable((String)"GeckoTransProvider", (int)2);
    final ThreadLocal<Boolean> isInBatchOperation = new ThreadLocal();

    protected abstract SQLiteDatabase getReadableDatabase(Uri var1);

    protected abstract SQLiteDatabase getWritableDatabase(Uri var1);

    public abstract SQLiteDatabase getWritableDatabaseForTesting(Uri var1);

    protected abstract Uri insertInTransaction(Uri var1, ContentValues var2);

    protected abstract int deleteInTransaction(Uri var1, String var2, String[] var3);

    protected abstract int updateInTransaction(Uri var1, ContentValues var2, String var3, String[] var4);

    protected boolean shouldUseTransactions() {
        return AppConstants.Versions.feature11Plus;
    }

    private boolean isInBatch() {
        Boolean bl = this.isInBatchOperation.get();
        if (bl == null) {
            return false;
        }
        return bl;
    }

    protected void beginWrite(SQLiteDatabase sQLiteDatabase) {
        if (this.isInBatch()) {
            AbstractTransactionalProvider.trace("Not bothering with an intermediate write transaction: inside batch operation.");
            return;
        }
        if (this.shouldUseTransactions() && !sQLiteDatabase.inTransaction()) {
            AbstractTransactionalProvider.trace("beginWrite: beginning transaction.");
            sQLiteDatabase.beginTransaction();
        }
    }

    protected void markWriteSuccessful(SQLiteDatabase sQLiteDatabase) {
        if (this.isInBatch()) {
            AbstractTransactionalProvider.trace("Not marking write successful: inside batch operation.");
            return;
        }
        if (this.shouldUseTransactions() && sQLiteDatabase.inTransaction()) {
            AbstractTransactionalProvider.trace("Marking write transaction successful.");
            sQLiteDatabase.setTransactionSuccessful();
        }
    }

    protected void endWrite(SQLiteDatabase sQLiteDatabase) {
        if (this.isInBatch()) {
            AbstractTransactionalProvider.trace("Not ending write: inside batch operation.");
            return;
        }
        if (this.shouldUseTransactions() && sQLiteDatabase.inTransaction()) {
            AbstractTransactionalProvider.trace("endWrite: ending transaction.");
            sQLiteDatabase.endTransaction();
        }
    }

    protected void beginBatch(SQLiteDatabase sQLiteDatabase) {
        AbstractTransactionalProvider.trace("Beginning batch.");
        this.isInBatchOperation.set(Boolean.TRUE);
        sQLiteDatabase.beginTransaction();
    }

    protected void markBatchSuccessful(SQLiteDatabase sQLiteDatabase) {
        if (this.isInBatch()) {
            AbstractTransactionalProvider.trace("Marking batch successful.");
            sQLiteDatabase.setTransactionSuccessful();
            return;
        }
        Log.w((String)LOGTAG, (String)"Unexpectedly asked to mark batch successful, but not in batch!");
        throw new IllegalStateException("Not in batch.");
    }

    protected void endBatch(SQLiteDatabase sQLiteDatabase) {
        AbstractTransactionalProvider.trace("Ending batch.");
        sQLiteDatabase.endTransaction();
        this.isInBatchOperation.set(Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(Uri uri, String string2, String[] stringArray) {
        AbstractTransactionalProvider.trace("Calling delete on URI: " + uri + ", " + string2 + ", " + stringArray);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        int n = 0;
        try {
            n = this.deleteInTransaction(uri, string2, stringArray);
            this.markWriteSuccessful(sQLiteDatabase);
        }
        finally {
            this.endWrite(sQLiteDatabase);
        }
        if (n > 0) {
            boolean bl = !AbstractTransactionalProvider.isCallerSync(uri);
            this.getContext().getContentResolver().notifyChange(uri, null, bl);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Uri insert(Uri uri, ContentValues contentValues) {
        AbstractTransactionalProvider.trace("Calling insert on URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        Uri uri2 = null;
        try {
            uri2 = this.insertInTransaction(uri, contentValues);
            this.markWriteSuccessful(sQLiteDatabase);
        }
        catch (SQLException sQLException) {
            Log.e((String)LOGTAG, (String)"exception in DB operation", (Throwable)sQLException);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Log.e((String)LOGTAG, (String)"don't know how to perform that insert", (Throwable)unsupportedOperationException);
        }
        finally {
            this.endWrite(sQLiteDatabase);
        }
        if (uri2 != null) {
            boolean bl = !AbstractTransactionalProvider.isCallerSync(uri);
            this.getContext().getContentResolver().notifyChange(uri, null, bl);
        }
        return uri2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        AbstractTransactionalProvider.trace("Calling update on URI: " + uri + ", " + string2 + ", " + stringArray);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        int n = 0;
        try {
            n = this.updateInTransaction(uri, contentValues, string2, stringArray);
            this.markWriteSuccessful(sQLiteDatabase);
        }
        finally {
            this.endWrite(sQLiteDatabase);
        }
        if (n > 0) {
            boolean bl = !AbstractTransactionalProvider.isCallerSync(uri);
            this.getContext().getContentResolver().notifyChange(uri, null, bl);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int bulkInsert(Uri uri, ContentValues[] contentValuesArray) {
        int n;
        if (contentValuesArray == null) {
            return 0;
        }
        int n2 = contentValuesArray.length;
        int n3 = 0;
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        AbstractTransactionalProvider.debug("bulkInsert: explicitly starting transaction.");
        this.beginBatch(sQLiteDatabase);
        try {
            for (n = 0; n < n2; n += 1) {
                this.insertInTransaction(uri, contentValuesArray[n]);
                ++n3;
            }
            AbstractTransactionalProvider.trace("Flushing DB bulkinsert...");
            this.markBatchSuccessful(sQLiteDatabase);
        }
        finally {
            AbstractTransactionalProvider.debug("bulkInsert: explicitly ending transaction.");
            this.endBatch(sQLiteDatabase);
        }
        if (n3 > 0) {
            n = !AbstractTransactionalProvider.isCallerSync(uri) ? 1 : 0;
            this.getContext().getContentResolver().notifyChange(uri, null, n != 0);
        }
        return n3;
    }

    protected static boolean shouldShowDeleted(Uri uri) {
        String string2 = uri.getQueryParameter("show_deleted");
        return !TextUtils.isEmpty((CharSequence)string2);
    }

    protected static boolean shouldUpdateOrInsert(Uri uri) {
        String string2 = uri.getQueryParameter("insert_if_needed");
        return Boolean.parseBoolean(string2);
    }

    protected static boolean isTest(Uri uri) {
        if (uri == null) {
            return false;
        }
        String string2 = uri.getQueryParameter("test");
        return !TextUtils.isEmpty((CharSequence)string2);
    }

    protected static boolean isCallerSync(Uri uri) {
        String string2 = uri.getQueryParameter("sync");
        return !TextUtils.isEmpty((CharSequence)string2);
    }

    protected static void trace(String string2) {
        if (logVerbose) {
            Log.v((String)LOGTAG, (String)string2);
        }
    }

    protected static void debug(String string2) {
        if (logDebug) {
            Log.d((String)LOGTAG, (String)string2);
        }
    }
}

