/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentResolver;
import android.database.CharArrayBuffer;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.net.Uri;
import android.os.Bundle;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import java.util.HashMap;
import java.util.Map;

public class TopSitesCursorWrapper
implements Cursor {
    private static final String[] columnNames = new String[]{"_id", "url", "title", "bookmark_id", "history_id", "type", "imageurl", "bgcolor", "tracking_id"};
    private static final Map<String, Integer> columnIndexes = new HashMap<String, Integer>(columnNames.length);
    private static final int INDEX_TRACKING_ID;
    private static final int INDEX_IMAGEURL;
    private static final int INDEX_BGCOLOR;
    private SparseIntArray topIndexes;
    private SparseIntArray pinnedIndexes;
    private SparseIntArray suggestedIndexes;
    private RowType currentRowType = RowType.UNKNOWN;
    private Cursor currentCursor;
    private final Cursor topCursor;
    private final Cursor pinnedCursor;
    private final Cursor suggestedCursor;
    private SparseBooleanArray pinnedPositions;
    private int currentPosition = -1;
    private int pinnedBefore;
    private int count;
    private final int minSize;

    public TopSitesCursorWrapper(Cursor cursor, Cursor cursor2, int n) {
        this(cursor, cursor2, null, n);
    }

    public TopSitesCursorWrapper(Cursor cursor, Cursor cursor2, Cursor cursor3, int n) {
        this.minSize = n;
        this.topCursor = cursor2;
        this.pinnedCursor = cursor;
        this.suggestedCursor = cursor3;
        this.updateIndexMaps();
        this.updatePinnedPositions();
        this.updateCount();
    }

    private void updateIndexMaps() {
        this.topIndexes = new SparseIntArray(this.topCursor.getColumnCount());
        TopSitesCursorWrapper.updateIndexMapFromCursor(this.topIndexes, this.topCursor);
        this.pinnedIndexes = new SparseIntArray(this.pinnedCursor.getColumnCount());
        TopSitesCursorWrapper.updateIndexMapFromCursor(this.pinnedIndexes, this.pinnedCursor);
        if (this.suggestedCursor != null) {
            this.suggestedIndexes = new SparseIntArray(this.suggestedCursor.getColumnCount());
            TopSitesCursorWrapper.updateIndexMapFromCursor(this.suggestedIndexes, this.suggestedCursor);
        }
    }

    private static void updateIndexMapFromCursor(SparseIntArray sparseIntArray, Cursor cursor) {
        int n = cursor.getColumnCount();
        for (int i = 0; i < n; ++i) {
            Integer n2 = columnIndexes.get(cursor.getColumnName(i));
            if (n2 == null) continue;
            sparseIntArray.put(n2.intValue(), i);
        }
    }

    private void updatePinnedPositions() {
        if (this.pinnedPositions == null) {
            this.pinnedPositions = new SparseBooleanArray();
        } else {
            this.pinnedPositions.clear();
        }
        this.pinnedCursor.moveToPosition(-1);
        while (this.pinnedCursor.moveToNext()) {
            int n = this.pinnedCursor.getInt(this.pinnedCursor.getColumnIndex("position"));
            this.pinnedPositions.put(n, true);
        }
    }

    private void updateCount() {
        int n = this.pinnedCursor.getCount() + this.topCursor.getCount();
        if (this.suggestedCursor != null) {
            n += this.suggestedCursor.getCount();
        }
        this.count = Math.max(this.minSize, n);
    }

    private static boolean cursorHasValidPosition(Cursor cursor) {
        return cursor != null && !cursor.isBeforeFirst() && !cursor.isAfterLast();
    }

    private void updatePinnedBefore(int n) {
        this.pinnedBefore = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.pinnedPositions.get(i)) continue;
            ++this.pinnedBefore;
        }
    }

    private void setCurrentCursor(Cursor cursor, int n, RowType rowType) {
        cursor.moveToPosition(n);
        this.currentRowType = rowType;
        this.currentCursor = cursor;
    }

    private boolean updateTopCursorPosition(int n) {
        int n2 = n - this.pinnedBefore;
        if (n2 >= 0 && n2 < this.topCursor.getCount()) {
            this.setCurrentCursor(this.topCursor, n2, RowType.TOP);
            return true;
        }
        return false;
    }

    private boolean updatePinnedCursorPosition(int n) {
        if (n >= this.minSize) {
            return false;
        }
        if (this.pinnedPositions.get(n)) {
            this.setCurrentCursor(this.pinnedCursor, this.pinnedPositions.indexOfKey(n), RowType.PINNED);
            return true;
        }
        return false;
    }

    private boolean updateSuggestedCursorPosition(int n) {
        if (this.suggestedCursor == null) {
            return false;
        }
        if (n >= this.minSize) {
            return false;
        }
        int n2 = n - this.pinnedBefore - this.topCursor.getCount();
        if (n2 >= 0 && n2 < this.suggestedCursor.getCount()) {
            this.setCurrentCursor(this.suggestedCursor, n2, RowType.SUGGESTED);
            return true;
        }
        return false;
    }

    private void assertValidColumnIndex(int n) {
        if (n < 0 || n > columnNames.length - 1) {
            throw new IllegalArgumentException("Column index is out of bounds: " + n);
        }
    }

    private void assertValidRowType() {
        if (this.currentRowType == RowType.UNKNOWN) {
            throw new IllegalStateException("No provided cursor holds data at this position");
        }
    }

    private int getColumnIndexForCurrentRowType(int n) {
        this.assertValidRowType();
        this.assertValidColumnIndex(n);
        SparseIntArray sparseIntArray = null;
        switch (this.currentRowType) {
            case TOP: {
                sparseIntArray = this.topIndexes;
                break;
            }
            case PINNED: {
                sparseIntArray = this.pinnedIndexes;
                break;
            }
            case SUGGESTED: {
                sparseIntArray = this.suggestedIndexes;
            }
        }
        if (sparseIntArray != null) {
            if (this.currentRowType != RowType.SUGGESTED && this.isSuggestedSiteColumn(n)) {
                return -1;
            }
            return sparseIntArray.get(n, -1);
        }
        return -1;
    }

    private boolean isSuggestedSiteColumn(int n) {
        return n == INDEX_IMAGEURL || n == INDEX_BGCOLOR || n == INDEX_TRACKING_ID;
    }

    public int getPosition() {
        return this.currentPosition;
    }

    public int getCount() {
        return this.count;
    }

    public boolean isAfterLast() {
        return this.currentPosition >= this.count;
    }

    public boolean isBeforeFirst() {
        return this.currentPosition < 0;
    }

    public boolean isFirst() {
        return this.currentPosition == 0;
    }

    public boolean isLast() {
        return this.currentPosition == this.count - 1;
    }

    public boolean moveToNext() {
        return this.moveToPosition(this.currentPosition + 1);
    }

    public boolean moveToPrevious() {
        return this.moveToPosition(this.currentPosition - 1);
    }

    public boolean moveToFirst() {
        return this.moveToPosition(0);
    }

    public boolean moveToLast() {
        return this.moveToPosition(this.count - 1);
    }

    public boolean move(int n) {
        return this.moveToPosition(this.currentPosition + n);
    }

    public boolean moveToPosition(int n) {
        this.currentPosition = n;
        this.updatePinnedBefore(n);
        if (!(this.updatePinnedCursorPosition(n) || this.updateTopCursorPosition(n) || this.updateSuggestedCursorPosition(n))) {
            this.currentRowType = n >= 0 && n < this.minSize ? RowType.BLANK : RowType.UNKNOWN;
            this.currentCursor = null;
        }
        return TopSitesCursorWrapper.cursorHasValidPosition(this);
    }

    public long getLong(int n) {
        int n2 = this.getColumnIndexForCurrentRowType(n);
        if (n2 >= 0) {
            return this.currentCursor.getLong(n2);
        }
        return 0L;
    }

    public int getInt(int n) {
        this.assertValidRowType();
        this.assertValidColumnIndex(n);
        if (columnNames[n].equals("type")) {
            switch (this.currentRowType) {
                case BLANK: {
                    return 0;
                }
                case TOP: {
                    return 1;
                }
                case PINNED: {
                    return 2;
                }
                case SUGGESTED: {
                    return 3;
                }
            }
            return -1;
        }
        int n2 = this.getColumnIndexForCurrentRowType(n);
        if (n2 >= 0) {
            return this.currentCursor.getInt(n2);
        }
        return 0;
    }

    public String getString(int n) {
        int n2 = this.getColumnIndexForCurrentRowType(n);
        if (n2 >= 0) {
            return this.currentCursor.getString(n2);
        }
        return "";
    }

    public float getFloat(int n) {
        throw new UnsupportedOperationException();
    }

    public double getDouble(int n) {
        throw new UnsupportedOperationException();
    }

    public short getShort(int n) {
        throw new UnsupportedOperationException();
    }

    public byte[] getBlob(int n) {
        throw new UnsupportedOperationException();
    }

    public void copyStringToBuffer(int n, CharArrayBuffer charArrayBuffer) {
        throw new UnsupportedOperationException();
    }

    public boolean isNull(int n) {
        int n2 = this.getColumnIndexForCurrentRowType(n);
        if (n2 >= 0) {
            return this.currentCursor.isNull(n2);
        }
        return true;
    }

    public int getType(int n) {
        throw new UnsupportedOperationException();
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public int getColumnIndex(String string2) {
        Integer n = columnIndexes.get(string2);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public int getColumnIndexOrThrow(String string2) throws IllegalArgumentException {
        int n = this.getColumnIndex(string2);
        if (n < 0) {
            throw new IllegalArgumentException("Column index not found: " + string2);
        }
        return n;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public String[] getColumnNames() {
        return columnNames;
    }

    public boolean requery() {
        boolean bl;
        boolean bl2 = bl = this.topCursor.requery() && this.pinnedCursor.requery();
        if (this.suggestedCursor != null) {
            bl &= this.suggestedCursor.requery();
        }
        this.updatePinnedPositions();
        this.updateCount();
        return bl;
    }

    public Bundle respond(Bundle bundle) {
        throw new UnsupportedOperationException();
    }

    public Bundle getExtras() {
        throw new UnsupportedOperationException();
    }

    public boolean getWantsAllOnMoveCalls() {
        return false;
    }

    public Uri getNotificationUri() {
        return null;
    }

    public void setNotificationUri(ContentResolver contentResolver, Uri uri) {
    }

    public void registerContentObserver(ContentObserver contentObserver) {
        this.topCursor.registerContentObserver(contentObserver);
        this.pinnedCursor.registerContentObserver(contentObserver);
        if (this.suggestedCursor != null) {
            this.suggestedCursor.registerContentObserver(contentObserver);
        }
    }

    public void unregisterContentObserver(ContentObserver contentObserver) {
        this.topCursor.unregisterContentObserver(contentObserver);
        this.pinnedCursor.unregisterContentObserver(contentObserver);
        if (this.suggestedCursor != null) {
            this.suggestedCursor.unregisterContentObserver(contentObserver);
        }
    }

    public void registerDataSetObserver(DataSetObserver dataSetObserver) {
        this.topCursor.registerDataSetObserver(dataSetObserver);
        this.pinnedCursor.registerDataSetObserver(dataSetObserver);
        if (this.suggestedCursor != null) {
            this.suggestedCursor.registerDataSetObserver(dataSetObserver);
        }
    }

    public void unregisterDataSetObserver(DataSetObserver dataSetObserver) {
        this.topCursor.unregisterDataSetObserver(dataSetObserver);
        this.pinnedCursor.unregisterDataSetObserver(dataSetObserver);
        if (this.suggestedCursor != null) {
            this.suggestedCursor.unregisterDataSetObserver(dataSetObserver);
        }
    }

    public void deactivate() {
        this.topCursor.deactivate();
        this.pinnedCursor.deactivate();
        if (this.suggestedCursor != null) {
            this.suggestedCursor.deactivate();
        }
    }

    public boolean isClosed() {
        boolean bl;
        boolean bl2 = bl = this.topCursor.isClosed() && this.pinnedCursor.isClosed();
        if (this.suggestedCursor != null) {
            bl &= this.suggestedCursor.isClosed();
        }
        return bl;
    }

    public void close() {
        this.topCursor.close();
        this.topIndexes = null;
        this.pinnedCursor.close();
        this.pinnedIndexes = null;
        this.pinnedPositions = null;
        if (this.suggestedCursor != null) {
            this.suggestedCursor.close();
            this.suggestedIndexes = null;
        }
    }

    static {
        for (int i = 0; i < columnNames.length; ++i) {
            columnIndexes.put(columnNames[i], i);
        }
        INDEX_TRACKING_ID = columnIndexes.get("tracking_id");
        INDEX_IMAGEURL = columnIndexes.get("imageurl");
        INDEX_BGCOLOR = columnIndexes.get("bgcolor");
    }

    private static enum RowType {
        UNKNOWN,
        BLANK,
        TOP,
        PINNED,
        SUGGESTED;

    }
}

