/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabs;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.gecko.R;
import org.mozilla.gecko.RemoteTabsExpandableListAdapter;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.TabsAccessor;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.tabs.TabsPanel;

public class RemoteTabsList
extends ExpandableListView
implements ExpandableListView.OnGroupClickListener,
ExpandableListView.OnChildClickListener,
TabsAccessor.OnQueryTabsCompleteListener {
    private TabsPanel tabsPanel;
    private List<String> expandedClientList;
    private String clientScrollPosition;

    public RemoteTabsList(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setOnGroupClickListener(this);
        this.setOnChildClickListener(this);
        this.setAdapter((ExpandableListAdapter)new RemoteTabsExpandableListAdapter(R.layout.remote_tabs_group, R.layout.remote_tabs_child, null));
    }

    public void setTabsPanel(TabsPanel tabsPanel) {
        this.tabsPanel = tabsPanel;
    }

    private void autoHidePanel() {
        this.tabsPanel.autoHidePanel();
    }

    public boolean onGroupClick(ExpandableListView expandableListView, View view, int n, long l) {
        TabsAccessor.RemoteClient remoteClient = (TabsAccessor.RemoteClient)expandableListView.getExpandableListAdapter().getGroup(n);
        String string2 = remoteClient.guid;
        if (this.isGroupExpanded(n)) {
            this.collapseGroup(n);
            this.expandedClientList.remove(string2);
        } else {
            this.expandGroup(n);
            this.expandedClientList.add(string2);
        }
        this.clientScrollPosition = string2;
        return true;
    }

    public boolean onChildClick(ExpandableListView expandableListView, View view, int n, int n2, long l) {
        TabsAccessor.RemoteTab remoteTab = (TabsAccessor.RemoteTab)expandableListView.getExpandableListAdapter().getChild(n, n2);
        if (remoteTab == null) {
            this.autoHidePanel();
            return true;
        }
        Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.LIST_ITEM, "remote");
        Tabs.getInstance().loadUrl(remoteTab.url, 1);
        this.autoHidePanel();
        TabsAccessor.RemoteClient remoteClient = (TabsAccessor.RemoteClient)expandableListView.getExpandableListAdapter().getGroup(n);
        this.clientScrollPosition = remoteClient.guid;
        return true;
    }

    @Override
    public void onQueryTabsComplete(List<TabsAccessor.RemoteClient> list) {
        ((RemoteTabsExpandableListAdapter)this.getExpandableListAdapter()).replaceClients(list);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get((int)i).guid;
            if (this.expandedClientList == null) {
                arrayList.add(string2);
                this.expandGroup(i);
                continue;
            }
            if (this.expandedClientList.contains(string2)) {
                arrayList.add(string2);
                this.expandGroup(i);
            }
            if (!string2.equals(this.clientScrollPosition)) continue;
            this.setSelectedGroup(i);
        }
        this.expandedClientList = arrayList;
    }
}

