/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.eyesfree.braille.selfbraille;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;

public class WriteData
implements Parcelable {
    private static final String PROP_SELECTION_START = "selectionStart";
    private static final String PROP_SELECTION_END = "selectionEnd";
    private AccessibilityNodeInfo mAccessibilityNodeInfo;
    private CharSequence mText;
    private Bundle mProperties = Bundle.EMPTY;
    public static final Parcelable.Creator<WriteData> CREATOR = new Parcelable.Creator<WriteData>(){

        public WriteData createFromParcel(Parcel parcel) {
            return new WriteData(parcel);
        }

        public WriteData[] newArray(int n) {
            return new WriteData[n];
        }
    };

    public static WriteData forView(View view) {
        AccessibilityNodeInfo accessibilityNodeInfo = AccessibilityNodeInfo.obtain((View)view);
        WriteData writeData = new WriteData();
        writeData.mAccessibilityNodeInfo = accessibilityNodeInfo;
        return writeData;
    }

    public static WriteData forInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        WriteData writeData = new WriteData();
        writeData.mAccessibilityNodeInfo = accessibilityNodeInfo;
        return writeData;
    }

    public AccessibilityNodeInfo getAccessibilityNodeInfo() {
        return this.mAccessibilityNodeInfo;
    }

    public WriteData setText(CharSequence charSequence) {
        this.mText = charSequence;
        return this;
    }

    public CharSequence getText() {
        return this.mText;
    }

    public WriteData setSelectionStart(int n) {
        this.writableProperties().putInt(PROP_SELECTION_START, n);
        return this;
    }

    public int getSelectionStart() {
        return this.mProperties.getInt(PROP_SELECTION_START, -1);
    }

    public WriteData setSelectionEnd(int n) {
        this.writableProperties().putInt(PROP_SELECTION_END, n);
        return this;
    }

    public int getSelectionEnd() {
        return this.mProperties.getInt(PROP_SELECTION_END, -1);
    }

    private Bundle writableProperties() {
        if (this.mProperties == Bundle.EMPTY) {
            this.mProperties = new Bundle();
        }
        return this.mProperties;
    }

    public void validate() throws IllegalStateException {
        if (this.mAccessibilityNodeInfo == null) {
            throw new IllegalStateException("Accessibility node info can't be null");
        }
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd();
        if (this.mText == null) {
            if (n > 0 || n2 > 0) {
                throw new IllegalStateException("Selection can't be set without text");
            }
        } else {
            if (n < 0 && n2 >= 0) {
                throw new IllegalStateException("Selection end without start");
            }
            int n3 = this.mText.length();
            if (n > n3 || n2 > n3) {
                throw new IllegalStateException("Selection out of bounds");
            }
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.mAccessibilityNodeInfo.writeToParcel(parcel, n);
        this.mAccessibilityNodeInfo = null;
        parcel.writeString(this.mText.toString());
        parcel.writeBundle(this.mProperties);
    }

    private WriteData() {
    }

    private WriteData(Parcel parcel) {
        this.mAccessibilityNodeInfo = (AccessibilityNodeInfo)AccessibilityNodeInfo.CREATOR.createFromParcel(parcel);
        this.mText = parcel.readString();
        this.mProperties = parcel.readBundle();
    }
}

