/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.db.SQLiteBridgeContentProvider;
import org.mozilla.gecko.sqlite.SQLiteBridge;
import org.mozilla.gecko.sync.Utils;

public class FormHistoryProvider
extends SQLiteBridgeContentProvider {
    static final String TABLE_FORM_HISTORY = "moz_formhistory";
    static final String TABLE_DELETED_FORM_HISTORY = "moz_deleted_formhistory";
    private static final int FORM_HISTORY = 100;
    private static final int DELETED_FORM_HISTORY = 101;
    private static final UriMatcher URI_MATCHER;
    private static int DB_VERSION;
    private static String DB_FILENAME;
    private static final String TELEMETRY_TAG = "SQLITEBRIDGE_PROVIDER_FORMS";
    private static final String WHERE_GUID_IS_NULL = "guid IS NULL";
    private static final String WHERE_GUID_IS_VALUE = "guid = ?";
    private static final String LOG_TAG = "FormHistoryProvider";

    public FormHistoryProvider() {
        super(LOG_TAG);
    }

    @Override
    public String getType(Uri uri) {
        int n = URI_MATCHER.match(uri);
        switch (n) {
            case 100: {
                return "vnd.android.cursor.dir/formhistory";
            }
            case 101: {
                return "vnd.android.cursor.dir/deleted-formhistory";
            }
        }
        throw new UnsupportedOperationException("Unknown type " + uri);
    }

    @Override
    public String getTable(Uri uri) {
        String string2 = null;
        int n = URI_MATCHER.match(uri);
        switch (n) {
            case 101: {
                string2 = TABLE_DELETED_FORM_HISTORY;
                break;
            }
            case 100: {
                string2 = TABLE_FORM_HISTORY;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown table " + uri);
            }
        }
        return string2;
    }

    @Override
    public String getSortOrder(Uri uri, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        return null;
    }

    @Override
    public void setupDefaults(Uri uri, ContentValues contentValues) {
        int n = URI_MATCHER.match(uri);
        long l = System.currentTimeMillis();
        switch (n) {
            case 101: {
                contentValues.put("timeDeleted", Long.valueOf(l));
                if (contentValues.containsKey("guid")) break;
                throw new IllegalArgumentException("Must provide a GUID for a deleted form history");
            }
            case 100: {
                if (contentValues.containsKey("guid")) break;
                String string2 = Utils.generateGuid();
                contentValues.put("guid", string2);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown insert URI " + uri);
            }
        }
    }

    @Override
    public void initGecko() {
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("FormHistory:Init", null));
    }

    @Override
    public void onPreInsert(ContentValues contentValues, Uri uri, SQLiteBridge sQLiteBridge) {
        if (!contentValues.containsKey("guid")) {
            return;
        }
        String string2 = contentValues.getAsString("guid");
        if (string2 == null) {
            sQLiteBridge.delete(TABLE_DELETED_FORM_HISTORY, WHERE_GUID_IS_NULL, null);
            return;
        }
        String[] stringArray = new String[]{string2};
        sQLiteBridge.delete(TABLE_DELETED_FORM_HISTORY, WHERE_GUID_IS_VALUE, stringArray);
    }

    @Override
    public void onPreUpdate(ContentValues contentValues, Uri uri, SQLiteBridge sQLiteBridge) {
    }

    @Override
    public void onPostQuery(Cursor cursor, Uri uri, SQLiteBridge sQLiteBridge) {
    }

    @Override
    protected String getDBName() {
        return DB_FILENAME;
    }

    @Override
    protected String getTelemetryPrefix() {
        return TELEMETRY_TAG;
    }

    @Override
    protected int getDBVersion() {
        return DB_VERSION;
    }

    static {
        DB_VERSION = 4;
        DB_FILENAME = "formhistory.sqlite";
        URI_MATCHER = new UriMatcher(-1);
        URI_MATCHER.addURI("org.mozilla.fennec.db.formhistory", "formhistory", 100);
        URI_MATCHER.addURI("org.mozilla.fennec.db.formhistory", "deleted-formhistory", 101);
    }
}

