/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.graphics.PointF;
import android.graphics.RectF;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsoluteLayout;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.gfx.BufferedCairoImage;
import org.mozilla.gecko.gfx.Layer;
import org.mozilla.gecko.gfx.RectUtils;
import org.mozilla.gecko.gfx.TileLayer;
import org.mozilla.gecko.util.FloatUtils;
import org.mozilla.gecko.util.ThreadUtils;

public class PluginLayer
extends TileLayer {
    private static final String LOGTAG = "PluginLayer";
    private View mView;
    private SurfaceView mSurfaceView;
    private PluginLayoutParams mLayoutParams;
    private AbsoluteLayout mContainer;
    private boolean mDestroyed;
    private boolean mViewVisible;
    private RectF mLastViewport;
    private float mLastZoomFactor;
    private static final float[] TEXTURE_MAP = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f};

    public PluginLayer(View view, RectF rectF, int n) {
        super(new BufferedCairoImage(null, 0, 0, 0), TileLayer.PaintMode.NORMAL);
        this.mView = view;
        this.mContainer = GeckoAppShell.getGeckoInterface().getPluginContainer();
        this.mView.setWillNotDraw(false);
        if (this.mView instanceof SurfaceView) {
            this.mSurfaceView = (SurfaceView)view;
            this.mSurfaceView.setZOrderOnTop(false);
            this.mSurfaceView.setZOrderMediaOverlay(true);
        }
        this.mLayoutParams = new PluginLayoutParams(rectF, n);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.showView();
        } else {
            this.hideView();
        }
    }

    private void hideView() {
        if (this.mViewVisible) {
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    PluginLayer.this.mView.setVisibility(8);
                    PluginLayer.this.mViewVisible = false;
                }
            });
        }
    }

    public void showView() {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (PluginLayer.this.mContainer.indexOfChild(PluginLayer.this.mView) < 0) {
                    PluginLayer.this.mContainer.addView(PluginLayer.this.mView, (ViewGroup.LayoutParams)PluginLayer.this.mLayoutParams);
                } else {
                    PluginLayer.this.mContainer.updateViewLayout(PluginLayer.this.mView, (ViewGroup.LayoutParams)PluginLayer.this.mLayoutParams);
                    PluginLayer.this.mView.setVisibility(0);
                }
                PluginLayer.this.mViewVisible = true;
            }
        });
    }

    @Override
    public void destroy() {
        this.mDestroyed = true;
        this.mContainer.removeView(this.mView);
    }

    public void reset(RectF rectF) {
        this.mLayoutParams.reset(rectF);
    }

    @Override
    protected void performUpdates(Layer.RenderContext renderContext) {
        if (this.mDestroyed) {
            return;
        }
        if (!RectUtils.fuzzyEquals(renderContext.viewport, this.mLastViewport) || !FloatUtils.fuzzyEquals((float)renderContext.zoomFactor, (float)this.mLastZoomFactor)) {
            this.mLastZoomFactor = renderContext.zoomFactor;
            this.mLastViewport = renderContext.viewport;
            this.mLayoutParams.reposition(renderContext.viewport, renderContext.offset, renderContext.zoomFactor);
            this.showView();
        }
    }

    @Override
    public void draw(Layer.RenderContext renderContext) {
    }

    class PluginLayoutParams
    extends AbsoluteLayout.LayoutParams {
        private static final String LOGTAG = "GeckoApp.PluginLayoutParams";
        private RectF mRect;
        private int mMaxDimension;
        private float mLastResolution;

        public PluginLayoutParams(RectF rectF, int n) {
            super(0, 0, 0, 0);
            this.mMaxDimension = n;
            this.reset(rectF);
        }

        private void clampToMaxSize() {
            if (this.width > this.mMaxDimension || this.height > this.mMaxDimension) {
                if (this.width > this.height) {
                    this.height = Math.round((float)this.height / (float)this.width * (float)this.mMaxDimension);
                    this.width = this.mMaxDimension;
                } else {
                    this.width = Math.round((float)this.width / (float)this.height * (float)this.mMaxDimension);
                    this.height = this.mMaxDimension;
                }
            }
        }

        public void reset(RectF rectF) {
            this.mRect = rectF;
        }

        public void reposition(RectF rectF, PointF pointF, float f) {
            RectF rectF2 = RectUtils.scale(this.mRect, f);
            rectF2.offset(pointF.x, pointF.y);
            this.x = Math.round(rectF2.left - rectF.left);
            this.y = Math.round(rectF2.top - rectF.top);
            if (!FloatUtils.fuzzyEquals((float)this.mLastResolution, (float)f)) {
                this.width = Math.round(this.mRect.width() * f);
                this.height = Math.round(this.mRect.height() * f);
                this.mLastResolution = f;
                this.clampToMaxSize();
            }
        }
    }
}

