/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.entity;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.HttpException;
import ch.boye.httpclientandroidlib.HttpMessage;
import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.entity.BasicHttpEntity;
import ch.boye.httpclientandroidlib.entity.ContentLengthStrategy;
import ch.boye.httpclientandroidlib.impl.io.ChunkedInputStream;
import ch.boye.httpclientandroidlib.impl.io.ContentLengthInputStream;
import ch.boye.httpclientandroidlib.impl.io.IdentityInputStream;
import ch.boye.httpclientandroidlib.io.SessionInputBuffer;
import ch.boye.httpclientandroidlib.util.Args;
import java.io.IOException;

@Deprecated
@Immutable
public class EntityDeserializer {
    private final ContentLengthStrategy lenStrategy;

    public EntityDeserializer(ContentLengthStrategy contentLengthStrategy) {
        this.lenStrategy = Args.notNull(contentLengthStrategy, "Content length strategy");
    }

    protected BasicHttpEntity doDeserialize(SessionInputBuffer sessionInputBuffer, HttpMessage httpMessage) throws HttpException, IOException {
        Header header;
        BasicHttpEntity basicHttpEntity = new BasicHttpEntity();
        long l = this.lenStrategy.determineLength(httpMessage);
        if (l == -2L) {
            basicHttpEntity.setChunked(true);
            basicHttpEntity.setContentLength(-1L);
            basicHttpEntity.setContent(new ChunkedInputStream(sessionInputBuffer));
        } else if (l == -1L) {
            basicHttpEntity.setChunked(false);
            basicHttpEntity.setContentLength(-1L);
            basicHttpEntity.setContent(new IdentityInputStream(sessionInputBuffer));
        } else {
            basicHttpEntity.setChunked(false);
            basicHttpEntity.setContentLength(l);
            basicHttpEntity.setContent(new ContentLengthInputStream(sessionInputBuffer, l));
        }
        Header header2 = httpMessage.getFirstHeader("Content-Type");
        if (header2 != null) {
            basicHttpEntity.setContentType(header2);
        }
        if ((header = httpMessage.getFirstHeader("Content-Encoding")) != null) {
            basicHttpEntity.setContentEncoding(header);
        }
        return basicHttpEntity;
    }

    public HttpEntity deserialize(SessionInputBuffer sessionInputBuffer, HttpMessage httpMessage) throws HttpException, IOException {
        Args.notNull(sessionInputBuffer, "Session input buffer");
        Args.notNull(httpMessage, "HTTP message");
        return this.doDeserialize(sessionInputBuffer, httpMessage);
    }
}

