/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.protocol;

import ch.boye.httpclientandroidlib.HttpRequest;
import ch.boye.httpclientandroidlib.annotation.ThreadSafe;
import ch.boye.httpclientandroidlib.protocol.HttpRequestHandler;
import ch.boye.httpclientandroidlib.protocol.HttpRequestHandlerMapper;
import ch.boye.httpclientandroidlib.protocol.UriPatternMatcher;
import ch.boye.httpclientandroidlib.util.Args;

@ThreadSafe
public class UriHttpRequestHandlerMapper
implements HttpRequestHandlerMapper {
    private final UriPatternMatcher<HttpRequestHandler> matcher;

    protected UriHttpRequestHandlerMapper(UriPatternMatcher<HttpRequestHandler> uriPatternMatcher) {
        this.matcher = Args.notNull(uriPatternMatcher, "Pattern matcher");
    }

    public UriHttpRequestHandlerMapper() {
        this(new UriPatternMatcher<HttpRequestHandler>());
    }

    public void register(String string, HttpRequestHandler httpRequestHandler) {
        Args.notNull(string, "Pattern");
        Args.notNull(httpRequestHandler, "Handler");
        this.matcher.register(string, httpRequestHandler);
    }

    public void unregister(String string) {
        this.matcher.unregister(string);
    }

    protected String getRequestPath(HttpRequest httpRequest) {
        String string = httpRequest.getRequestLine().getUri();
        int n = string.indexOf("?");
        if (n != -1) {
            string = string.substring(0, n);
        } else {
            n = string.indexOf("#");
            if (n != -1) {
                string = string.substring(0, n);
            }
        }
        return string;
    }

    @Override
    public HttpRequestHandler lookup(HttpRequest httpRequest) {
        Args.notNull(httpRequest, "HTTP request");
        return this.matcher.lookup(this.getRequestPath(httpRequest));
    }
}

