/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.search.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import org.mozilla.search.R;

public class FacetBar
extends RadioGroup {
    private static final RadioGroup.LayoutParams FACET_LAYOUT_PARAMS = new RadioGroup.LayoutParams(0, -1, 1.0f);
    private int underlineColor = -65536;
    private int nextButtonId = 0;

    public FacetBar(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public void addFacet(String string2) {
        this.addFacet(string2, false);
    }

    public void addFacet(String string2, boolean bl) {
        FacetButton facetButton = new FacetButton(this.getContext(), string2, this.underlineColor);
        facetButton.setId(this.nextButtonId++);
        facetButton.setLayoutParams((ViewGroup.LayoutParams)FACET_LAYOUT_PARAMS);
        facetButton.setChecked(bl);
        this.addView((View)facetButton);
    }

    public void setUnderlineColor(int n) {
        this.underlineColor = n;
        if (this.getChildCount() > 0) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                ((FacetButton)this.getChildAt(i)).setUnderlineColor(n);
            }
        }
    }

    private static class FacetButton
    extends RadioButton {
        private final Paint underlinePaint = new Paint();

        public FacetButton(Context context, String string2, int n) {
            super(context, null, R.attr.facetButtonStyle);
            this.setText(string2);
            this.underlinePaint.setStyle(Paint.Style.STROKE);
            this.underlinePaint.setStrokeWidth(this.getResources().getDimension(R.dimen.facet_button_underline_thickness));
            this.underlinePaint.setColor(n);
        }

        public void setChecked(boolean bl) {
            super.setChecked(bl);
            this.invalidate();
        }

        protected void onDraw(Canvas canvas) {
            super.onDraw(canvas);
            if (this.isChecked()) {
                float f = (float)this.getHeight() - this.underlinePaint.getStrokeWidth() / 2.0f;
                canvas.drawLine(0.0f, f, (float)this.getWidth(), f, this.underlinePaint);
            }
        }

        public void setUnderlineColor(int n) {
            this.underlinePaint.setColor(n);
        }
    }
}

