/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.KeyguardManager;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.support.v4.app.NotificationCompat;
import android.view.Window;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.BrowserApp;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.R;

public class GuestSession {
    public static final String NOTIFICATION_INTENT = "org.mozilla.gecko.GUEST_SESSION_INPROGRESS";
    private static final String LOGTAG = "GeckoGuestSession";

    static boolean isSecureKeyguardLocked(Context context) {
        KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
        if (AppConstants.Versions.preJB || keyguardManager == null) {
            return false;
        }
        return keyguardManager.isKeyguardLocked() && keyguardManager.isKeyguardSecure();
    }

    public static boolean shouldUse(Context context, String string2) {
        if (string2 != null && string2.contains("--guest")) {
            return true;
        }
        boolean bl = GuestSession.isSecureKeyguardLocked(context);
        if (bl) {
            return true;
        }
        GeckoProfile geckoProfile = GeckoProfile.getGuestProfile(context);
        if (geckoProfile == null) {
            return false;
        }
        return geckoProfile.locked();
    }

    public static void configureWindow(Window window) {
        window.addFlags(0x480000);
    }

    public static void unconfigureWindow(Window window) {
        window.clearFlags(0x480000);
    }

    private static PendingIntent getNotificationIntent(Context context) {
        Intent intent = new Intent(NOTIFICATION_INTENT);
        intent.setClass(context, BrowserApp.class);
        return PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0x8000000);
    }

    public static void showNotification(Context context) {
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context);
        Resources resources = context.getResources();
        builder.setContentTitle((CharSequence)resources.getString(R.string.guest_browsing_notification_title)).setContentText((CharSequence)resources.getString(R.string.guest_browsing_notification_text)).setSmallIcon(R.drawable.alert_guest).setOngoing(true).setContentIntent(GuestSession.getNotificationIntent(context));
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        notificationManager.notify(R.id.guestNotification, builder.build());
    }

    public static void hideNotification(Context context) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        notificationManager.cancel(R.id.guestNotification);
    }

    public static void onDestroy(Context context) {
        if (GeckoProfile.get(context).inGuestMode()) {
            GuestSession.hideNotification(context);
        }
    }

    public static void handleIntent(BrowserApp browserApp, Intent intent) {
        browserApp.showGuestModeDialog(BrowserApp.GuestModeDialog.LEAVING);
    }
}

