/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabs;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.tabs.TabStripView;
import org.mozilla.gecko.widget.ThemedLinearLayout;

public class TabStrip
extends ThemedLinearLayout {
    private static final String LOGTAG = "GeckoTabStrip";
    private static final int IMAGE_LEVEL_NORMAL = 0;
    private static final int IMAGE_LEVEL_PRIVATE = 1;
    private final TabStripView tabStripView;
    private final ImageButton addTabButton;
    private final TabsListener tabsListener;

    public TabStrip(Context context) {
        this(context, null);
    }

    public TabStrip(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setOrientation(0);
        LayoutInflater.from((Context)context).inflate(R.layout.tab_strip, (ViewGroup)this);
        this.tabStripView = (TabStripView)this.findViewById(R.id.tab_strip);
        this.addTabButton = (ImageButton)this.findViewById(R.id.add_tab);
        this.addTabButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Tabs tabs = Tabs.getInstance();
                if (TabStrip.this.isPrivateMode()) {
                    tabs.addPrivateTab();
                } else {
                    tabs.addTab();
                }
            }
        });
        this.tabsListener = new TabsListener();
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        Tabs.registerOnTabsChangedListener(this.tabsListener);
        this.tabStripView.refreshTabs();
    }

    @Override
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        Tabs.unregisterOnTabsChangedListener(this.tabsListener);
        this.tabStripView.clearTabs();
    }

    @Override
    public void setPrivateMode(boolean bl) {
        super.setPrivateMode(bl);
        this.addTabButton.setImageLevel(bl ? 1 : 0);
    }

    private class TabsListener
    implements Tabs.OnTabsChangedListener {
        private TabsListener() {
        }

        @Override
        public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
            switch (tabEvents) {
                case RESTORED: 
                case ADDED: {
                    TabStrip.this.tabStripView.refreshTabs();
                    break;
                }
                case CLOSED: {
                    TabStrip.this.tabStripView.removeTab(tab);
                    break;
                }
                case SELECTED: {
                    TabStrip.this.tabStripView.selectTab(tab);
                    TabStrip.this.setPrivateMode(tab.isPrivate());
                }
                case UNSELECTED: 
                case TITLE: 
                case FAVICON: 
                case RECORDING_CHANGE: {
                    TabStrip.this.tabStripView.updateTab(tab);
                }
            }
        }
    }
}

