/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.client.protocol;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpException;
import ch.boye.httpclientandroidlib.HttpHost;
import ch.boye.httpclientandroidlib.HttpRequest;
import ch.boye.httpclientandroidlib.HttpRequestInterceptor;
import ch.boye.httpclientandroidlib.androidextra.HttpClientAndroidLog;
import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.client.CookieStore;
import ch.boye.httpclientandroidlib.client.config.RequestConfig;
import ch.boye.httpclientandroidlib.client.methods.HttpUriRequest;
import ch.boye.httpclientandroidlib.client.protocol.HttpClientContext;
import ch.boye.httpclientandroidlib.config.Lookup;
import ch.boye.httpclientandroidlib.conn.routing.RouteInfo;
import ch.boye.httpclientandroidlib.cookie.Cookie;
import ch.boye.httpclientandroidlib.cookie.CookieOrigin;
import ch.boye.httpclientandroidlib.cookie.CookieSpec;
import ch.boye.httpclientandroidlib.cookie.CookieSpecProvider;
import ch.boye.httpclientandroidlib.cookie.SetCookie2;
import ch.boye.httpclientandroidlib.protocol.HttpContext;
import ch.boye.httpclientandroidlib.util.Args;
import ch.boye.httpclientandroidlib.util.TextUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

@Immutable
public class RequestAddCookies
implements HttpRequestInterceptor {
    public HttpClientAndroidLog log = new HttpClientAndroidLog(this.getClass());

    @Override
    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        int n;
        Object object;
        Args.notNull(httpRequest, "HTTP request");
        Args.notNull(httpContext, "HTTP context");
        String string = httpRequest.getRequestLine().getMethod();
        if (string.equalsIgnoreCase("CONNECT")) {
            return;
        }
        HttpClientContext httpClientContext = HttpClientContext.adapt(httpContext);
        CookieStore cookieStore = httpClientContext.getCookieStore();
        if (cookieStore == null) {
            this.log.debug("Cookie store not specified in HTTP context");
            return;
        }
        Lookup<CookieSpecProvider> lookup = httpClientContext.getCookieSpecRegistry();
        if (lookup == null) {
            this.log.debug("CookieSpec registry not specified in HTTP context");
            return;
        }
        HttpHost httpHost = httpClientContext.getTargetHost();
        if (httpHost == null) {
            this.log.debug("Target host not set in the context");
            return;
        }
        RouteInfo routeInfo = httpClientContext.getHttpRoute();
        if (routeInfo == null) {
            this.log.debug("Connection route not set in the context");
            return;
        }
        RequestConfig requestConfig = httpClientContext.getRequestConfig();
        String string2 = requestConfig.getCookieSpec();
        if (string2 == null) {
            string2 = "best-match";
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("CookieSpec selected: " + string2);
        }
        URI uRI = null;
        if (httpRequest instanceof HttpUriRequest) {
            uRI = ((HttpUriRequest)httpRequest).getURI();
        } else {
            try {
                uRI = new URI(httpRequest.getRequestLine().getUri());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String string3 = uRI != null ? uRI.getPath() : null;
        String string4 = httpHost.getHostName();
        int n2 = httpHost.getPort();
        if (n2 < 0) {
            n2 = routeInfo.getTargetHost().getPort();
        }
        CookieOrigin cookieOrigin = new CookieOrigin(string4, n2 >= 0 ? n2 : 0, !TextUtils.isEmpty(string3) ? string3 : "/", routeInfo.isSecure());
        CookieSpecProvider cookieSpecProvider = lookup.lookup(string2);
        if (cookieSpecProvider == null) {
            throw new HttpException("Unsupported cookie policy: " + string2);
        }
        CookieSpec cookieSpec = cookieSpecProvider.create(httpClientContext);
        ArrayList<Cookie> arrayList = new ArrayList<Cookie>(cookieStore.getCookies());
        ArrayList<Cookie> arrayList2 = new ArrayList<Cookie>();
        Date date = new Date();
        for (Cookie object2 : arrayList) {
            if (!object2.isExpired(date)) {
                if (!cookieSpec.match(object2, cookieOrigin)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Cookie " + object2 + " match " + cookieOrigin);
                }
                arrayList2.add(object2);
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("Cookie " + object2 + " expired");
        }
        if (!arrayList2.isEmpty()) {
            List<Header> list = cookieSpec.formatCookies(arrayList2);
            Iterator bl = list.iterator();
            while (bl.hasNext()) {
                object = (Header)bl.next();
                httpRequest.addHeader((Header)object);
            }
        }
        if ((n = cookieSpec.getVersion()) > 0) {
            boolean bl;
            boolean bl2 = false;
            object = arrayList2.iterator();
            while (object.hasNext()) {
                Cookie cookie = (Cookie)object.next();
                if (n == cookie.getVersion() && cookie instanceof SetCookie2) continue;
                bl = true;
            }
            if (bl && (object = cookieSpec.getVersionHeader()) != null) {
                httpRequest.addHeader((Header)object);
            }
        }
        httpContext.setAttribute("http.cookie-spec", cookieSpec);
        httpContext.setAttribute("http.cookie-origin", cookieOrigin);
    }
}

