/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.entity.mime.content;

import ch.boye.httpclientandroidlib.Consts;
import ch.boye.httpclientandroidlib.entity.ContentType;
import ch.boye.httpclientandroidlib.entity.mime.content.AbstractContentBody;
import ch.boye.httpclientandroidlib.util.Args;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;

public class StringBody
extends AbstractContentBody {
    private final byte[] content;

    @Deprecated
    public static StringBody create(String string, String string2, Charset charset) throws IllegalArgumentException {
        try {
            return new StringBody(string, string2, charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Charset " + charset + " is not supported", unsupportedEncodingException);
        }
    }

    @Deprecated
    public static StringBody create(String string, Charset charset) throws IllegalArgumentException {
        return StringBody.create(string, null, charset);
    }

    @Deprecated
    public static StringBody create(String string) throws IllegalArgumentException {
        return StringBody.create(string, null, null);
    }

    @Deprecated
    public StringBody(String string, String string2, Charset charset) throws UnsupportedEncodingException {
        this(string, ContentType.create(string2, charset));
    }

    @Deprecated
    public StringBody(String string, Charset charset) throws UnsupportedEncodingException {
        this(string, "text/plain", charset);
    }

    @Deprecated
    public StringBody(String string) throws UnsupportedEncodingException {
        this(string, "text/plain", Consts.ASCII);
    }

    public StringBody(String string, ContentType contentType) {
        super(contentType);
        Args.notNull(string, "Text");
        Charset charset = contentType.getCharset();
        String string2 = charset != null ? charset.name() : Consts.ASCII.name();
        try {
            this.content = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnsupportedCharsetException(string2);
        }
    }

    public Reader getReader() {
        Charset charset = this.getContentType().getCharset();
        return new InputStreamReader((InputStream)new ByteArrayInputStream(this.content), charset != null ? charset : Consts.ASCII);
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        int n;
        Args.notNull(outputStream, "Output stream");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.content);
        byte[] byArray = new byte[4096];
        while ((n = byteArrayInputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
    }

    @Override
    public String getTransferEncoding() {
        return "8bit";
    }

    @Override
    public long getContentLength() {
        return this.content.length;
    }

    @Override
    public String getFilename() {
        return null;
    }
}

