/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.conn;

import ch.boye.httpclientandroidlib.androidextra.HttpClientAndroidLog;
import ch.boye.httpclientandroidlib.conn.DnsResolver;
import ch.boye.httpclientandroidlib.util.Args;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InMemoryDnsResolver
implements DnsResolver {
    public HttpClientAndroidLog log = new HttpClientAndroidLog(InMemoryDnsResolver.class);
    private final Map<String, InetAddress[]> dnsMap = new ConcurrentHashMap<String, InetAddress[]>();

    public void add(String string, InetAddress ... inetAddressArray) {
        Args.notNull(string, "Host name");
        Args.notNull(inetAddressArray, "Array of IP addresses");
        this.dnsMap.put(string, inetAddressArray);
    }

    @Override
    public InetAddress[] resolve(String string) throws UnknownHostException {
        Object[] objectArray = this.dnsMap.get(string);
        if (this.log.isInfoEnabled()) {
            this.log.info("Resolving " + string + " to " + Arrays.deepToString(objectArray));
        }
        if (objectArray == null) {
            throw new UnknownHostException(string + " cannot be resolved");
        }
        return objectArray;
    }
}

