/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.search.providers;

import android.net.Uri;
import android.util.Log;
import android.util.Xml;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class SearchEngine {
    private static final String LOG_TAG = "SearchEngine";
    private static final String URLTYPE_SUGGEST_JSON = "application/x-suggestions+json";
    private static final String URLTYPE_SEARCH_HTML = "text/html";
    private static final String MOZ_PARAM_LOCALE = "\\{moz:locale\\}";
    private static final String MOZ_PARAM_DIST_ID = "\\{moz:distributionID\\}";
    private static final String MOZ_PARAM_OFFICIAL = "\\{moz:official\\}";
    private static final String OS_PARAM_USER_DEFINED = "\\{searchTerms\\??\\}";
    private static final String OS_PARAM_INPUT_ENCODING = "\\{inputEncoding\\??\\}";
    private static final String OS_PARAM_LANGUAGE = "\\{language\\??\\}";
    private static final String OS_PARAM_OUTPUT_ENCODING = "\\{outputEncoding\\??\\}";
    private static final String OS_PARAM_OPTIONAL = "\\{(?:\\w+:)?\\w+\\?\\}";
    private static final String STYLE_INJECTION_SCRIPT = "javascript:(function(){var tag=document.createElement('style');tag.type='text/css';document.getElementsByTagName('head')[0].appendChild(tag);tag.innerText='%s'})();";
    private String identifier;
    private String shortName;
    private String iconURL;
    private Uri resultsUri;
    private Uri suggestUri;

    public SearchEngine(String string, InputStream inputStream) throws IOException, XmlPullParserException {
        this.identifier = string;
        XmlPullParser xmlPullParser = Xml.newPullParser();
        xmlPullParser.setInput(inputStream, null);
        xmlPullParser.nextTag();
        this.readSearchPlugin(xmlPullParser);
    }

    private void readSearchPlugin(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        xmlPullParser.require(2, null, "SearchPlugin");
        while (xmlPullParser.next() != 3) {
            if (xmlPullParser.getEventType() != 2) continue;
            String string = xmlPullParser.getName();
            if (string.equals("ShortName")) {
                this.readShortName(xmlPullParser);
                continue;
            }
            if (string.equals("Url")) {
                this.readUrl(xmlPullParser);
                continue;
            }
            if (string.equals("Image")) {
                this.readImage(xmlPullParser);
                continue;
            }
            this.skip(xmlPullParser);
        }
    }

    private void readShortName(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        xmlPullParser.require(2, null, "ShortName");
        if (xmlPullParser.next() == 4) {
            this.shortName = xmlPullParser.getText();
            xmlPullParser.nextTag();
        }
    }

    private void readUrl(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        xmlPullParser.require(2, null, "Url");
        String string = xmlPullParser.getAttributeValue(null, "type");
        String string2 = xmlPullParser.getAttributeValue(null, "template");
        Uri uri = Uri.parse((String)string2);
        while (xmlPullParser.next() != 3) {
            if (xmlPullParser.getEventType() != 2) continue;
            String string3 = xmlPullParser.getName();
            if (string3.equals("Param")) {
                String string4 = xmlPullParser.getAttributeValue(null, "name");
                String string5 = xmlPullParser.getAttributeValue(null, "value");
                uri = uri.buildUpon().appendQueryParameter(string4, string5).build();
                xmlPullParser.nextTag();
                continue;
            }
            this.skip(xmlPullParser);
        }
        if (string.equals(URLTYPE_SEARCH_HTML)) {
            this.resultsUri = uri;
        } else if (string.equals(URLTYPE_SUGGEST_JSON)) {
            this.suggestUri = uri;
        }
    }

    private void readImage(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        xmlPullParser.require(2, null, "Image");
        if (xmlPullParser.next() == 4) {
            this.iconURL = xmlPullParser.getText();
            xmlPullParser.nextTag();
        }
    }

    private void skip(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        if (xmlPullParser.getEventType() != 2) {
            throw new IllegalStateException();
        }
        int n = 1;
        while (n != 0) {
            switch (xmlPullParser.next()) {
                case 3: {
                    --n;
                    break;
                }
                case 2: {
                    ++n;
                }
            }
        }
    }

    public String getInjectableJs() {
        String string = this.identifier.equals("bing") ? "#mHeader{display:none}#contentWrapper{margin-top:0}" : (this.identifier.equals("google") ? "#sfcnt,#top_nav{display:none}" : (this.identifier.equals("yahoo") ? "#nav,#header{display:none}" : ""));
        return String.format(STYLE_INJECTION_SCRIPT, string);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.shortName;
    }

    public String getIconURL() {
        return this.iconURL;
    }

    public boolean isSearchResultsPage(String string) {
        return this.resultsUri.getAuthority().equalsIgnoreCase(Uri.parse((String)string).getAuthority());
    }

    public String queryForResultsUrl(String string) {
        Set set = this.resultsUri.getQueryParameterNames();
        for (String string2 : set) {
            if (!this.resultsUri.getQueryParameter(string2).matches(OS_PARAM_USER_DEFINED)) continue;
            return Uri.parse((String)string).getQueryParameter(string2);
        }
        return "";
    }

    public String resultsUriForQuery(String string) {
        if (this.resultsUri == null) {
            Log.e((String)LOG_TAG, (String)("No results URL for search engine: " + this.identifier));
            return "";
        }
        String string2 = Uri.decode((String)this.resultsUri.toString());
        return this.paramSubstitution(string2, Uri.encode((String)string));
    }

    public String getSuggestionTemplate(String string) {
        if (this.suggestUri == null) {
            Log.e((String)LOG_TAG, (String)("No suggestions template for search engine: " + this.identifier));
            return "";
        }
        String string2 = Uri.decode((String)this.suggestUri.toString());
        return this.paramSubstitution(string2, Uri.encode((String)string));
    }

    private String paramSubstitution(String string, String string2) {
        String string3 = Locale.getDefault().toString();
        string = string.replaceAll(MOZ_PARAM_LOCALE, string3);
        string = string.replaceAll(MOZ_PARAM_DIST_ID, "");
        string = string.replaceAll(MOZ_PARAM_OFFICIAL, "unofficial");
        string = string.replaceAll(OS_PARAM_USER_DEFINED, string2);
        string = string.replaceAll(OS_PARAM_INPUT_ENCODING, "UTF-8");
        string = string.replaceAll(OS_PARAM_LANGUAGE, string3);
        string = string.replaceAll(OS_PARAM_OUTPUT_ENCODING, "UTF-8");
        string = string.replaceAll(OS_PARAM_OPTIONAL, "");
        return string;
    }
}

