/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.search.providers;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.mozilla.gecko.BrowserLocaleManager;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.util.GeckoJarReader;
import org.mozilla.search.providers.SearchEngine;
import org.xmlpull.v1.XmlPullParserException;

public class SearchEngineManager
implements SharedPreferences.OnSharedPreferenceChangeListener {
    private static final String LOG_TAG = "SearchEngineManager";
    private Context context;
    private SearchEngineCallback changeCallback;
    private SearchEngine engine;

    public SearchEngineManager(Context context) {
        this.context = context;
        GeckoSharedPrefs.forApp((Context)context).registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
    }

    public void setChangeCallback(SearchEngineCallback searchEngineCallback) {
        this.changeCallback = searchEngineCallback;
    }

    public void getEngine(SearchEngineCallback searchEngineCallback) {
        if (this.engine != null) {
            searchEngineCallback.execute(this.engine);
        } else {
            this.getEngineFromPrefs(searchEngineCallback);
        }
    }

    public void destroy() {
        GeckoSharedPrefs.forApp((Context)this.context).unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        this.context = null;
        this.changeCallback = null;
        this.engine = null;
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String string) {
        if (!TextUtils.equals((CharSequence)"search.engines.default", (CharSequence)string)) {
            return;
        }
        this.getEngineFromPrefs(this.changeCallback);
    }

    private void getEngineFromPrefs(final SearchEngineCallback searchEngineCallback) {
        AsyncTask<Void, Void, SearchEngine> asyncTask = new AsyncTask<Void, Void, SearchEngine>(){

            protected SearchEngine doInBackground(Void ... voidArray) {
                String string = GeckoSharedPrefs.forApp((Context)SearchEngineManager.this.context).getString("search.engines.default", null);
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    try {
                        return SearchEngineManager.this.createEngine(string);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Log.e((String)SearchEngineManager.LOG_TAG, (String)"Exception creating search engine from pref. Falling back to default engine.", (Throwable)illegalArgumentException);
                    }
                }
                try {
                    return SearchEngineManager.this.createEngine("yahoo");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Log.e((String)SearchEngineManager.LOG_TAG, (String)"Exception creating search engine from default identifier. This will happen if the locale doesn't contain the default search plugin.", (Throwable)illegalArgumentException);
                    return null;
                }
            }

            protected void onPostExecute(SearchEngine searchEngine) {
                if (searchEngine != null) {
                    SearchEngineManager.this.engine = searchEngine;
                    if (searchEngineCallback != null) {
                        searchEngineCallback.execute(searchEngine);
                    }
                }
            }
        };
        asyncTask.execute((Object[])new Void[0]);
    }

    public List<SearchEngine> getAllEngines() {
        InputStream inputStream = this.getInputStreamFromJar("list.txt");
        if (inputStream == null) {
            try {
                inputStream = this.context.getResources().getAssets().open("engines/list.txt");
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Error reading list.txt");
            }
        }
        ArrayList<SearchEngine> arrayList = new ArrayList<SearchEngine>();
        InputStreamReader inputStreamReader = null;
        try {
            String string;
            inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(this.createEngine(string));
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Error creating all search engines from list.txt");
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {}
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchEngine createEngine(String string) {
        block9: {
            SearchEngine searchEngine;
            InputStream inputStream = this.getInputStreamFromJar(string + ".xml");
            if (inputStream == null) {
                inputStream = this.getEngineFromProfile(string);
            }
            if (inputStream == null) {
                inputStream = this.getEngineFromAssets(string);
            }
            if (inputStream == null) {
                throw new IllegalArgumentException("Couldn't find search engine for identifier: " + string);
            }
            try {
                searchEngine = new SearchEngine(string, inputStream);
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    Log.e((String)LOG_TAG, (String)"Exception creating search engine", (Throwable)iOException);
                    break block9;
                }
                catch (XmlPullParserException xmlPullParserException) {
                    Log.e((String)LOG_TAG, (String)"Exception creating search engine", (Throwable)xmlPullParserException);
                }
            }
            inputStream.close();
            return searchEngine;
        }
        return null;
    }

    private InputStream getEngineFromAssets(String string) {
        try {
            return this.context.getResources().getAssets().open("engines/" + string + ".xml");
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (String)"Exception getting search engine from assets", (Throwable)iOException);
            return null;
        }
    }

    private InputStream getInputStreamFromJar(String string) {
        Locale locale = Locale.getDefault();
        String string2 = BrowserLocaleManager.getLanguageTag((Locale)locale);
        String string3 = this.getSearchPluginsJarURL(string2, string);
        InputStream inputStream = GeckoJarReader.getStream((String)string3);
        if (inputStream != null) {
            return inputStream;
        }
        String string4 = BrowserLocaleManager.getLanguage((Locale)locale);
        if (!string2.equals(string4) && (inputStream = GeckoJarReader.getStream((String)(string3 = this.getSearchPluginsJarURL(string4, string)))) != null) {
            return inputStream;
        }
        string3 = this.getSearchPluginsJarURL("en-US", string);
        return GeckoJarReader.getStream((String)string3);
    }

    private String getSearchPluginsJarURL(String string, String string2) {
        String string3 = "!/chrome/" + string + "/locale/" + string + "/browser/searchplugins/" + string2;
        return "jar:jar:file://" + this.context.getPackageResourcePath() + "!/" + "assets/omni.ja" + string3;
    }

    private InputStream getEngineFromProfile(String string) {
        File file = GeckoProfile.get((Context)this.context).getFile("searchplugins/" + string + ".xml");
        if (file.exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.e((String)LOG_TAG, (String)"Exception getting search engine from profile", (Throwable)fileNotFoundException);
            }
        }
        return null;
    }

    public static interface SearchEngineCallback {
        public void execute(SearchEngine var1);
    }
}

