/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.ReaderModeUtils;
import org.mozilla.gecko.SiteIdentity;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.ThumbnailHelper;
import org.mozilla.gecko.ZoomConstraints;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.db.URLMetadata;
import org.mozilla.gecko.gfx.Layer;
import org.mozilla.gecko.util.ThreadUtils;

public class Tab {
    private static final String LOGTAG = "GeckoTab";
    private static Pattern sColorPattern;
    private final int mId;
    private long mLastUsed;
    private String mUrl;
    private String mBaseDomain;
    private String mUserRequested;
    private String mTitle;
    private Bitmap mFavicon;
    private String mFaviconUrl;
    private int mFaviconSize;
    private boolean mHasFeeds;
    private boolean mHasOpenSearch;
    private SiteIdentity mSiteIdentity;
    private boolean mReaderEnabled;
    private BitmapDrawable mThumbnail;
    private int mHistoryIndex;
    private int mHistorySize;
    private int mParentId;
    private boolean mExternal;
    private boolean mBookmark;
    private int mFaviconLoadId;
    private String mContentType;
    private boolean mHasTouchListeners;
    private ZoomConstraints mZoomConstraints;
    private boolean mIsRTL;
    private ArrayList<View> mPluginViews;
    private HashMap<Object, Layer> mPluginLayers;
    private int mBackgroundColor;
    private int mState;
    private Bitmap mThumbnailBitmap;
    private boolean mDesktopMode;
    private boolean mEnteringReaderMode;
    private Context mAppContext;
    private ErrorType mErrorType = ErrorType.NONE;
    private static final int MAX_HISTORY_LIST_SIZE = 50;
    private volatile int mLoadProgress;
    private volatile int mRecordingCount;
    private String mMostRecentHomePanel;
    public static final int STATE_DELAYED = 0;
    public static final int STATE_LOADING = 1;
    public static final int STATE_SUCCESS = 2;
    public static final int STATE_ERROR = 3;
    public static final int LOAD_PROGRESS_INIT = 10;
    public static final int LOAD_PROGRESS_START = 20;
    public static final int LOAD_PROGRESS_LOCATION_CHANGE = 60;
    public static final int LOAD_PROGRESS_LOADED = 80;
    public static final int LOAD_PROGRESS_STOP = 100;
    private static final int DEFAULT_BACKGROUND_COLOR = -1;

    public Tab(Context context, int n, String string2, boolean bl, int n2, String string3) {
        this.mAppContext = context.getApplicationContext();
        this.mId = n;
        this.mUrl = string2;
        this.mBaseDomain = "";
        this.mUserRequested = "";
        this.mExternal = bl;
        this.mParentId = n2;
        this.mTitle = string3 == null ? "" : string3;
        this.mSiteIdentity = new SiteIdentity();
        this.mHistoryIndex = -1;
        this.mContentType = "";
        this.mZoomConstraints = new ZoomConstraints(false);
        this.mPluginViews = new ArrayList();
        this.mPluginLayers = new HashMap();
        this.mState = Tab.shouldShowProgress(string2) ? 1 : 2;
        this.mLoadProgress = 10;
        this.mBackgroundColor = -1;
        this.updateBookmark();
    }

    private ContentResolver getContentResolver() {
        return this.mAppContext.getContentResolver();
    }

    public void onDestroy() {
        Tabs.getInstance().notifyListeners(this, Tabs.TabEvents.CLOSED);
    }

    public int getId() {
        return this.mId;
    }

    public synchronized void onChange() {
        this.mLastUsed = System.currentTimeMillis();
    }

    public synchronized long getLastUsed() {
        return this.mLastUsed;
    }

    public int getParentId() {
        return this.mParentId;
    }

    public synchronized String getURL() {
        return this.mUrl;
    }

    public synchronized String getUserRequested() {
        return this.mUserRequested;
    }

    public synchronized String getTitle() {
        return this.mTitle;
    }

    public String getDisplayTitle() {
        if (this.mTitle != null && this.mTitle.length() > 0) {
            return this.mTitle;
        }
        return this.mUrl;
    }

    public String getBaseDomain() {
        return this.mBaseDomain;
    }

    public Bitmap getFavicon() {
        return this.mFavicon;
    }

    public BitmapDrawable getThumbnail() {
        return this.mThumbnail;
    }

    public String getMostRecentHomePanel() {
        return this.mMostRecentHomePanel;
    }

    public void setMostRecentHomePanel(String string2) {
        this.mMostRecentHomePanel = string2;
    }

    public Bitmap getThumbnailBitmap(int n, int n2) {
        if (this.mThumbnailBitmap != null) {
            boolean bl;
            boolean bl2 = Build.VERSION.SDK_INT >= 11 && Build.VERSION.SDK_INT <= 13;
            boolean bl3 = bl = this.mThumbnailBitmap.getWidth() != n || this.mThumbnailBitmap.getHeight() != n2;
            if (bl2 || bl) {
                this.mThumbnailBitmap = null;
            }
        }
        if (this.mThumbnailBitmap == null) {
            Bitmap.Config config = GeckoAppShell.getScreenDepth() == 24 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
            this.mThumbnailBitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)config);
        }
        return this.mThumbnailBitmap;
    }

    public void updateThumbnail(final Bitmap bitmap, final ThumbnailHelper.CachePolicy cachePolicy) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (bitmap != null) {
                        try {
                            Tab.this.mThumbnail = new BitmapDrawable(Tab.this.mAppContext.getResources(), bitmap);
                            if (Tab.this.mState == 2 && cachePolicy == ThumbnailHelper.CachePolicy.STORE) {
                                Tab.this.saveThumbnailToDB();
                                break block5;
                            }
                            Tab.this.clearThumbnailFromDB();
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            Log.w((String)Tab.LOGTAG, (String)"Unable to create/scale bitmap.", (Throwable)outOfMemoryError);
                            Tab.this.mThumbnail = null;
                        }
                    } else {
                        Tab.this.mThumbnail = null;
                    }
                }
                Tabs.getInstance().notifyListeners(Tab.this, Tabs.TabEvents.THUMBNAIL);
            }
        });
    }

    public synchronized String getFaviconURL() {
        return this.mFaviconUrl;
    }

    public boolean hasFeeds() {
        return this.mHasFeeds;
    }

    public boolean hasOpenSearch() {
        return this.mHasOpenSearch;
    }

    public SiteIdentity getSiteIdentity() {
        return this.mSiteIdentity;
    }

    public boolean getReaderEnabled() {
        return this.mReaderEnabled;
    }

    public boolean isBookmark() {
        return this.mBookmark;
    }

    public boolean isExternal() {
        return this.mExternal;
    }

    public synchronized void updateURL(String string2) {
        if (string2 != null && string2.length() > 0) {
            this.mUrl = string2;
        }
    }

    public synchronized void updateUserRequested(String string2) {
        this.mUserRequested = string2;
    }

    public void setErrorType(String string2) {
        if ("blocked".equals(string2)) {
            this.setErrorType(ErrorType.BLOCKED);
        } else if ("certerror".equals(string2)) {
            this.setErrorType(ErrorType.CERT_ERROR);
        } else if ("neterror".equals(string2)) {
            this.setErrorType(ErrorType.NET_ERROR);
        } else {
            this.setErrorType(ErrorType.NONE);
        }
    }

    public void setErrorType(ErrorType errorType) {
        this.mErrorType = errorType;
    }

    public void setMetadata(JSONObject jSONObject) {
        if (jSONObject == null) {
            return;
        }
        final ContentResolver contentResolver = this.mAppContext.getContentResolver();
        final Map<String, Object> map = URLMetadata.fromJSON(jSONObject);
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                URLMetadata.save(contentResolver, Tab.this.mUrl, map);
            }
        });
    }

    public ErrorType getErrorType() {
        return this.mErrorType;
    }

    public void setContentType(String string2) {
        this.mContentType = string2 == null ? "" : string2;
    }

    public String getContentType() {
        return this.mContentType;
    }

    public synchronized void updateTitle(String string2) {
        if (this.mEnteringReaderMode) {
            return;
        }
        if (this.mTitle != null && TextUtils.equals((CharSequence)this.mTitle, (CharSequence)string2)) {
            return;
        }
        this.mTitle = string2 == null ? "" : string2;
        Tabs.getInstance().notifyListeners(this, Tabs.TabEvents.TITLE);
    }

    public void setState(int n) {
        this.mState = n;
        if (this.mState != 1) {
            this.mEnteringReaderMode = false;
        }
    }

    public int getState() {
        return this.mState;
    }

    public void setZoomConstraints(ZoomConstraints zoomConstraints) {
        this.mZoomConstraints = zoomConstraints;
    }

    public ZoomConstraints getZoomConstraints() {
        return this.mZoomConstraints;
    }

    public void setIsRTL(boolean bl) {
        this.mIsRTL = bl;
    }

    public boolean getIsRTL() {
        return this.mIsRTL;
    }

    public void setHasTouchListeners(boolean bl) {
        this.mHasTouchListeners = bl;
    }

    public boolean getHasTouchListeners() {
        return this.mHasTouchListeners;
    }

    public void setFaviconLoadId(int n) {
        this.mFaviconLoadId = n;
    }

    public int getFaviconLoadId() {
        return this.mFaviconLoadId;
    }

    public boolean updateFavicon(Bitmap bitmap) {
        if (this.mFavicon == bitmap) {
            return false;
        }
        this.mFavicon = bitmap;
        return true;
    }

    public synchronized void updateFaviconURL(String string2, int n) {
        if (this.mFaviconSize == -1) {
            return;
        }
        if (n == -1 || n >= this.mFaviconSize) {
            this.mFaviconUrl = string2;
            this.mFaviconSize = n;
        }
    }

    public synchronized void clearFavicon() {
        if (this.mEnteringReaderMode) {
            return;
        }
        this.mFavicon = null;
        this.mFaviconUrl = null;
        this.mFaviconSize = 0;
    }

    public void setHasFeeds(boolean bl) {
        this.mHasFeeds = bl;
    }

    public void setHasOpenSearch(boolean bl) {
        this.mHasOpenSearch = bl;
    }

    public void updateIdentityData(JSONObject jSONObject) {
        this.mSiteIdentity.update(jSONObject);
    }

    public void setReaderEnabled(boolean bl) {
        this.mReaderEnabled = bl;
        Tabs.getInstance().notifyListeners(this, Tabs.TabEvents.MENU_UPDATED);
    }

    void updateBookmark() {
        if (this.getURL() == null) {
            return;
        }
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                String string2 = Tab.this.getURL();
                if (string2 == null) {
                    return;
                }
                Tab.this.mBookmark = BrowserDB.isBookmark(Tab.this.getContentResolver(), string2);
                Tabs.getInstance().notifyListeners(Tab.this, Tabs.TabEvents.MENU_UPDATED);
            }
        });
    }

    public void addBookmark() {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                String string2 = Tab.this.getURL();
                if (string2 == null) {
                    return;
                }
                BrowserDB.addBookmark(Tab.this.getContentResolver(), Tab.this.mTitle, string2);
                Tabs.getInstance().notifyListeners(Tab.this, Tabs.TabEvents.BOOKMARK_ADDED);
            }
        });
    }

    public void removeBookmark() {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                String string2 = Tab.this.getURL();
                if (string2 == null) {
                    return;
                }
                BrowserDB.removeBookmarksWithURL(Tab.this.getContentResolver(), string2);
                Tabs.getInstance().notifyListeners(Tab.this, Tabs.TabEvents.BOOKMARK_REMOVED);
            }
        });
    }

    public void addToReadingList() {
        if (!this.mReaderEnabled) {
            return;
        }
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("tabID", (Object)String.valueOf(this.getId()));
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"JSON error - failing to add to reading list", (Throwable)jSONException);
            return;
        }
        GeckoEvent geckoEvent = GeckoEvent.createBroadcastEvent("Reader:Add", jSONObject.toString());
        GeckoAppShell.sendEventToGecko(geckoEvent);
    }

    public void toggleReaderMode() {
        if (AboutPages.isAboutReader(this.mUrl)) {
            Tabs.getInstance().loadUrl(ReaderModeUtils.getUrlFromAboutReader(this.mUrl));
        } else if (this.mReaderEnabled) {
            this.mEnteringReaderMode = true;
            Tabs.getInstance().loadUrl(ReaderModeUtils.getAboutReaderForUrl(this.mUrl, this.mId));
        }
    }

    public boolean isEnteringReaderMode() {
        return this.mEnteringReaderMode;
    }

    public void doReload() {
        GeckoEvent geckoEvent = GeckoEvent.createBroadcastEvent("Session:Reload", "");
        GeckoAppShell.sendEventToGecko(geckoEvent);
    }

    public boolean canDoBack() {
        return this.mHistoryIndex > 0;
    }

    public boolean doBack() {
        if (!this.canDoBack()) {
            return false;
        }
        GeckoEvent geckoEvent = GeckoEvent.createBroadcastEvent("Session:Back", "");
        GeckoAppShell.sendEventToGecko(geckoEvent);
        return true;
    }

    public boolean showBackHistory() {
        if (!this.canDoBack()) {
            return false;
        }
        return this.showHistory(Math.max(this.mHistoryIndex - 50, 0), this.mHistoryIndex, this.mHistoryIndex);
    }

    public boolean showForwardHistory() {
        if (!this.canDoForward()) {
            return false;
        }
        return this.showHistory(this.mHistoryIndex, Math.min(this.mHistorySize - 1, this.mHistoryIndex + 50), this.mHistoryIndex);
    }

    public boolean showAllHistory() {
        if (!this.canDoForward() && !this.canDoBack()) {
            return false;
        }
        int n = this.mHistoryIndex - 25;
        int n2 = this.mHistoryIndex + 25;
        if (n < 0) {
            n2 -= n;
        }
        if (n2 > this.mHistorySize - 1) {
            n -= n2 - (this.mHistorySize - 1);
            n2 = this.mHistorySize - 1;
        }
        n = Math.max(n, 0);
        return this.showHistory(n, n2, this.mHistoryIndex);
    }

    public boolean showHistory(int n, int n2, int n3) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("fromIndex", n);
            jSONObject.put("toIndex", n2);
            jSONObject.put("selIndex", n3);
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"JSON error", (Throwable)jSONException);
        }
        GeckoEvent geckoEvent = GeckoEvent.createBroadcastEvent("Session:ShowHistory", jSONObject.toString());
        GeckoAppShell.sendEventToGecko(geckoEvent);
        return true;
    }

    public void doStop() {
        GeckoEvent geckoEvent = GeckoEvent.createBroadcastEvent("Session:Stop", "");
        GeckoAppShell.sendEventToGecko(geckoEvent);
    }

    public boolean canDoForward() {
        return this.mHistoryIndex < this.mHistorySize - 1;
    }

    public boolean doForward() {
        if (!this.canDoForward()) {
            return false;
        }
        GeckoEvent geckoEvent = GeckoEvent.createBroadcastEvent("Session:Forward", "");
        GeckoAppShell.sendEventToGecko(geckoEvent);
        return true;
    }

    void handleSessionHistoryMessage(String string2, JSONObject jSONObject) throws JSONException {
        if (string2.equals("New")) {
            String string3 = jSONObject.getString("url");
            ++this.mHistoryIndex;
            this.mHistorySize = this.mHistoryIndex + 1;
        } else if (string2.equals("Back")) {
            if (!this.canDoBack()) {
                Log.w((String)LOGTAG, (String)"Received unexpected back notification");
                return;
            }
            --this.mHistoryIndex;
        } else if (string2.equals("Forward")) {
            if (!this.canDoForward()) {
                Log.w((String)LOGTAG, (String)"Received unexpected forward notification");
                return;
            }
            ++this.mHistoryIndex;
        } else if (string2.equals("Goto")) {
            int n = jSONObject.getInt("index");
            if (n < 0 || n >= this.mHistorySize) {
                Log.w((String)LOGTAG, (String)"Received unexpected history-goto notification");
                return;
            }
            this.mHistoryIndex = n;
        } else if (string2.equals("Purge")) {
            int n = jSONObject.getInt("numEntries");
            if (n > this.mHistorySize) {
                Log.w((String)LOGTAG, (String)"Received unexpectedly large number of history entries to purge");
                this.mHistoryIndex = -1;
                this.mHistorySize = 0;
                return;
            }
            this.mHistorySize -= n;
            this.mHistoryIndex -= n;
            if (this.mHistoryIndex < -1) {
                this.mHistoryIndex = -1;
            }
        }
    }

    void handleLocationChange(JSONObject jSONObject) throws JSONException {
        String string2 = jSONObject.getString("uri");
        String string3 = this.getURL();
        boolean bl = jSONObject.getBoolean("sameDocument");
        this.mEnteringReaderMode = ReaderModeUtils.isEnteringReaderMode(string3, string2);
        if (!TextUtils.equals((CharSequence)string3, (CharSequence)string2)) {
            this.updateURL(string2);
            this.updateBookmark();
            if (!bl) {
                this.clearFavicon();
                this.updateTitle(null);
            }
        }
        if (bl) {
            Tabs.getInstance().notifyListeners(this, Tabs.TabEvents.LOCATION_CHANGE, string3);
            return;
        }
        this.setContentType(jSONObject.getString("contentType"));
        this.updateUserRequested(jSONObject.getString("userRequested"));
        this.mBaseDomain = jSONObject.optString("baseDomain");
        this.setHasFeeds(false);
        this.setHasOpenSearch(false);
        this.updateIdentityData(null);
        this.setReaderEnabled(false);
        this.setZoomConstraints(new ZoomConstraints(true));
        this.setHasTouchListeners(false);
        this.setBackgroundColor(-1);
        this.setErrorType(ErrorType.NONE);
        this.setLoadProgressIfLoading(60);
        Tabs.getInstance().notifyListeners(this, Tabs.TabEvents.LOCATION_CHANGE, string3);
    }

    private static boolean shouldShowProgress(String string2) {
        return !AboutPages.isAboutPage(string2);
    }

    void handleDocumentStart(boolean bl, String string2) {
        this.setLoadProgress(20);
        this.setState(!bl && Tab.shouldShowProgress(string2) ? 1 : 2);
        this.updateIdentityData(null);
        this.setReaderEnabled(false);
    }

    void handleDocumentStop(boolean bl) {
        this.setState(bl ? 2 : 3);
        final String string2 = this.getURL();
        final Tab tab = this;
        tab.setLoadProgress(100);
        ThreadUtils.getBackgroundHandler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (!TextUtils.equals((CharSequence)string2, (CharSequence)Tab.this.getURL())) {
                    return;
                }
                ThumbnailHelper.getInstance().getAndProcessThumbnailFor(tab);
            }
        }, 500L);
    }

    void handleContentLoaded() {
        this.setLoadProgressIfLoading(80);
    }

    protected void saveThumbnailToDB() {
        BitmapDrawable bitmapDrawable = this.mThumbnail;
        if (bitmapDrawable == null) {
            return;
        }
        try {
            String string2 = this.getURL();
            if (string2 == null) {
                return;
            }
            BrowserDB.updateThumbnailForUrl(this.getContentResolver(), string2, bitmapDrawable);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void clearThumbnailFromDB() {
        try {
            String string2 = this.getURL();
            if (string2 == null) {
                return;
            }
            BrowserDB.updateThumbnailForUrl(this.getContentResolver(), string2, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addPluginView(View view) {
        this.mPluginViews.add(view);
    }

    public void removePluginView(View view) {
        this.mPluginViews.remove(view);
    }

    public View[] getPluginViews() {
        return this.mPluginViews.toArray(new View[this.mPluginViews.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPluginLayer(Object object, Layer layer) {
        HashMap<Object, Layer> hashMap = this.mPluginLayers;
        synchronized (hashMap) {
            this.mPluginLayers.put(object, layer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer getPluginLayer(Object object) {
        HashMap<Object, Layer> hashMap = this.mPluginLayers;
        synchronized (hashMap) {
            return this.mPluginLayers.get(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Layer> getPluginLayers() {
        HashMap<Object, Layer> hashMap = this.mPluginLayers;
        synchronized (hashMap) {
            return new ArrayList<Layer>(this.mPluginLayers.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer removePluginLayer(Object object) {
        HashMap<Object, Layer> hashMap = this.mPluginLayers;
        synchronized (hashMap) {
            return this.mPluginLayers.remove(object);
        }
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public void setBackgroundColor(int n) {
        this.mBackgroundColor = n;
    }

    public void setBackgroundColor(String string2) {
        this.setBackgroundColor(Tab.parseColorFromGecko(string2));
    }

    private static int parseColorFromGecko(String string2) {
        Matcher matcher;
        if (sColorPattern == null) {
            sColorPattern = Pattern.compile("rgb\\((\\d+),\\s*(\\d+),\\s*(\\d+)\\)");
        }
        if (!(matcher = sColorPattern.matcher(string2)).matches()) {
            return -1;
        }
        int n = Integer.parseInt(matcher.group(1));
        int n2 = Integer.parseInt(matcher.group(2));
        int n3 = Integer.parseInt(matcher.group(3));
        return Color.rgb((int)n, (int)n2, (int)n3);
    }

    public void setDesktopMode(boolean bl) {
        this.mDesktopMode = bl;
    }

    public boolean getDesktopMode() {
        return this.mDesktopMode;
    }

    public boolean isPrivate() {
        return false;
    }

    void setLoadProgress(int n) {
        this.mLoadProgress = n;
    }

    void setLoadProgressIfLoading(int n) {
        if (this.getState() == 1) {
            this.setLoadProgress(n);
        }
    }

    public int getLoadProgress() {
        return this.mLoadProgress;
    }

    public void setRecording(boolean bl) {
        this.mRecordingCount = bl ? ++this.mRecordingCount : --this.mRecordingCount;
    }

    public boolean isRecording() {
        return this.mRecordingCount > 0;
    }

    public static enum ErrorType {
        CERT_ERROR,
        BLOCKED,
        NET_ERROR,
        NONE;

    }
}

