/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.client.cache;

import ch.boye.httpclientandroidlib.annotation.ThreadSafe;
import ch.boye.httpclientandroidlib.client.cache.HttpCacheEntry;
import ch.boye.httpclientandroidlib.client.cache.HttpCacheStorage;
import ch.boye.httpclientandroidlib.client.cache.HttpCacheUpdateCallback;
import ch.boye.httpclientandroidlib.impl.client.cache.CacheConfig;
import ch.boye.httpclientandroidlib.impl.client.cache.CacheMap;
import java.io.IOException;

@ThreadSafe
public class BasicHttpCacheStorage
implements HttpCacheStorage {
    private final CacheMap entries;

    public BasicHttpCacheStorage(CacheConfig cacheConfig) {
        this.entries = new CacheMap(cacheConfig.getMaxCacheEntries());
    }

    @Override
    public synchronized void putEntry(String string, HttpCacheEntry httpCacheEntry) throws IOException {
        this.entries.put(string, httpCacheEntry);
    }

    @Override
    public synchronized HttpCacheEntry getEntry(String string) throws IOException {
        return (HttpCacheEntry)this.entries.get(string);
    }

    @Override
    public synchronized void removeEntry(String string) throws IOException {
        this.entries.remove(string);
    }

    @Override
    public synchronized void updateEntry(String string, HttpCacheUpdateCallback httpCacheUpdateCallback) throws IOException {
        HttpCacheEntry httpCacheEntry = (HttpCacheEntry)this.entries.get(string);
        this.entries.put(string, httpCacheUpdateCallback.update(httpCacheEntry));
    }
}

