/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.graphics.PointF;
import android.graphics.RectF;
import android.view.MotionEvent;
import android.view.animation.DecelerateInterpolator;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.PrefsHelper;
import org.mozilla.gecko.gfx.GeckoLayerClient;
import org.mozilla.gecko.gfx.ImmutableViewportMetrics;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.gfx.RenderTask;
import org.mozilla.gecko.util.FloatUtils;
import org.mozilla.gecko.util.ThreadUtils;

public class LayerMarginsAnimator {
    private static final String LOGTAG = "GeckoLayerMarginsAnimator";
    private static final long MARGIN_ANIMATION_DURATION = 250000000L;
    private static final String PREF_SHOW_MARGINS_THRESHOLD = "browser.ui.show-margins-threshold";
    private float SHOW_MARGINS_THRESHOLD = 0.2f;
    private final RectF mMaxMargins;
    private boolean mMarginsPinned;
    private LayerMarginsAnimationTask mAnimationTask;
    private final DecelerateInterpolator mInterpolator;
    private final GeckoLayerClient mTarget;
    private final PointF mTouchTravelDistance;
    private Integer mPrefObserverId;

    public LayerMarginsAnimator(GeckoLayerClient geckoLayerClient, LayerView layerView) {
        this.mTarget = geckoLayerClient;
        this.mMaxMargins = new RectF();
        this.mInterpolator = new DecelerateInterpolator();
        this.mTouchTravelDistance = new PointF();
        this.mPrefObserverId = PrefsHelper.getPref(PREF_SHOW_MARGINS_THRESHOLD, new PrefsHelper.PrefHandlerBase(){

            @Override
            public void prefValue(String string2, int n) {
                LayerMarginsAnimator.this.SHOW_MARGINS_THRESHOLD = (float)n / 100.0f;
            }

            @Override
            public boolean isObserver() {
                return true;
            }
        });
    }

    public void destroy() {
        if (this.mPrefObserverId != null) {
            PrefsHelper.removeObserver(this.mPrefObserverId);
            this.mPrefObserverId = null;
        }
    }

    public synchronized void setMaxMargins(float f, float f2, float f3, float f4) {
        ThreadUtils.assertOnUiThread();
        this.mMaxMargins.set(f, f2, f3, f4);
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Viewport:FixedMarginsChanged", "{ \"top\" : " + f2 + ", \"right\" : " + f3 + ", \"bottom\" : " + f4 + ", \"left\" : " + f + " }"));
    }

    RectF getMaxMargins() {
        return this.mMaxMargins;
    }

    private void animateMargins(float f, float f2, float f3, float f4, boolean bl) {
        if (this.mAnimationTask != null) {
            this.mTarget.getView().removeRenderTask(this.mAnimationTask);
            this.mAnimationTask = null;
        }
        if (bl) {
            ImmutableViewportMetrics immutableViewportMetrics = this.mTarget.getViewportMetrics().setMargins(f, f2, f3, f4);
            this.mTarget.forceViewportMetrics(immutableViewportMetrics, true, true);
            return;
        }
        ImmutableViewportMetrics immutableViewportMetrics = this.mTarget.getViewportMetrics();
        this.mAnimationTask = new LayerMarginsAnimationTask(false, immutableViewportMetrics, f, f2, f3, f4);
        this.mTarget.getView().postRenderTask(this.mAnimationTask);
    }

    public synchronized void showMargins(boolean bl) {
        this.animateMargins(this.mMaxMargins.left, this.mMaxMargins.top, this.mMaxMargins.right, this.mMaxMargins.bottom, bl);
    }

    public synchronized void hideMargins(boolean bl) {
        this.animateMargins(0.0f, 0.0f, 0.0f, 0.0f, bl);
    }

    public void setMarginsPinned(boolean bl) {
        if (bl == this.mMarginsPinned) {
            return;
        }
        this.mMarginsPinned = bl;
    }

    public boolean areMarginsShown() {
        ImmutableViewportMetrics immutableViewportMetrics = this.mTarget.getViewportMetrics();
        return immutableViewportMetrics.marginLeft != 0.0f || immutableViewportMetrics.marginRight != 0.0f || immutableViewportMetrics.marginTop != 0.0f || immutableViewportMetrics.marginBottom != 0.0f;
    }

    private float scrollMargin(float[] fArray, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, boolean bl) {
        float f11 = fArray[0];
        float f12 = fArray[1];
        float f13 = f6 - f5;
        float f14 = f13 * this.SHOW_MARGINS_THRESHOLD;
        if (f >= 0.0f) {
            float f15 = Math.max(0.0f, f - f2);
            fArray[0] = f11 - Math.min(f15, f11);
            if (f4 < f14 && f12 == 0.0f) {
                f15 = Math.max(0.0f, f15 - (f8 - f6));
            }
            fArray[1] = f12 + Math.min(f15, f10 - f12);
        } else {
            float f16 = Math.max(0.0f, -f - f3);
            fArray[1] = f12 - Math.min(f16, f12);
            if (-f4 < f14 && f11 == 0.0f) {
                f16 = Math.max(0.0f, f16 - (f5 - f7));
            }
            fArray[0] = f11 + Math.min(f16, f9 - f11);
        }
        if (bl) {
            return f - (f12 - fArray[1]);
        }
        return f - (f11 - fArray[0]);
    }

    ImmutableViewportMetrics scrollBy(ImmutableViewportMetrics immutableViewportMetrics, float f, float f2) {
        float[] fArray = new float[]{immutableViewportMetrics.marginLeft, immutableViewportMetrics.marginRight};
        float[] fArray2 = new float[]{immutableViewportMetrics.marginTop, immutableViewportMetrics.marginBottom};
        if (!this.mMarginsPinned) {
            if (this.mAnimationTask != null) {
                this.mTarget.getView().removeRenderTask(this.mAnimationTask);
                this.mAnimationTask = null;
            }
            if (f >= 0.0f != this.mTouchTravelDistance.x >= 0.0f) {
                this.mTouchTravelDistance.x = 0.0f;
            }
            if (f2 >= 0.0f != this.mTouchTravelDistance.y >= 0.0f) {
                this.mTouchTravelDistance.y = 0.0f;
            }
            this.mTouchTravelDistance.offset(f, f2);
            RectF rectF = immutableViewportMetrics.getOverscroll();
            if (immutableViewportMetrics.getPageWidth() >= immutableViewportMetrics.getWidth()) {
                f = this.scrollMargin(fArray, f, rectF.left, rectF.right, this.mTouchTravelDistance.x, immutableViewportMetrics.viewportRectLeft, immutableViewportMetrics.viewportRectRight, immutableViewportMetrics.pageRectLeft, immutableViewportMetrics.pageRectRight, this.mMaxMargins.left, this.mMaxMargins.right, immutableViewportMetrics.isRTL);
            }
            if (immutableViewportMetrics.getPageHeight() >= immutableViewportMetrics.getHeight()) {
                f2 = this.scrollMargin(fArray2, f2, rectF.top, rectF.bottom, this.mTouchTravelDistance.y, immutableViewportMetrics.viewportRectTop, immutableViewportMetrics.viewportRectBottom, immutableViewportMetrics.pageRectTop, immutableViewportMetrics.pageRectBottom, this.mMaxMargins.top, this.mMaxMargins.bottom, false);
            }
        }
        return immutableViewportMetrics.setMargins(fArray[0], fArray2[0], fArray[1], fArray2[1]).offsetViewportBy(f, f2);
    }

    boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getActionMasked();
        if (n == 0 && motionEvent.getPointerCount() == 1) {
            this.mTouchTravelDistance.set(0.0f, 0.0f);
        }
        return false;
    }

    class LayerMarginsAnimationTask
    extends RenderTask {
        private float mStartLeft;
        private float mStartTop;
        private float mStartRight;
        private float mStartBottom;
        private float mTop;
        private float mBottom;
        private float mLeft;
        private float mRight;
        private boolean mContinueAnimation;

        public LayerMarginsAnimationTask(boolean bl, ImmutableViewportMetrics immutableViewportMetrics, float f, float f2, float f3, float f4) {
            super(bl);
            this.mContinueAnimation = true;
            this.mStartLeft = immutableViewportMetrics.marginLeft;
            this.mStartTop = immutableViewportMetrics.marginTop;
            this.mStartRight = immutableViewportMetrics.marginRight;
            this.mStartBottom = immutableViewportMetrics.marginBottom;
            this.mLeft = f;
            this.mRight = f3;
            this.mTop = f2;
            this.mBottom = f4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean internalRun(long l, long l2) {
            if (!this.mContinueAnimation) {
                return false;
            }
            float f = LayerMarginsAnimator.this.mInterpolator.getInterpolation(Math.min(1.0f, (float)(System.nanoTime() - this.getStartTime()) / 2.5E8f));
            Object object = LayerMarginsAnimator.this.mTarget.getLock();
            synchronized (object) {
                ImmutableViewportMetrics immutableViewportMetrics = LayerMarginsAnimator.this.mTarget.getViewportMetrics();
                ImmutableViewportMetrics immutableViewportMetrics2 = immutableViewportMetrics.setMargins(FloatUtils.interpolate((float)this.mStartLeft, (float)this.mLeft, (float)f), FloatUtils.interpolate((float)this.mStartTop, (float)this.mTop, (float)f), FloatUtils.interpolate((float)this.mStartRight, (float)this.mRight, (float)f), FloatUtils.interpolate((float)this.mStartBottom, (float)this.mBottom, (float)f));
                PointF pointF = immutableViewportMetrics.getMarginOffset();
                PointF pointF2 = immutableViewportMetrics2.getMarginOffset();
                immutableViewportMetrics2 = immutableViewportMetrics2.offsetViewportByAndClamp(pointF2.x - pointF.x, pointF2.y - pointF.y);
                if (f >= 1.0f) {
                    this.mContinueAnimation = false;
                    LayerMarginsAnimator.this.mTarget.forceViewportMetrics(immutableViewportMetrics2, true, true);
                } else {
                    LayerMarginsAnimator.this.mTarget.forceViewportMetrics(immutableViewportMetrics2, false, false);
                }
            }
            return this.mContinueAnimation;
        }
    }
}

