/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.overlays.ui;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import org.mozilla.gecko.Assert;
import org.mozilla.gecko.LocaleAware;
import org.mozilla.gecko.R;
import org.mozilla.gecko.db.LocalBrowserDB;
import org.mozilla.gecko.overlays.service.OverlayActionService;
import org.mozilla.gecko.overlays.service.sharemethods.ParcelableClientRecord;
import org.mozilla.gecko.overlays.service.sharemethods.ShareMethod;
import org.mozilla.gecko.overlays.ui.OverlayDialogButton;
import org.mozilla.gecko.overlays.ui.SendTabDeviceListArrayAdapter;
import org.mozilla.gecko.overlays.ui.SendTabList;
import org.mozilla.gecko.overlays.ui.SendTabTargetSelectedListener;
import org.mozilla.gecko.sync.setup.activities.WebURLFinder;
import org.mozilla.gecko.util.HardwareUtils;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.util.UIAsyncTask;

public class ShareDialog
extends LocaleAware.LocaleAwareActivity
implements SendTabTargetSelectedListener {
    private static final String LOGTAG = "GeckoShareDialog";
    private String url;
    private String title;
    private Intent sendTabOverrideIntent;
    private boolean isAnimating;
    private final BroadcastReceiver uiEventListener = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            ShareMethod.Type type = (ShareMethod.Type)intent.getParcelableExtra("SHARE_METHOD");
            switch (type) {
                case SEND_TAB: {
                    ShareDialog.this.handleSendTabUIEvent(intent);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("UIEvent broadcast from ShareMethod that isn't thought to support such broadcasts.");
                }
            }
        }
    };

    protected void handleSendTabUIEvent(Intent intent) {
        this.sendTabOverrideIntent = (Intent)intent.getParcelableExtra("OVERRIDE_INTENT");
        SendTabList sendTabList = (SendTabList)this.findViewById(R.id.overlay_send_tab_btn);
        ParcelableClientRecord[] parcelableClientRecordArray = (ParcelableClientRecord[])intent.getParcelableArrayExtra("RECORDS");
        sendTabList.setSyncClients(parcelableClientRecordArray);
    }

    protected void onDestroy() {
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.uiEventListener);
        super.onDestroy();
    }

    private void abortDueToNoURL() {
        Log.e((String)LOGTAG, (String)"Unable to process shared intent. No URL found!");
        Toast toast = Toast.makeText((Context)this, (CharSequence)this.getResources().getText(R.string.overlay_share_no_url), (int)0);
        toast.show();
        this.finish();
    }

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.getWindow().setWindowAnimations(0);
        Intent intent = this.getIntent();
        Resources resources = this.getResources();
        String string2 = intent.getStringExtra("android.intent.extra.TEXT");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.abortDueToNoURL();
            return;
        }
        String string3 = new WebURLFinder(string2).bestWebURL();
        if (TextUtils.isEmpty((CharSequence)string3)) {
            this.abortDueToNoURL();
            return;
        }
        this.setContentView(R.layout.overlay_share_dialog);
        LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.uiEventListener, new IntentFilter("org.mozilla.gecko.overlays.ACTION_SHARE_METHOD_UI_EVENT"));
        Intent intent2 = new Intent((Context)this, OverlayActionService.class);
        intent2.setAction("org.mozilla.gecko.overlays.ACTION_PREPARE_SHARE");
        this.startService(intent2);
        String string4 = intent.getStringExtra("android.intent.extra.SUBJECT");
        if (string4 != null) {
            ((TextView)this.findViewById(R.id.title)).setText((CharSequence)string4);
        }
        this.title = string4;
        this.url = string3;
        TextView textView = (TextView)this.findViewById(R.id.subtitle);
        textView.setText((CharSequence)string3);
        textView.setEllipsize(TextUtils.TruncateAt.MARQUEE);
        textView.setSingleLine(true);
        textView.setMarqueeRepeatLimit(5);
        textView.setSelected(true);
        Animation animation = AnimationUtils.loadAnimation((Context)this, (int)R.anim.overlay_slide_up);
        this.findViewById(R.id.sharedialog).startAnimation(animation);
        OverlayDialogButton overlayDialogButton = (OverlayDialogButton)this.findViewById(R.id.overlay_share_bookmark_btn);
        String string5 = resources.getString(R.string.overlay_share_bookmark_btn_label);
        Drawable drawable2 = resources.getDrawable(R.drawable.overlay_bookmark_icon);
        overlayDialogButton.setEnabledLabelAndIcon(string5, drawable2);
        String string6 = resources.getString(R.string.overlay_share_bookmark_btn_label_already);
        Drawable drawable3 = resources.getDrawable(R.drawable.overlay_bookmarked_already_icon);
        overlayDialogButton.setDisabledLabelAndIcon(string6, drawable3);
        overlayDialogButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ShareDialog.this.addBookmark();
            }
        });
        SendTabList sendTabList = (SendTabList)this.findViewById(R.id.overlay_send_tab_btn);
        SendTabDeviceListArrayAdapter sendTabDeviceListArrayAdapter = new SendTabDeviceListArrayAdapter((Context)this, this);
        sendTabList.setAdapter((ListAdapter)sendTabDeviceListArrayAdapter);
        sendTabList.setSendTabTargetSelectedListener(this);
        OverlayDialogButton overlayDialogButton2 = (OverlayDialogButton)this.findViewById(R.id.overlay_share_reading_list_btn);
        if (HardwareUtils.isLowMemoryPlatform()) {
            overlayDialogButton2.setVisibility(8);
            return;
        }
        String string7 = resources.getString(R.string.overlay_share_reading_list_btn_label);
        Drawable drawable4 = resources.getDrawable(R.drawable.overlay_readinglist_icon);
        overlayDialogButton2.setEnabledLabelAndIcon(string7, drawable4);
        String string8 = resources.getString(R.string.overlay_share_reading_list_btn_label_already);
        Drawable drawable5 = resources.getDrawable(R.drawable.overlay_readinglist_already_icon);
        overlayDialogButton2.setDisabledLabelAndIcon(string8, drawable5);
        overlayDialogButton2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ShareDialog.this.addToReadingList();
            }
        });
    }

    protected void onResume() {
        super.onResume();
        LocalBrowserDB localBrowserDB = new LocalBrowserDB(this.getCurrentProfile());
        this.disableButtonsIfAlreadyAdded(this.url, localBrowserDB);
    }

    private void disableButtonsIfAlreadyAdded(final String string2, final LocalBrowserDB localBrowserDB) {
        new UIAsyncTask.WithoutParams<Void>(ThreadUtils.getBackgroundHandler()){
            boolean isBookmark;
            boolean isReadingListItem;

            protected Void doInBackground() {
                ContentResolver contentResolver = ShareDialog.this.getApplicationContext().getContentResolver();
                this.isBookmark = localBrowserDB.isBookmark(contentResolver, string2);
                this.isReadingListItem = localBrowserDB.isReadingListItem(contentResolver, string2);
                return null;
            }

            protected void onPostExecute(Void void_) {
                ShareDialog.this.findViewById(R.id.overlay_share_bookmark_btn).setEnabled(!this.isBookmark);
                ShareDialog.this.findViewById(R.id.overlay_share_reading_list_btn).setEnabled(!this.isReadingListItem);
            }
        }.execute();
    }

    private Intent getServiceIntent(ShareMethod.Type type) {
        Intent intent = new Intent((Context)this, OverlayActionService.class);
        intent.setAction("org.mozilla.gecko.overlays.ACTION_SHARE");
        intent.putExtra("SHARE_METHOD", (Parcelable)type);
        intent.putExtra("URL", this.url);
        intent.putExtra("TITLE", this.title);
        return intent;
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(0, 0);
    }

    public void sendTab(String string2) {
        if (this.sendTabOverrideIntent != null) {
            this.startActivity(this.sendTabOverrideIntent);
            this.finish();
            return;
        }
        Assert.isTrue(string2 != null);
        Intent intent = this.getServiceIntent(ShareMethod.Type.SEND_TAB);
        Bundle bundle = new Bundle();
        bundle.putStringArray("SEND_TAB_TARGET_DEVICES", new String[]{string2});
        intent.putExtra("EXTRA", bundle);
        this.startService(intent);
        this.slideOut();
    }

    @Override
    public void onSendTabTargetSelected(String string2) {
        this.sendTab(string2);
    }

    public void addToReadingList() {
        this.startService(this.getServiceIntent(ShareMethod.Type.ADD_TO_READING_LIST));
        this.slideOut();
    }

    public void addBookmark() {
        this.startService(this.getServiceIntent(ShareMethod.Type.ADD_BOOKMARK));
        this.slideOut();
    }

    private String getCurrentProfile() {
        return "default";
    }

    private void slideOut() {
        if (this.isAnimating) {
            return;
        }
        this.isAnimating = true;
        Animation animation = AnimationUtils.loadAnimation((Context)this, (int)R.anim.overlay_slide_down);
        this.findViewById(R.id.sharedialog).startAnimation(animation);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                ShareDialog.this.finish();
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
    }

    public void onBackPressed() {
        this.slideOut();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        this.slideOut();
        return true;
    }
}

