/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.client.protocol;

import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.HttpEntityEnclosingRequest;
import ch.boye.httpclientandroidlib.HttpException;
import ch.boye.httpclientandroidlib.HttpRequest;
import ch.boye.httpclientandroidlib.HttpRequestInterceptor;
import ch.boye.httpclientandroidlib.HttpVersion;
import ch.boye.httpclientandroidlib.ProtocolVersion;
import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.client.config.RequestConfig;
import ch.boye.httpclientandroidlib.client.protocol.HttpClientContext;
import ch.boye.httpclientandroidlib.protocol.HttpContext;
import ch.boye.httpclientandroidlib.util.Args;
import java.io.IOException;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        Args.notNull(httpRequest, "HTTP request");
        if (!httpRequest.containsHeader("Expect") && httpRequest instanceof HttpEntityEnclosingRequest) {
            HttpClientContext httpClientContext;
            RequestConfig requestConfig;
            ProtocolVersion protocolVersion = httpRequest.getRequestLine().getProtocolVersion();
            HttpEntity httpEntity = ((HttpEntityEnclosingRequest)httpRequest).getEntity();
            if (httpEntity != null && httpEntity.getContentLength() != 0L && !protocolVersion.lessEquals(HttpVersion.HTTP_1_0) && (requestConfig = (httpClientContext = HttpClientContext.adapt(httpContext)).getRequestConfig()).isExpectContinueEnabled()) {
                httpRequest.addHeader("Expect", "100-continue");
            }
        }
    }
}

