/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.animation;

import android.graphics.Matrix;
import android.graphics.RectF;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Transformation;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import org.mozilla.gecko.AppConstants;

class AnimatorProxy {
    private static final WeakHashMap<View, AnimatorProxy> PROXIES = new WeakHashMap();
    private AnimatorProxyImpl mImpl;

    private AnimatorProxy(AnimatorProxyImpl animatorProxyImpl) {
        this.mImpl = animatorProxyImpl;
    }

    public static AnimatorProxy create(View view) {
        AnimatorProxy animatorProxy = PROXIES.get(view);
        boolean bl = AppConstants.Versions.preHC;
        if (animatorProxy == null || bl && animatorProxy.mImpl != view.getAnimation()) {
            AnimatorProxyImpl animatorProxyImpl = bl ? new AnimatorProxyPreHC(view) : new AnimatorProxyPostHC(view);
            animatorProxy = new AnimatorProxy(animatorProxyImpl);
            PROXIES.put(view, animatorProxy);
        }
        return animatorProxy;
    }

    public int getWidth() {
        View view = this.mImpl.getView();
        if (view != null) {
            return view.getWidth();
        }
        return 0;
    }

    public void setWidth(int n) {
        View view = this.mImpl.getView();
        if (view != null) {
            ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
            layoutParams.width = n;
            view.setLayoutParams(layoutParams);
        }
    }

    public int getHeight() {
        View view = this.mImpl.getView();
        if (view != null) {
            return view.getHeight();
        }
        return 0;
    }

    public void setHeight(int n) {
        View view = this.mImpl.getView();
        if (view != null) {
            ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
            layoutParams.height = n;
            view.setLayoutParams(layoutParams);
        }
    }

    public int getScrollX() {
        View view = this.mImpl.getView();
        if (view != null) {
            return view.getScrollX();
        }
        return 0;
    }

    public int getScrollY() {
        View view = this.mImpl.getView();
        if (view != null) {
            return view.getScrollY();
        }
        return 0;
    }

    public void scrollTo(int n, int n2) {
        View view = this.mImpl.getView();
        if (view != null) {
            view.scrollTo(n, n2);
        }
    }

    public float getAlpha() {
        return this.mImpl.getAlpha();
    }

    public void setAlpha(float f) {
        this.mImpl.setAlpha(f);
    }

    public float getTranslationX() {
        return this.mImpl.getTranslationX();
    }

    public void setTranslationX(float f) {
        this.mImpl.setTranslationX(f);
    }

    public float getTranslationY() {
        return this.mImpl.getTranslationY();
    }

    public void setTranslationY(float f) {
        this.mImpl.setTranslationY(f);
    }

    private static class AnimatorProxyPostHC
    implements AnimatorProxyImpl {
        private WeakReference<View> mViewRef;

        public AnimatorProxyPostHC(View view) {
            this.mViewRef = new WeakReference<View>(view);
        }

        @Override
        public float getAlpha() {
            View view = (View)this.mViewRef.get();
            if (view != null) {
                return view.getAlpha();
            }
            return 1.0f;
        }

        @Override
        public void setAlpha(float f) {
            View view = (View)this.mViewRef.get();
            if (view != null) {
                view.setAlpha(f);
            }
        }

        @Override
        public float getTranslationX() {
            View view = (View)this.mViewRef.get();
            if (view != null) {
                return view.getTranslationX();
            }
            return 0.0f;
        }

        @Override
        public void setTranslationX(float f) {
            View view = (View)this.mViewRef.get();
            if (view != null) {
                view.setTranslationX(f);
            }
        }

        @Override
        public float getTranslationY() {
            View view = (View)this.mViewRef.get();
            if (view != null) {
                return view.getTranslationY();
            }
            return 0.0f;
        }

        @Override
        public void setTranslationY(float f) {
            View view = (View)this.mViewRef.get();
            if (view != null) {
                view.setTranslationY(f);
            }
        }

        @Override
        public View getView() {
            return (View)this.mViewRef.get();
        }
    }

    private static class AnimatorProxyPreHC
    extends Animation
    implements AnimatorProxyImpl {
        private WeakReference<View> mViewRef;
        private final RectF mBefore = new RectF();
        private final RectF mAfter = new RectF();
        private final Matrix mTempMatrix = new Matrix();
        private float mAlpha = 1.0f;
        private float mTranslationX;
        private float mTranslationY;

        public AnimatorProxyPreHC(View view) {
            this.loadCurrentTransformation(view);
            this.setDuration(0L);
            this.setFillAfter(true);
            view.setAnimation((Animation)this);
            this.mViewRef = new WeakReference<View>(view);
        }

        private void loadCurrentTransformation(View view) {
            Animation animation = view.getAnimation();
            if (animation == null) {
                return;
            }
            Transformation transformation = new Transformation();
            float[] fArray = new float[9];
            animation.getTransformation(AnimationUtils.currentAnimationTimeMillis(), transformation);
            transformation.getMatrix().getValues(fArray);
            this.mAlpha = transformation.getAlpha();
            this.mTranslationX = fArray[2];
            this.mTranslationY = fArray[5];
        }

        private void prepareForUpdate() {
            View view = (View)this.mViewRef.get();
            if (view != null) {
                this.computeRect(this.mBefore, view);
            }
        }

        private void computeRect(RectF rectF, View view) {
            float f = view.getWidth();
            float f2 = view.getHeight();
            rectF.set(0.0f, 0.0f, f, f2);
            Matrix matrix = this.mTempMatrix;
            matrix.reset();
            this.transformMatrix(matrix, view);
            this.mTempMatrix.mapRect(rectF);
            rectF.offset((float)view.getLeft(), (float)view.getTop());
        }

        private void transformMatrix(Matrix matrix, View view) {
            matrix.postTranslate(this.mTranslationX, this.mTranslationY);
        }

        private void invalidateAfterUpdate() {
            View view = (View)this.mViewRef.get();
            if (view == null || view.getParent() == null) {
                return;
            }
            RectF rectF = this.mAfter;
            this.computeRect(rectF, view);
            rectF.union(this.mBefore);
            ((View)view.getParent()).invalidate((int)Math.floor(rectF.left), (int)Math.floor(rectF.top), (int)Math.ceil(rectF.right), (int)Math.ceil(rectF.bottom));
        }

        @Override
        public float getAlpha() {
            return this.mAlpha;
        }

        @Override
        public void setAlpha(float f) {
            if (this.mAlpha == f) {
                return;
            }
            this.mAlpha = f;
            View view = (View)this.mViewRef.get();
            if (view != null) {
                view.invalidate();
            }
        }

        @Override
        public float getTranslationX() {
            return this.mTranslationX;
        }

        @Override
        public void setTranslationX(float f) {
            if (this.mTranslationX == f) {
                return;
            }
            this.prepareForUpdate();
            this.mTranslationX = f;
            this.invalidateAfterUpdate();
        }

        @Override
        public float getTranslationY() {
            return this.mTranslationY;
        }

        @Override
        public void setTranslationY(float f) {
            if (this.mTranslationY == f) {
                return;
            }
            this.prepareForUpdate();
            this.mTranslationY = f;
            this.invalidateAfterUpdate();
        }

        @Override
        public View getView() {
            return (View)this.mViewRef.get();
        }

        protected void applyTransformation(float f, Transformation transformation) {
            View view = (View)this.mViewRef.get();
            if (view != null) {
                transformation.setAlpha(this.mAlpha);
                this.transformMatrix(transformation.getMatrix(), view);
            }
        }
    }

    private static interface AnimatorProxyImpl {
        public float getAlpha();

        public void setAlpha(float var1);

        public float getTranslationX();

        public void setTranslationX(float var1);

        public float getTranslationY();

        public void setTranslationY(float var1);

        public View getView();
    }
}

