/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.healthreport;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Scanner;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.healthreport.EnvironmentBuilder;

public class ProfileInformationCache
implements EnvironmentBuilder.ProfileInformationProvider {
    private static final String LOG_TAG = "GeckoProfileInfo";
    private static final String CACHE_FILE = "profile_info_cache.json";
    public static final int FORMAT_VERSION = 3;
    protected boolean initialized = false;
    protected boolean needsWrite = false;
    protected final File file;
    private volatile boolean blocklistEnabled = true;
    private volatile boolean telemetryEnabled = false;
    private volatile boolean isAcceptLangUserSet = false;
    private volatile long profileCreationTime = 0L;
    private volatile String distribution = "";
    private volatile String osLocale = "";
    private volatile String appLocale = "";
    private volatile JSONObject addons = null;

    public ProfileInformationCache(String string2) {
        this.file = new File(string2 + File.separator + CACHE_FILE);
        Logger.pii(LOG_TAG, "Using " + this.file.getAbsolutePath() + " for profile information cache.");
    }

    public synchronized void beginInitialization() {
        this.initialized = false;
        this.needsWrite = true;
    }

    public JSONObject toJSON() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("version", 3);
            jSONObject.put("blocklist", this.blocklistEnabled);
            jSONObject.put("telemetry", this.telemetryEnabled);
            jSONObject.put("isAcceptLangUserSet", this.isAcceptLangUserSet);
            jSONObject.put("profileCreated", this.profileCreationTime);
            jSONObject.put("osLocale", (Object)this.osLocale);
            jSONObject.put("appLocale", (Object)this.appLocale);
            jSONObject.put("distribution", (Object)this.distribution);
            jSONObject.put("addons", (Object)this.addons);
        }
        catch (JSONException jSONException) {
            return null;
        }
        return jSONObject;
    }

    private boolean fromJSON(JSONObject jSONObject) throws JSONException {
        int n = jSONObject.optInt("version", 1);
        switch (n) {
            case 3: {
                this.blocklistEnabled = jSONObject.getBoolean("blocklist");
                this.telemetryEnabled = jSONObject.getBoolean("telemetry");
                this.isAcceptLangUserSet = jSONObject.getBoolean("isAcceptLangUserSet");
                this.profileCreationTime = jSONObject.getLong("profileCreated");
                this.addons = jSONObject.getJSONObject("addons");
                this.distribution = jSONObject.getString("distribution");
                this.osLocale = jSONObject.getString("osLocale");
                this.appLocale = jSONObject.getString("appLocale");
                return true;
            }
        }
        Logger.warn(LOG_TAG, "Unable to restore from version " + n + " PIC file: expecting " + 3);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSONObject readFromFile() throws FileNotFoundException, JSONException {
        try (Scanner scanner = null;){
            scanner = new Scanner(this.file, "UTF-8");
            String string2 = scanner.useDelimiter("\\A").next();
            JSONObject jSONObject = new JSONObject(string2);
            return jSONObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeToFile(JSONObject jSONObject) throws IOException {
        Logger.debug(LOG_TAG, "Writing profile information.");
        Logger.pii(LOG_TAG, "Writing to file: " + this.file.getAbsolutePath());
        FileOutputStream fileOutputStream = new FileOutputStream(this.file);
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF-8"));){
            outputStreamWriter.append(jSONObject.toString());
            this.needsWrite = false;
        }
    }

    public synchronized void completeInitialization() throws IOException {
        this.initialized = true;
        if (!this.needsWrite) {
            Logger.debug(LOG_TAG, "No write needed.");
            return;
        }
        JSONObject jSONObject = this.toJSON();
        if (jSONObject == null) {
            throw new IOException("Couldn't serialize JSON.");
        }
        this.writeToFile(jSONObject);
    }

    public synchronized boolean restoreUnlessInitialized() {
        if (this.initialized) {
            return true;
        }
        if (!this.file.exists()) {
            return false;
        }
        Logger.info(LOG_TAG, "Restoring ProfileInformationCache from file.");
        Logger.pii(LOG_TAG, "Restoring from file: " + this.file.getAbsolutePath());
        try {
            if (!this.fromJSON(this.readFromFile())) {
                return false;
            }
            this.initialized = true;
            this.needsWrite = false;
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (JSONException jSONException) {
            Logger.warn(LOG_TAG, "Malformed ProfileInformationCache. Not restoring.");
            return false;
        }
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized.");
        }
    }

    @Override
    public boolean isBlocklistEnabled() {
        this.ensureInitialized();
        return this.blocklistEnabled;
    }

    public void setBlocklistEnabled(boolean bl) {
        Logger.debug(LOG_TAG, "Setting blocklist enabled: " + bl);
        this.blocklistEnabled = bl;
        this.needsWrite = true;
    }

    @Override
    public boolean isTelemetryEnabled() {
        this.ensureInitialized();
        return this.telemetryEnabled;
    }

    public void setTelemetryEnabled(boolean bl) {
        Logger.debug(LOG_TAG, "Setting telemetry enabled: " + bl);
        this.telemetryEnabled = bl;
        this.needsWrite = true;
    }

    @Override
    public boolean isAcceptLangUserSet() {
        this.ensureInitialized();
        return this.isAcceptLangUserSet;
    }

    public void setAcceptLangUserSet(boolean bl) {
        Logger.debug(LOG_TAG, "Setting accept-lang as user-set: " + bl);
        this.isAcceptLangUserSet = bl;
        this.needsWrite = true;
    }

    @Override
    public long getProfileCreationTime() {
        this.ensureInitialized();
        return this.profileCreationTime;
    }

    public void setProfileCreationTime(long l) {
        Logger.debug(LOG_TAG, "Setting profile creation time: " + l);
        this.profileCreationTime = l;
        this.needsWrite = true;
    }

    @Override
    public String getDistributionString() {
        this.ensureInitialized();
        return this.distribution;
    }

    public void setDistributionString(String string2, String string3) {
        Logger.debug(LOG_TAG, "Setting distribution: " + string2 + ", " + string3);
        this.distribution = string2 + ":" + string3;
        this.needsWrite = true;
    }

    @Override
    public String getAppLocale() {
        this.ensureInitialized();
        return this.appLocale;
    }

    public void setAppLocale(String string2) {
        if (string2.equalsIgnoreCase(this.appLocale)) {
            return;
        }
        Logger.debug(LOG_TAG, "Setting app locale: " + string2);
        this.appLocale = string2.toLowerCase(Locale.US);
        this.needsWrite = true;
    }

    @Override
    public String getOSLocale() {
        this.ensureInitialized();
        return this.osLocale;
    }

    public void setOSLocale(String string2) {
        if (string2.equalsIgnoreCase(this.osLocale)) {
            return;
        }
        Logger.debug(LOG_TAG, "Setting OS locale: " + string2);
        this.osLocale = string2.toLowerCase(Locale.US);
        this.needsWrite = true;
    }

    public boolean updateLocales(String string2, String string3) {
        if (this.osLocale.equalsIgnoreCase(string2) && (string3 == null || this.appLocale.equalsIgnoreCase(string3))) {
            return false;
        }
        this.setOSLocale(string2);
        if (string3 != null) {
            this.setAppLocale(string3);
        }
        return true;
    }

    @Override
    public JSONObject getAddonsJSON() {
        this.ensureInitialized();
        return this.addons;
    }

    public void updateJSONForAddon(String string2, String string3) throws Exception {
        this.addons.put(string2, (Object)new JSONObject(string3));
        this.needsWrite = true;
    }

    public void removeAddon(String string2) {
        if (null != this.addons.remove(string2)) {
            this.needsWrite = true;
        }
    }

    public void updateJSONForAddon(String string2, JSONObject jSONObject) {
        if (this.addons == null) {
            throw new IllegalStateException("Cannot incrementally update add-ons without first initializing.");
        }
        try {
            this.addons.put(string2, (Object)jSONObject);
            this.needsWrite = true;
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Unexpected failure updating JSON for add-on.", exception);
        }
    }

    public void setJSONForAddons(String string2) throws Exception {
        this.addons = new JSONObject(string2);
        this.needsWrite = true;
    }

    public void setJSONForAddons(JSONObject jSONObject) {
        this.addons = jSONObject;
        this.needsWrite = true;
    }
}

