/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.graphics.RectF;
import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.mozilla.gecko.gfx.CairoImage;
import org.mozilla.gecko.gfx.Layer;
import org.mozilla.gecko.gfx.TileLayer;

public class NinePatchTileLayer
extends TileLayer {
    private static final int PATCH_SIZE = 16;
    private static final int TEXTURE_SIZE = 64;

    public NinePatchTileLayer(CairoImage cairoImage) {
        super(cairoImage, TileLayer.PaintMode.NORMAL);
    }

    @Override
    public void draw(Layer.RenderContext renderContext) {
        if (!this.initialized()) {
            return;
        }
        GLES20.glBlendFunc((int)770, (int)771);
        GLES20.glEnable((int)3042);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.getTextureID());
        this.drawPatches(renderContext);
    }

    private void drawPatches(Layer.RenderContext renderContext) {
        RectF rectF = renderContext.pageRect;
        this.drawPatch(renderContext, 0, 48, rectF.left - 16.0f, rectF.top - 16.0f, 16.0f, 16.0f);
        this.drawPatch(renderContext, 16, 48, rectF.left, rectF.top - 16.0f, rectF.width(), 16.0f);
        this.drawPatch(renderContext, 32, 48, rectF.right, rectF.top - 16.0f, 16.0f, 16.0f);
        this.drawPatch(renderContext, 0, 32, rectF.left - 16.0f, rectF.top, 16.0f, rectF.height());
        this.drawPatch(renderContext, 32, 32, rectF.right, rectF.top, 16.0f, rectF.height());
        this.drawPatch(renderContext, 0, 16, rectF.left - 16.0f, rectF.bottom, 16.0f, 16.0f);
        this.drawPatch(renderContext, 16, 16, rectF.left, rectF.bottom, rectF.width(), 16.0f);
        this.drawPatch(renderContext, 32, 16, rectF.right, rectF.bottom, 16.0f, 16.0f);
    }

    private void drawPatch(Layer.RenderContext renderContext, int n, int n2, float f, float f2, float f3, float f4) {
        RectF rectF = renderContext.viewport;
        float f5 = rectF.height();
        float f6 = f - rectF.left - renderContext.offset.x;
        float f7 = f5 - (f2 + f4 - rectF.top) - renderContext.offset.y;
        float[] fArray = new float[]{f6 / rectF.width(), f7 / rectF.height(), 0.0f, (float)n / 64.0f, (float)n2 / 64.0f, f6 / rectF.width(), (f7 + f4) / rectF.height(), 0.0f, (float)n / 64.0f, (float)(n2 + 16) / 64.0f, (f6 + f3) / rectF.width(), f7 / rectF.height(), 0.0f, (float)(n + 16) / 64.0f, (float)n2 / 64.0f, (f6 + f3) / rectF.width(), (f7 + f4) / rectF.height(), 0.0f, (float)(n + 16) / 64.0f, (float)(n2 + 16) / 64.0f};
        FloatBuffer floatBuffer = renderContext.coordBuffer;
        int n3 = renderContext.positionHandle;
        int n4 = renderContext.textureHandle;
        floatBuffer.position(0);
        floatBuffer.put(fArray);
        GLES20.glBindBuffer((int)34962, (int)0);
        floatBuffer.position(0);
        GLES20.glVertexAttribPointer((int)n3, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)floatBuffer);
        floatBuffer.position(3);
        GLES20.glVertexAttribPointer((int)n4, (int)2, (int)5126, (boolean)false, (int)20, (Buffer)floatBuffer);
        GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
    }
}

