/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.app.Activity;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.AsyncTaskLoader;
import android.support.v4.content.Loader;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.PrefsHelper;
import org.mozilla.gecko.R;
import org.mozilla.gecko.SuggestClient;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.home.HomeFragment;
import org.mozilla.gecko.home.HomeListView;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.home.MultiTypeCursorAdapter;
import org.mozilla.gecko.home.SearchEngine;
import org.mozilla.gecko.home.SearchEngineRow;
import org.mozilla.gecko.home.SearchLoader;
import org.mozilla.gecko.home.TwoLinePageRow;
import org.mozilla.gecko.mozglue.RobocopTarget;
import org.mozilla.gecko.toolbar.AutocompleteHandler;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.StringUtils;
import org.mozilla.gecko.util.ThreadUtils;

public class BrowserSearch
extends HomeFragment
implements GeckoEventListener {
    private static final String LOGTAG = "GeckoBrowserSearch";
    private static final int LOADER_ID_SEARCH = 0;
    private static final int LOADER_ID_SUGGESTION = 1;
    private static final int SUGGESTION_TIMEOUT = 3000;
    private static final int SUGGESTION_MAX = 3;
    private static final int MAX_AUTOCOMPLETE_SEARCH = 20;
    private static final int HTTPS_PREFIX_LENGTH = 9;
    private static final int ANIMATION_DURATION = 250;
    private volatile String mSearchTerm = "";
    private SearchAdapter mAdapter;
    private LinearLayout mView;
    private HomeListView mList;
    private volatile SuggestClient mSuggestClient;
    private List<SearchEngine> mSearchEngines;
    private Locale mLastLocale;
    private boolean mSuggestionsEnabled;
    private CursorLoaderCallbacks mCursorLoaderCallbacks;
    private SuggestionLoaderCallbacks mSuggestionLoaderCallbacks;
    private AutocompleteHandler mAutocompleteHandler;
    private OnSearchListener mSearchListener;
    private OnEditSuggestionListener mEditSuggestionListener;
    private boolean mAnimateSuggestions;
    private View mSuggestionsOptInPrompt;

    public static BrowserSearch newInstance() {
        BrowserSearch browserSearch = new BrowserSearch();
        Bundle bundle = new Bundle();
        bundle.putBoolean("canLoad", true);
        browserSearch.setArguments(bundle);
        return browserSearch;
    }

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            this.mSearchListener = (OnSearchListener)activity;
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException(activity.toString() + " must implement BrowserSearch.OnSearchListener");
        }
        try {
            this.mEditSuggestionListener = (OnEditSuggestionListener)activity;
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException(activity.toString() + " must implement BrowserSearch.OnEditSuggestionListener");
        }
    }

    @Override
    public void onDetach() {
        super.onDetach();
        this.mAutocompleteHandler = null;
        this.mSearchListener = null;
        this.mEditSuggestionListener = null;
    }

    @Override
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.mSearchEngines = new ArrayList<SearchEngine>();
    }

    public void onDestroy() {
        super.onDestroy();
        this.mSearchEngines = null;
    }

    public void onStart() {
        super.onStart();
        this.getActivity().getWindow().setSoftInputMode(48);
    }

    public void onStop() {
        super.onStop();
        this.getActivity().getWindow().setSoftInputMode(16);
    }

    public void onResume() {
        super.onResume();
        if (this.mSearchEngines.isEmpty() || !Locale.getDefault().equals(this.mLastLocale)) {
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("SearchEngines:GetVisible", null));
        }
        Telemetry.startUISession(TelemetryContract.Session.FRECENCY);
    }

    public void onPause() {
        super.onPause();
        Telemetry.stopUISession(TelemetryContract.Session.FRECENCY);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        this.mView = (LinearLayout)layoutInflater.inflate(R.layout.browser_search, viewGroup, false);
        this.mList = (HomeListView)this.mView.findViewById(R.id.home_list_view);
        return this.mView;
    }

    public void onDestroyView() {
        super.onDestroyView();
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "SearchEngines:Data");
        this.mList.setAdapter(null);
        this.mList = null;
        this.mView = null;
        this.mSuggestionsOptInPrompt = null;
        this.mSuggestClient = null;
    }

    public void onViewCreated(View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.mList.setTag("browser_search");
        this.mList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                if (view instanceof SearchEngineRow) {
                    ((SearchEngineRow)view).performUserEnteredSearch();
                    return;
                }
                Cursor cursor = BrowserSearch.this.mAdapter.getCursor(n -= BrowserSearch.this.getSuggestEngineCount());
                String string2 = cursor.getString(cursor.getColumnIndexOrThrow("url"));
                Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.LIST_ITEM);
                BrowserSearch.this.mUrlOpenListener.onUrlOpen(string2, EnumSet.of(HomePager.OnUrlOpenListener.Flags.ALLOW_SWITCH_TO_TAB));
            }
        });
        this.mList.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener(){

            public boolean onItemLongClick(AdapterView<?> adapterView, View view, int n, long l) {
                if (view instanceof SearchEngineRow) {
                    return true;
                }
                return BrowserSearch.this.mList.onItemLongClick(adapterView, view, n -= BrowserSearch.this.getSuggestEngineCount(), l);
            }
        });
        ListSelectionListener listSelectionListener = new ListSelectionListener();
        this.mList.setOnItemSelectedListener(listSelectionListener);
        this.mList.setOnFocusChangeListener(listSelectionListener);
        this.mList.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View view, int n, KeyEvent keyEvent) {
                View view2 = BrowserSearch.this.mList.getSelectedView();
                if (view2 instanceof SearchEngineRow) {
                    return view2.onKeyDown(n, keyEvent);
                }
                return false;
            }
        });
        this.registerForContextMenu((View)this.mList);
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "SearchEngines:Data");
    }

    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        this.mAdapter = new SearchAdapter((Context)this.getActivity());
        this.mList.setAdapter((ListAdapter)this.mAdapter);
        this.mSuggestionLoaderCallbacks = null;
        this.mCursorLoaderCallbacks = new CursorLoaderCallbacks();
        this.loadIfVisible();
    }

    public void handleMessage(String string2, final JSONObject jSONObject) {
        if (string2.equals("SearchEngines:Data")) {
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    BrowserSearch.this.setSearchEngines(jSONObject);
                }
            });
        }
    }

    @Override
    protected void load() {
        SearchLoader.init(this.getLoaderManager(), 0, this.mCursorLoaderCallbacks, this.mSearchTerm);
    }

    private void handleAutocomplete(String string2, Cursor cursor) {
        if (cursor == null || this.mAutocompleteHandler == null || TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        boolean bl = string2.indexOf(47) > 0;
        String string3 = this.findAutocompletion(string2, cursor, bl);
        if (string3 == null || this.mAutocompleteHandler == null) {
            return;
        }
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Session:Prefetch", "http://" + string3));
        this.mAutocompleteHandler.onAutocomplete(string3);
        this.mAutocompleteHandler = null;
    }

    private static String uriSubstringUpToMatchedPath(String string2, int n, int n2) {
        int n3 = string2.length();
        int n4 = string2.indexOf(47, n2);
        if (n4 != -1) {
            if (++n4 < n) {
                return string2;
            }
        } else {
            n4 = string2.indexOf(63, n2);
            if (n4 == -1) {
                n4 = string2.indexOf(35, n2);
            }
            if (n4 == -1) {
                n4 = n3;
            }
        }
        return string2.substring(n, n4);
    }

    private String findAutocompletion(String string2, Cursor cursor, boolean bl) {
        if (!cursor.moveToFirst()) {
            return null;
        }
        int n = string2.length();
        int n2 = cursor.getColumnIndexOrThrow("url");
        int n3 = 0;
        do {
            int n4;
            String string3 = cursor.getString(n2);
            if (n3 == 0) {
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Session:Prefetch", string3.toString()));
            }
            if (string3.startsWith(string2)) {
                return BrowserSearch.uriSubstringUpToMatchedPath(string3, 0, n > 9 ? n : 9);
            }
            Uri uri = Uri.parse((String)string3);
            String string4 = uri.getHost();
            if (string4 == null) continue;
            if (string4.startsWith(string2)) {
                return string4 + "/";
            }
            String string5 = StringUtils.stripCommonSubdomains((String)string4);
            if (string5.startsWith(string2)) {
                return string5 + "/";
            }
            ++n3;
            if (!bl || (n4 = string3.indexOf(string5)) == -1 || !string3.startsWith(string2, n4)) continue;
            return BrowserSearch.uriSubstringUpToMatchedPath(string3, n4, n4 + n);
        } while (n3 < 20 && cursor.moveToNext());
        return null;
    }

    private void filterSuggestions() {
        if (this.mSuggestClient == null || !this.mSuggestionsEnabled) {
            return;
        }
        if (this.mSuggestionLoaderCallbacks == null) {
            this.mSuggestionLoaderCallbacks = new SuggestionLoaderCallbacks();
        }
        this.getLoaderManager().restartLoader(1, null, (LoaderManager.LoaderCallbacks)this.mSuggestionLoaderCallbacks);
    }

    private void setSuggestions(ArrayList<String> arrayList) {
        ThreadUtils.assertOnUiThread();
        this.mSearchEngines.get(0).setSuggestions(arrayList);
        this.mAdapter.notifyDataSetChanged();
    }

    private void setSearchEngines(JSONObject jSONObject) {
        ThreadUtils.assertOnUiThread();
        if (this.mView == null) {
            return;
        }
        try {
            JSONObject jSONObject2 = jSONObject.getJSONObject("suggest");
            String string2 = jSONObject2.optString("engine", null);
            String string3 = jSONObject2.optString("template", null);
            boolean bl = jSONObject2.getBoolean("prompted");
            JSONArray jSONArray = jSONObject.getJSONArray("searchEngines");
            this.mSuggestionsEnabled = jSONObject2.getBoolean("enabled");
            ArrayList<SearchEngine> arrayList = new ArrayList<SearchEngine>();
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject3 = jSONArray.getJSONObject(i);
                SearchEngine searchEngine = new SearchEngine(jSONObject3);
                if (searchEngine.name.equals(string2) && string3 != null) {
                    boolean bl2;
                    arrayList.add(0, searchEngine);
                    Tab tab = Tabs.getInstance().getSelectedTab();
                    boolean bl3 = bl2 = tab != null && tab.isPrivate();
                    if (this.mSuggestClient != null || bl2) continue;
                    this.setSuggestClient(new SuggestClient((Context)this.getActivity(), string3, 3000, 3));
                    continue;
                }
                arrayList.add(searchEngine);
            }
            this.mSearchEngines = Collections.unmodifiableList(arrayList);
            this.mLastLocale = Locale.getDefault();
            if (this.mAdapter != null) {
                this.mAdapter.notifyDataSetChanged();
            }
            if (!this.mSuggestionsEnabled && !bl && this.mSuggestClient != null) {
                this.showSuggestionsOptIn();
            }
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Error getting search engine JSON", (Throwable)jSONException);
        }
        this.filterSuggestions();
    }

    @RobocopTarget
    public void setSuggestClient(SuggestClient suggestClient) {
        if (this.mSuggestClient != null) {
            throw new IllegalStateException("Can only set the SuggestClient if it has not yet been initialized!");
        }
        this.mSuggestClient = suggestClient;
    }

    private void showSuggestionsOptIn() {
        if (this.mSuggestionsOptInPrompt != null) {
            return;
        }
        this.mSuggestionsOptInPrompt = ((ViewStub)this.mView.findViewById(R.id.suggestions_opt_in_prompt)).inflate();
        TextView textView = (TextView)this.mSuggestionsOptInPrompt.findViewById(R.id.suggestions_prompt_title);
        textView.setText((CharSequence)this.getResources().getString(R.string.suggestions_prompt));
        final View view = this.mSuggestionsOptInPrompt.findViewById(R.id.suggestions_prompt_yes);
        final View view2 = this.mSuggestionsOptInPrompt.findViewById(R.id.suggestions_prompt_no);
        View.OnClickListener onClickListener = new View.OnClickListener(){

            public void onClick(View view3) {
                view.setOnClickListener(null);
                view2.setOnClickListener(null);
                BrowserSearch.this.setSuggestionsEnabled(view3 == view);
            }
        };
        view.setOnClickListener(onClickListener);
        view2.setOnClickListener(onClickListener);
        View view3 = this.mSuggestionsOptInPrompt.findViewById(R.id.prompt);
        view3.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view2, boolean bl) {
                if (bl) {
                    view.requestFocus();
                }
            }
        });
    }

    private void setSuggestionsEnabled(final boolean bl) {
        if (this.mSuggestionsOptInPrompt == null) {
            return;
        }
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SuggestClient suggestClient = BrowserSearch.this.mSuggestClient;
                if (suggestClient != null) {
                    suggestClient.query(BrowserSearch.this.mSearchTerm);
                }
            }
        });
        PrefsHelper.setPref("browser.search.suggest.enabled", bl);
        TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, (float)this.mSuggestionsOptInPrompt.getWidth(), 0.0f, 0.0f);
        translateAnimation.setDuration(250L);
        translateAnimation.setInterpolator((Interpolator)new AccelerateInterpolator());
        translateAnimation.setFillAfter(true);
        View view = this.mSuggestionsOptInPrompt.findViewById(R.id.prompt);
        TranslateAnimation translateAnimation2 = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)(-1 * this.mSuggestionsOptInPrompt.getHeight()));
        translateAnimation2.setDuration(250L);
        translateAnimation2.setFillAfter(true);
        translateAnimation2.setStartOffset(translateAnimation.getDuration());
        translateAnimation2.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                ((BrowserSearch)BrowserSearch.this).mView.getLayoutParams().height = BrowserSearch.this.mView.getHeight() + BrowserSearch.this.mSuggestionsOptInPrompt.getHeight();
                BrowserSearch.this.mView.requestLayout();
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                BrowserSearch.this.mView.post(new Runnable(){

                    @Override
                    public void run() {
                        BrowserSearch.this.mView.removeView(BrowserSearch.this.mSuggestionsOptInPrompt);
                        BrowserSearch.this.mList.clearAnimation();
                        BrowserSearch.this.mSuggestionsOptInPrompt = null;
                        if (bl) {
                            ((BrowserSearch)BrowserSearch.this).mView.getLayoutParams().height = -1;
                            BrowserSearch.this.mSuggestionsEnabled = bl;
                            BrowserSearch.this.mAnimateSuggestions = true;
                            BrowserSearch.this.mAdapter.notifyDataSetChanged();
                            BrowserSearch.this.filterSuggestions();
                        }
                    }
                });
            }
        });
        view.startAnimation((Animation)translateAnimation);
        this.mSuggestionsOptInPrompt.startAnimation((Animation)translateAnimation2);
        this.mList.startAnimation((Animation)translateAnimation2);
    }

    private int getSuggestEngineCount() {
        return TextUtils.isEmpty((CharSequence)this.mSearchTerm) || this.mSuggestClient == null || !this.mSuggestionsEnabled ? 0 : 1;
    }

    private void restartSearchLoader() {
        SearchLoader.restart(this.getLoaderManager(), 0, this.mCursorLoaderCallbacks, this.mSearchTerm);
    }

    private void initSearchLoader() {
        SearchLoader.init(this.getLoaderManager(), 0, this.mCursorLoaderCallbacks, this.mSearchTerm);
    }

    public void filter(String string2, AutocompleteHandler autocompleteHandler) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        boolean bl = !TextUtils.equals((CharSequence)this.mSearchTerm, (CharSequence)string2);
        this.mSearchTerm = string2;
        this.mAutocompleteHandler = autocompleteHandler;
        if (this.isVisible()) {
            if (bl) {
                this.mAdapter.notifyDataSetChanged();
                this.restartSearchLoader();
                this.filterSuggestions();
            } else {
                this.initSearchLoader();
            }
        }
    }

    public static class HomeSearchListView
    extends HomeListView {
        public HomeSearchListView(Context context, AttributeSet attributeSet) {
            this(context, attributeSet, R.attr.homeListViewStyle);
        }

        public HomeSearchListView(Context context, AttributeSet attributeSet, int n) {
            super(context, attributeSet, n);
        }

        public boolean onTouchEvent(MotionEvent motionEvent) {
            if (motionEvent.getActionMasked() == 0) {
                this.requestFocus();
            }
            return super.onTouchEvent(motionEvent);
        }
    }

    private static class ListSelectionListener
    implements View.OnFocusChangeListener,
    AdapterView.OnItemSelectedListener {
        private SearchEngineRow mSelectedEngineRow;

        private ListSelectionListener() {
        }

        public void onFocusChange(View view, boolean bl) {
            if (bl) {
                View view2 = ((ListView)view).getSelectedView();
                if (view2 != null) {
                    this.selectRow(view2);
                }
            } else {
                this.deselectRow();
            }
        }

        public void onItemSelected(AdapterView<?> adapterView, View view, int n, long l) {
            this.deselectRow();
            this.selectRow(view);
        }

        public void onNothingSelected(AdapterView<?> adapterView) {
            this.deselectRow();
        }

        private void selectRow(View view) {
            if (view instanceof SearchEngineRow) {
                this.mSelectedEngineRow = (SearchEngineRow)view;
                this.mSelectedEngineRow.onSelected();
            }
        }

        private void deselectRow() {
            if (this.mSelectedEngineRow != null) {
                this.mSelectedEngineRow.onDeselected();
                this.mSelectedEngineRow = null;
            }
        }
    }

    private class SuggestionLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<ArrayList<String>> {
        private SuggestionLoaderCallbacks() {
        }

        public Loader<ArrayList<String>> onCreateLoader(int n, Bundle bundle) {
            return new SuggestionAsyncLoader((Context)BrowserSearch.this.getActivity(), BrowserSearch.this.mSuggestClient, BrowserSearch.this.mSearchTerm);
        }

        public void onLoadFinished(Loader<ArrayList<String>> loader, ArrayList<String> arrayList) {
            BrowserSearch.this.setSuggestions(arrayList);
        }

        public void onLoaderReset(Loader<ArrayList<String>> loader) {
            BrowserSearch.this.setSuggestions(new ArrayList());
        }
    }

    private class CursorLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<Cursor> {
        private CursorLoaderCallbacks() {
        }

        public Loader<Cursor> onCreateLoader(int n, Bundle bundle) {
            return SearchLoader.createInstance((Context)BrowserSearch.this.getActivity(), bundle);
        }

        public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
            BrowserSearch.this.mAdapter.swapCursor(cursor);
            SearchLoader.SearchCursorLoader searchCursorLoader = (SearchLoader.SearchCursorLoader)loader;
            BrowserSearch.this.handleAutocomplete(searchCursorLoader.getSearchTerm(), cursor);
        }

        public void onLoaderReset(Loader<Cursor> loader) {
            BrowserSearch.this.mAdapter.swapCursor(null);
        }
    }

    private class SearchAdapter
    extends MultiTypeCursorAdapter {
        private static final int ROW_SEARCH = 0;
        private static final int ROW_STANDARD = 1;
        private static final int ROW_SUGGEST = 2;

        public SearchAdapter(Context context) {
            super(context, null, new int[]{1, 0, 2}, new int[]{R.layout.home_item_row, R.layout.home_search_item_row, R.layout.home_search_item_row});
        }

        public int getItemViewType(int n) {
            int n2 = this.getEngineIndex(n);
            if (n2 == -1) {
                return 1;
            }
            if (n2 == 0 && BrowserSearch.this.mSuggestionsEnabled) {
                return 2;
            }
            return 0;
        }

        public boolean isEnabled(int n) {
            if (!BrowserSearch.this.mList.isInTouchMode()) {
                return true;
            }
            int n2 = this.getEngineIndex(n);
            if (n2 != -1) {
                return !((SearchEngine)BrowserSearch.this.mSearchEngines.get(n2)).hasSuggestions();
            }
            return true;
        }

        public int getCount() {
            int n = super.getCount();
            if (TextUtils.isEmpty((CharSequence)BrowserSearch.this.mSearchTerm)) {
                return n;
            }
            return n + BrowserSearch.this.mSearchEngines.size();
        }

        @Override
        public void bindView(View view, Context context, int n) {
            int n2 = this.getItemViewType(n);
            if (n2 == 0 || n2 == 2) {
                SearchEngineRow searchEngineRow = (SearchEngineRow)view;
                searchEngineRow.setOnUrlOpenListener(BrowserSearch.this.mUrlOpenListener);
                searchEngineRow.setOnSearchListener(BrowserSearch.this.mSearchListener);
                searchEngineRow.setOnEditSuggestionListener(BrowserSearch.this.mEditSuggestionListener);
                searchEngineRow.setSearchTerm(BrowserSearch.this.mSearchTerm);
                SearchEngine searchEngine = (SearchEngine)BrowserSearch.this.mSearchEngines.get(this.getEngineIndex(n));
                boolean bl = BrowserSearch.this.mAnimateSuggestions && searchEngine.hasSuggestions();
                searchEngineRow.updateFromSearchEngine(searchEngine, bl);
                if (bl) {
                    BrowserSearch.this.mAnimateSuggestions = false;
                }
            } else {
                Cursor cursor = this.getCursor(n -= BrowserSearch.this.getSuggestEngineCount());
                TwoLinePageRow twoLinePageRow = (TwoLinePageRow)view;
                twoLinePageRow.updateFromCursor(cursor);
            }
        }

        private int getEngineIndex(int n) {
            int n2 = super.getCount();
            int n3 = BrowserSearch.this.getSuggestEngineCount();
            if (n < n3) {
                return n;
            }
            if (n - n3 < n2) {
                return -1;
            }
            return n - n2;
        }
    }

    private static class SuggestionAsyncLoader
    extends AsyncTaskLoader<ArrayList<String>> {
        private final SuggestClient mSuggestClient;
        private final String mSearchTerm;
        private ArrayList<String> mSuggestions;

        public SuggestionAsyncLoader(Context context, SuggestClient suggestClient, String string2) {
            super(context);
            this.mSuggestClient = suggestClient;
            this.mSearchTerm = string2;
        }

        public ArrayList<String> loadInBackground() {
            return this.mSuggestClient.query(this.mSearchTerm);
        }

        public void deliverResult(ArrayList<String> arrayList) {
            this.mSuggestions = arrayList;
            if (this.isStarted()) {
                super.deliverResult(this.mSuggestions);
            }
        }

        protected void onStartLoading() {
            if (this.mSuggestions != null) {
                this.deliverResult(this.mSuggestions);
            }
            if (this.takeContentChanged() || this.mSuggestions == null) {
                this.forceLoad();
            }
        }

        protected void onStopLoading() {
            this.cancelLoad();
        }

        protected void onReset() {
            super.onReset();
            this.onStopLoading();
            this.mSuggestions = null;
        }
    }

    public static interface OnEditSuggestionListener {
        public void onEditSuggestion(String var1);
    }

    public static interface OnSearchListener {
        public void onSearch(SearchEngine var1, String var2);
    }
}

