/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.view.PagerTabStrip;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewTreeObserver;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorSet;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.view.ViewHelper;
import org.mozilla.gecko.R;
import org.mozilla.gecko.animation.BounceAnimator;

class HomePagerTabStrip
extends PagerTabStrip {
    private static final String LOGTAG = "PagerTabStrip";
    private static final int ANIMATION_DELAY_MS = 250;
    private static final int ALPHA_MS = 10;
    private static final int BOUNCE1_MS = 350;
    private static final int BOUNCE2_MS = 200;
    private static final int BOUNCE3_MS = 100;
    private static final int BOUNCE4_MS = 100;
    private static final int INIT_OFFSET = 100;

    public HomePagerTabStrip(Context context) {
        super(context);
    }

    public HomePagerTabStrip(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.HomePagerTabStrip);
        int n = typedArray.getColor(0, 0);
        typedArray.recycle();
        this.setTabIndicatorColor(n);
        this.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)new PreDrawListener());
    }

    public int getPaddingBottom() {
        return 0;
    }

    private void animateTitles() {
        View view = this.getChildAt(0);
        View view2 = this.getChildAt(this.getChildCount() - 1);
        if (view == null || view2 == null) {
            return;
        }
        ViewHelper.setTranslationX((View)view, (float)-100.0f);
        ViewHelper.setAlpha((View)view, (float)0.0f);
        ViewHelper.setTranslationX((View)view2, (float)100.0f);
        ViewHelper.setAlpha((View)view2, (float)0.0f);
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{1.0f});
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)view2, (String)"alpha", (float[])new float[]{1.0f});
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator, objectAnimator2});
        animatorSet.setStartDelay(250L);
        animatorSet.setDuration(10L);
        float f = (float)this.getWidth() / 100.0f;
        BounceAnimator bounceAnimator = new BounceAnimator(view, "translationX");
        bounceAnimator.queue(new BounceAnimator.Attributes(f, 350));
        bounceAnimator.queue(new BounceAnimator.Attributes(-f / 4.0f, 200));
        bounceAnimator.queue(new BounceAnimator.Attributes(0.0f, 100));
        bounceAnimator.setStartDelay(250L);
        BounceAnimator bounceAnimator2 = new BounceAnimator(view2, "translationX");
        bounceAnimator2.queue(new BounceAnimator.Attributes(-f, 350));
        bounceAnimator2.queue(new BounceAnimator.Attributes(f / 4.0f, 200));
        bounceAnimator2.queue(new BounceAnimator.Attributes(0.0f, 100));
        bounceAnimator2.setStartDelay(250L);
        animatorSet.start();
        bounceAnimator.start();
        bounceAnimator2.start();
    }

    private class PreDrawListener
    implements ViewTreeObserver.OnPreDrawListener {
        private PreDrawListener() {
        }

        public boolean onPreDraw() {
            HomePagerTabStrip.this.animateTitles();
            HomePagerTabStrip.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
            return true;
        }
    }
}

