/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.util.HashMap;
import org.mozilla.gecko.R;
import org.mozilla.gecko.fxa.AccountLoader;
import org.mozilla.gecko.fxa.FirefoxAccounts;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.home.HomeFragment;
import org.mozilla.gecko.home.RemoteTabsExpandableListFragment;
import org.mozilla.gecko.home.RemoteTabsStaticFragment;

public class RemoteTabsPanel
extends HomeFragment {
    private static final String LOGTAG = "GeckoRemoteTabsPanel";
    private static final int LOADER_ID_ACCOUNT = 0;
    private AccountLoaderCallbacks mAccountLoaderCallbacks;
    private Fragment mCurrentFragment;
    private final HashMap<State.Action, Fragment> mFragmentCache = new HashMap();

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return layoutInflater.inflate(R.layout.home_remote_tabs_panel, viewGroup, false);
    }

    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        this.mAccountLoaderCallbacks = new AccountLoaderCallbacks();
        this.loadIfVisible();
    }

    @Override
    public void load() {
        this.getLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)this.mAccountLoaderCallbacks);
    }

    private void showSubPanel(Fragment fragment) {
        if (this.mCurrentFragment == fragment) {
            return;
        }
        this.mCurrentFragment = fragment;
        Bundle bundle = fragment.getArguments();
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putBoolean("canLoad", this.getCanLoadHint());
        fragment.setArguments(bundle);
        this.getChildFragmentManager().beginTransaction().addToBackStack(null).replace(R.id.remote_tabs_container, fragment).commitAllowingStateLoss();
    }

    private State.Action getActionNeeded(Account account) {
        if (account == null) {
            return null;
        }
        if ("org.mozilla.fennec_sync".equals(account.type)) {
            return State.Action.None;
        }
        if (!"org.mozilla.fennec_fxaccount".equals(account.type)) {
            Log.wtf((String)LOGTAG, (String)"Non Sync, non Firefox Android Account returned by AccountLoader; returning null.");
            return null;
        }
        State state = FirefoxAccounts.getFirefoxAccountState((Context)this.getActivity());
        if (state == null) {
            Log.wtf((String)LOGTAG, (String)"Firefox Account with null state found; offering needs password.");
            return State.Action.NeedsPassword;
        }
        State.Action action = state.getNeededAction();
        if (action == null) {
            Log.wtf((String)LOGTAG, (String)"Firefox Account with non-null state but null action needed; offering needs password.");
            return State.Action.NeedsPassword;
        }
        return action;
    }

    private Fragment makeFragmentForAction(State.Action action) {
        if (action == null) {
            return RemoteTabsStaticFragment.newInstance(R.layout.remote_tabs_setup);
        }
        switch (action) {
            case None: {
                return new RemoteTabsExpandableListFragment();
            }
            case NeedsVerification: {
                return RemoteTabsStaticFragment.newInstance(R.layout.remote_tabs_needs_verification);
            }
            case NeedsPassword: {
                return RemoteTabsStaticFragment.newInstance(R.layout.remote_tabs_needs_password);
            }
            case NeedsUpgrade: {
                return RemoteTabsStaticFragment.newInstance(R.layout.remote_tabs_needs_upgrade);
            }
        }
        Log.wtf((String)LOGTAG, (String)"Got unexpected action needed; offering needs password.");
        return RemoteTabsStaticFragment.newInstance(R.layout.remote_tabs_needs_password);
    }

    private Fragment getFragmentNeeded(Account account) {
        State.Action action = this.getActionNeeded(account);
        if (!this.mFragmentCache.containsKey((Object)action)) {
            Fragment fragment = this.makeFragmentForAction(action);
            this.mFragmentCache.put(action, fragment);
        }
        return this.mFragmentCache.get((Object)action);
    }

    protected void updateUiFromAccount(Account account) {
        if (this.getView() == null) {
            return;
        }
        this.showSubPanel(this.getFragmentNeeded(account));
    }

    private class AccountLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<Account> {
        private AccountLoaderCallbacks() {
        }

        public Loader<Account> onCreateLoader(int n, Bundle bundle) {
            return new AccountLoader((Context)RemoteTabsPanel.this.getActivity());
        }

        public void onLoadFinished(Loader<Account> loader, Account account) {
            RemoteTabsPanel.this.updateUiFromAccount(account);
        }

        public void onLoaderReset(Loader<Account> loader) {
            RemoteTabsPanel.this.updateUiFromAccount(null);
        }
    }
}

