/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.overlays.service;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.util.Log;
import android.view.View;
import java.util.EnumMap;
import java.util.Map;
import org.mozilla.gecko.Assert;
import org.mozilla.gecko.overlays.service.ShareData;
import org.mozilla.gecko.overlays.service.sharemethods.AddBookmark;
import org.mozilla.gecko.overlays.service.sharemethods.AddToReadingList;
import org.mozilla.gecko.overlays.service.sharemethods.SendTab;
import org.mozilla.gecko.overlays.service.sharemethods.ShareMethod;
import org.mozilla.gecko.overlays.ui.OverlayToastHelper;
import org.mozilla.gecko.util.ThreadUtils;

public class OverlayActionService
extends Service {
    private static final String LOGTAG = "GeckoOverlayService";
    final Map<ShareMethod.Type, ShareMethod> shareTypes = new EnumMap<ShareMethod.Type, ShareMethod>(ShareMethod.Type.class);

    public IBinder onBind(Intent intent) {
        return null;
    }

    public int onStartCommand(Intent intent, int n, int n2) {
        String string2;
        if (intent == null) {
            return 2;
        }
        switch (string2 = intent.getAction()) {
            case "org.mozilla.gecko.overlays.ACTION_SHARE": {
                this.handleShare(intent);
                break;
            }
            case "org.mozilla.gecko.overlays.ACTION_PREPARE_SHARE": {
                this.initShareMethods(this.getApplicationContext());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported intent action: " + string2);
            }
        }
        return 2;
    }

    private void initShareMethods(final Context context) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                OverlayActionService.this.shareTypes.clear();
                OverlayActionService.this.shareTypes.put(ShareMethod.Type.ADD_BOOKMARK, new AddBookmark(context));
                OverlayActionService.this.shareTypes.put(ShareMethod.Type.ADD_TO_READING_LIST, new AddToReadingList(context));
                OverlayActionService.this.shareTypes.put(ShareMethod.Type.SEND_TAB, new SendTab(context));
            }
        });
    }

    public void handleShare(final Intent intent) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ShareData shareData;
                try {
                    shareData = ShareData.fromIntent(intent);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Log.e((String)OverlayActionService.LOGTAG, (String)"Error parsing share intent: ", (Throwable)illegalArgumentException);
                    return;
                }
                ShareMethod shareMethod = OverlayActionService.this.shareTypes.get((Object)shareData.shareMethodType);
                ShareMethod.Result result = shareMethod.handle(shareData);
                switch (result) {
                    case SUCCESS: {
                        OverlayToastHelper.showSuccessToast(OverlayActionService.this.getApplicationContext(), shareMethod.getSuccessMesssage());
                        break;
                    }
                    case TRANSIENT_FAILURE: {
                        View.OnClickListener onClickListener = new View.OnClickListener(){

                            public void onClick(View view) {
                                OverlayActionService.this.handleShare(intent);
                            }
                        };
                        OverlayToastHelper.showFailureToast(OverlayActionService.this.getApplicationContext(), shareMethod.getFailureMessage(), onClickListener);
                        break;
                    }
                    case PERMANENT_FAILURE: {
                        OverlayToastHelper.showFailureToast(OverlayActionService.this.getApplicationContext(), shareMethod.getFailureMessage());
                        break;
                    }
                    default: {
                        Assert.isTrue(false, "Unknown share method result code: " + (Object)((Object)result));
                    }
                }
            }
        });
    }
}

