/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.content.Context;
import android.content.Intent;
import android.preference.Preference;
import android.util.AttributeSet;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.fxa.activities.FxAccountGetStartedActivity;
import org.mozilla.gecko.sync.setup.SyncAccounts;
import org.mozilla.gecko.sync.setup.activities.SetupSyncActivity;
import org.mozilla.gecko.util.HardwareUtils;

class SyncPreference
extends Preference {
    private static final boolean DEFAULT_TO_FXA = true;
    private Context mContext;

    public SyncPreference(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
    }

    private void openSync11Settings() {
        if (SyncAccounts.syncAccountsExist(this.mContext)) {
            SyncAccounts.openSyncSettings(this.mContext);
            return;
        }
        Intent intent = new Intent(this.mContext, SetupSyncActivity.class);
        this.mContext.startActivity(intent);
    }

    private void launchFxASetup() {
        Intent intent = new Intent(this.mContext, FxAccountGetStartedActivity.class);
        intent.setFlags(0x10000000);
        if (HardwareUtils.IS_KINDLE_DEVICE) {
            intent.setFlags(65536);
        }
        this.mContext.startActivity(intent);
    }

    protected void onClick() {
        if (SyncAccounts.syncAccountsExist(this.mContext) && SyncAccounts.openSyncSettings(this.mContext) != null) {
            Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.SETTINGS, "sync_settings");
            return;
        }
        this.launchFxASetup();
        Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.SETTINGS, "sync_setup");
    }
}

